/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayPopOneNode;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=ArrayPopOneNode.class)
public final class ArrayPopOneNodeGen
extends ArrayPopOneNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayPopOneNodeGen(RubyNode array) {
        this.array_ = array;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executePopOne(DynamicObject arrayValue) {
        return this.specialization_.execute1(arrayValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ArrayPopOneNode create(RubyNode array) {
        return new ArrayPopOneNodeGen(array);
    }

    @GeneratedBy(methodName="popOne(DynamicObject, ArrayStrategy)", value=ArrayPopOneNode.class)
    private static final class PopOneNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;

        PopOneNode_(ArrayPopOneNodeGen root, ArrayStrategy strategy) {
            super(root, 2);
            this.strategy = strategy;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            return arrayValue instanceof DynamicObject && this.strategy.matches(arrayValue_ = (DynamicObject)arrayValue) && !ArrayGuards.isEmptyArray(arrayValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue) {
            if (this.strategy.matches(arrayValue) && !ArrayGuards.isEmptyArray(arrayValue)) {
                return this.root.popOne(arrayValue, this.strategy);
            }
            return this.getNext().execute1(arrayValue);
        }

        @Override
        public Object execute_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && this.strategy.matches(arrayValue_ = (DynamicObject)arrayValue) && !ArrayGuards.isEmptyArray(arrayValue_)) {
                return this.root.popOne(arrayValue_, this.strategy);
            }
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(ArrayPopOneNodeGen root, ArrayStrategy strategy) {
            return new PopOneNode_(root, strategy);
        }
    }

    @GeneratedBy(methodName="popOneEmpty(DynamicObject)", value=ArrayPopOneNode.class)
    private static final class PopOneEmptyNode_
    extends BaseNode_ {
        PopOneEmptyNode_(ArrayPopOneNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute1(DynamicObject arrayValue) {
            if (ArrayGuards.isEmptyArray(arrayValue)) {
                return this.root.popOneEmpty(arrayValue);
            }
            return this.getNext().execute1(arrayValue);
        }

        @Override
        public Object execute_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && ArrayGuards.isEmptyArray(arrayValue_ = (DynamicObject)arrayValue)) {
                return this.root.popOneEmpty(arrayValue_);
            }
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(ArrayPopOneNodeGen root) {
            return new PopOneEmptyNode_(root);
        }
    }

    @GeneratedBy(value=ArrayPopOneNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayPopOneNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue));
        }

        @Override
        public Object execute_(Object arrayValue) {
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(ArrayPopOneNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayPopOneNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayPopOneNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(Object arrayValue) {
            return this.uninitialized((Frame)null, arrayValue);
        }

        static BaseNode_ create(ArrayPopOneNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayPopOneNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayPopOneNodeGen root;

        BaseNode_(ArrayPopOneNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ArrayPopOneNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arrayValue) {
            return this.execute_(arrayValue);
        }

        public abstract Object execute_(Object var1);

        public Object execute1(DynamicObject arrayValue) {
            return this.execute_(arrayValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            return this.execute_(arrayValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue) {
            if (arrayValue instanceof DynamicObject) {
                BaseNode_ s;
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (ArrayGuards.isEmptyArray(arrayValue_)) {
                    return PopOneEmptyNode_.create(this.root);
                }
                ArrayStrategy strategy2 = ArrayStrategy.of(arrayValue_);
                if (strategy2.matches(arrayValue_) && !ArrayGuards.isEmptyArray(arrayValue_) && this.countSame(s = PopOneNode_.create(this.root, strategy2)) < 25) {
                    return s;
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

