/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.Iterables;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.GroovySystem;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;
import org.codehaus.groovy.tools.javac.JavaCompiler;
import org.codehaus.groovy.tools.javac.JavaCompilerFactory;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.classloading.GroovySystemLoaderFactory;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.GroovyCompileTransformingClassLoader;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.FileUtils;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.VersionNumber;

public class ApiGroovyCompiler
implements Compiler<GroovyJavaJointCompileSpec>,
Serializable {
    private final Compiler<JavaCompileSpec> javaCompiler;

    public ApiGroovyCompiler(Compiler<JavaCompileSpec> javaCompiler) {
        this.javaCompiler = javaCompiler;
    }

    public WorkResult execute(final GroovyJavaJointCompileSpec spec) {
        GroovySystemLoaderFactory groovySystemLoaderFactory = new GroovySystemLoaderFactory();
        ClassLoader compilerClassLoader = this.getClass().getClassLoader();
        GroovySystemLoader compilerGroovyLoader = groovySystemLoaderFactory.forClassLoader(compilerClassLoader);
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setVerbose(spec.getGroovyCompileOptions().isVerbose());
        configuration.setSourceEncoding(spec.getGroovyCompileOptions().getEncoding());
        configuration.setTargetBytecode(spec.getTargetCompatibility());
        configuration.setTargetDirectory(spec.getDestinationDir());
        this.canonicalizeValues(spec.getGroovyCompileOptions().getOptimizationOptions());
        if (spec.getGroovyCompileOptions().getConfigurationScript() != null) {
            this.applyConfigurationScript(spec.getGroovyCompileOptions().getConfigurationScript(), configuration);
        }
        try {
            configuration.setOptimizationOptions(spec.getGroovyCompileOptions().getOptimizationOptions());
        }
        catch (NoSuchMethodError ignored) {
            // empty catch block
        }
        HashMap<String, Comparable<File>> jointCompilationOptions = new HashMap<String, Comparable<File>>();
        final File stubDir = spec.getGroovyCompileOptions().getStubDir();
        stubDir.mkdirs();
        jointCompilationOptions.put("stubDir", stubDir);
        jointCompilationOptions.put("keepStubs", Boolean.valueOf(spec.getGroovyCompileOptions().isKeepStubs()));
        configuration.setJointCompilationOptions(jointCompilationOptions);
        VersionNumber version = this.parseGroovyVersion();
        Object classPathLoader = version.compareTo(VersionNumber.parse((String)"2.0")) < 0 ? new GroovyCompileTransformingClassLoader(this.getExtClassLoader(), (ClassPath)new DefaultClassPath((Iterable)spec.getCompileClasspath())) : new DefaultClassLoaderFactory().createIsolatedClassLoader((ClassPath)new DefaultClassPath((Iterable)spec.getCompileClasspath()));
        GroovyClassLoader compileClasspathClassLoader = new GroovyClassLoader(classPathLoader, null);
        GroovySystemLoader compileClasspathLoader = groovySystemLoaderFactory.forClassLoader(classPathLoader);
        FilteringClassLoader.Spec groovyCompilerClassLoaderSpec = new FilteringClassLoader.Spec();
        groovyCompilerClassLoaderSpec.allowPackage("org.codehaus.groovy");
        groovyCompilerClassLoaderSpec.allowPackage("groovy");
        groovyCompilerClassLoaderSpec.disallowClass("groovy.util.GroovyTestCase");
        groovyCompilerClassLoaderSpec.disallowPackage("groovy.servlet");
        FilteringClassLoader groovyCompilerClassLoader = new FilteringClassLoader(GroovyClassLoader.class.getClassLoader(), groovyCompilerClassLoaderSpec);
        final GroovyClassLoader astTransformClassLoader = new GroovyClassLoader((ClassLoader)groovyCompilerClassLoader, null);
        for (File file : spec.getCompileClasspath()) {
            astTransformClassLoader.addClasspath(file.getPath());
        }
        JavaAwareCompilationUnit unit = new JavaAwareCompilationUnit(configuration, compileClasspathClassLoader){

            public GroovyClassLoader getTransformLoader() {
                return astTransformClassLoader;
            }
        };
        final boolean shouldProcessAnnotations = this.shouldProcessAnnotations(spec);
        if (shouldProcessAnnotations) {
            unit.addSources(new File[]{new File("ForceStubGeneration.java")});
        }
        Object[] sortedSourceFiles = (File[])Iterables.toArray((Iterable)spec.getSource(), File.class);
        Arrays.sort(sortedSourceFiles);
        unit.addSources((File[])sortedSourceFiles);
        unit.setCompilerFactory(new JavaCompilerFactory(){

            public JavaCompiler createCompiler(CompilerConfiguration config) {
                return new JavaCompiler(){

                    public void compile(List<String> files, CompilationUnit cu) {
                        if (shouldProcessAnnotations) {
                            spec.setSource(spec.getSource().plus((FileCollection)new SimpleFileCollection(new File[]{stubDir}).getAsFileTree()));
                        } else {
                            SimpleFileCollection sourcepath = new SimpleFileCollection(new File[]{stubDir});
                            if (spec.getCompileOptions().getSourcepath() != null) {
                                sourcepath = spec.getCompileOptions().getSourcepath().plus((FileCollection)sourcepath);
                            }
                            spec.getCompileOptions().setSourcepath((FileCollection)sourcepath);
                        }
                        spec.setSource(spec.getSource().filter((Spec)new Spec<File>(){

                            public boolean isSatisfiedBy(File file) {
                                return FileUtils.hasExtension((File)file, (String)".java");
                            }
                        }));
                        try {
                            ApiGroovyCompiler.this.javaCompiler.execute((CompileSpec)spec);
                        }
                        catch (CompilationFailedException e) {
                            cu.getErrorCollector().addFatalError((Message)new SimpleMessage(e.getMessage(), (ProcessingUnit)cu));
                        }
                    }
                };
            }
        });
        try {
            unit.compile();
        }
        catch (org.codehaus.groovy.control.CompilationFailedException e) {
            System.err.println(e.getMessage());
            System.err.flush();
            throw new CompilationFailedException();
        }
        finally {
            compilerGroovyLoader.discardTypesFrom(classPathLoader);
            compilerGroovyLoader.discardTypesFrom((ClassLoader)astTransformClassLoader);
            compileClasspathLoader.shutdown();
        }
        return new SimpleWorkResult(true);
    }

    private boolean shouldProcessAnnotations(GroovyJavaJointCompileSpec spec) {
        return spec.getGroovyCompileOptions().isJavaAnnotationProcessing() && !spec.getAnnotationProcessorPath().isEmpty();
    }

    private void applyConfigurationScript(File configScript, CompilerConfiguration configuration) {
        VersionNumber version = this.parseGroovyVersion();
        if (version.compareTo(VersionNumber.parse((String)"2.1")) < 0) {
            throw new GradleException("Using a Groovy compiler configuration script requires Groovy 2.1+ but found Groovy " + version + "");
        }
        Binding binding = new Binding();
        binding.setVariable("configuration", (Object)configuration);
        CompilerConfiguration configuratorConfig = new CompilerConfiguration();
        ImportCustomizer customizer = new ImportCustomizer();
        customizer.addStaticStars(new String[]{"org.codehaus.groovy.control.customizers.builder.CompilerCustomizationBuilder"});
        configuratorConfig.addCompilationCustomizers(new CompilationCustomizer[]{customizer});
        GroovyShell shell = new GroovyShell(binding, configuratorConfig);
        try {
            shell.evaluate(configScript);
        }
        catch (Exception e) {
            throw new GradleException("Could not execute Groovy compiler configuration script: " + configScript.getAbsolutePath(), (Throwable)e);
        }
    }

    private VersionNumber parseGroovyVersion() {
        String version;
        try {
            version = GroovySystem.getVersion();
        }
        catch (NoSuchMethodError e) {
            try {
                Class<?> ih = Class.forName("org.codehaus.groovy.runtime.InvokerHelper");
                Method getVersion = ih.getDeclaredMethod("getVersion", new Class[0]);
                version = (String)getVersion.invoke(ih, new Object[0]);
            }
            catch (Exception e1) {
                throw new GradleException("Unable to determine Groovy version.", (Throwable)e1);
            }
        }
        return VersionNumber.parse((String)version);
    }

    private void canonicalizeValues(Map<String, Boolean> options) {
        for (String key : options.keySet()) {
            boolean value = options.get(key);
            options.put(key, value);
        }
    }

    private ClassLoader getExtClassLoader() {
        return ClassLoaderUtils.getPlatformClassLoader();
    }
}

