/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsObjectScope;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsScopesKt;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.TypeCheck;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public final class Namer {
    public static final String KOTLIN_NAME = "Kotlin";
    public static final String KOTLIN_LOWER_NAME = "Kotlin".toLowerCase();
    public static final String EQUALS_METHOD_NAME = Namer.getStableMangledNameForDescriptor(JsPlatform.INSTANCE.getBuiltIns().getAny(), "equals");
    public static final String COMPARE_TO_METHOD_NAME = Namer.getStableMangledNameForDescriptor(JsPlatform.INSTANCE.getBuiltIns().getComparable(), "compareTo");
    public static final String NUMBER_RANGE = "NumberRange";
    public static final String CHAR_RANGE = "CharRange";
    public static final String LONG_FROM_NUMBER = "fromNumber";
    public static final String LONG_TO_NUMBER = "toNumber";
    public static final String LONG_FROM_INT = "fromInt";
    public static final String LONG_ZERO = "ZERO";
    public static final String LONG_ONE = "ONE";
    public static final String LONG_NEG_ONE = "NEG_ONE";
    public static final String PRIMITIVE_COMPARE_TO = "primitiveCompareTo";
    public static final String IS_CHAR = "isChar";
    public static final String IS_NUMBER = "isNumber";
    public static final String GET_KCLASS = "getKClass";
    public static final String GET_KCLASS_FROM_EXPRESSION = "getKClassFromExpression";
    public static final String CALLEE_NAME = "$fun";
    public static final String CALL_FUNCTION = "call";
    public static final String OUTER_FIELD_NAME = "$outer";
    public static final String ANOTHER_THIS_PARAMETER_NAME = "$this";
    public static final JsNameRef IS_ARRAY_FUN_REF = new JsNameRef("isArray", "Array");
    public static final String DEFINE_INLINE_FUNCTION = "defineInlineFunction";
    private static final JsNameRef JS_OBJECT = new JsNameRef("Object");
    private static final JsNameRef JS_OBJECT_CREATE_FUNCTION = new JsNameRef("create", (JsExpression)JS_OBJECT);
    public static final String LOCAL_MODULE_PREFIX = "$module$";
    @NotNull
    private final JsObjectScope kotlinScope;
    @NotNull
    private final JsName classCreationMethodReference;
    @NotNull
    private final JsName enumClassCreationMethodName;
    @NotNull
    private final JsName interfaceCreationMethodName;
    @NotNull
    private final JsExpression definePackage;
    @NotNull
    private final JsExpression defineRootPackage;
    @NotNull
    private final JsName objectCreationMethodName;
    @NotNull
    private final JsName callableRefForMemberFunctionName;
    @NotNull
    private final JsName callableRefForExtensionFunctionName;
    @NotNull
    private final JsName callableRefForLocalExtensionFunctionName;
    @NotNull
    private final JsName callableRefForConstructorName;
    @NotNull
    private final JsName callableRefForTopLevelProperty;
    @NotNull
    private final JsName callableRefForMemberProperty;
    @NotNull
    private final JsName callableRefForExtensionProperty;
    @NotNull
    private final JsExpression callGetProperty;
    @NotNull
    private final JsExpression callSetProperty;
    @NotNull
    private final JsName isTypeName;

    public static boolean isUndefined(@NotNull JsExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/kotlin/js/translate/context/Namer", "isUndefined"));
        }
        if (expr instanceof JsPrefixOperation) {
            JsUnaryOperator op = ((JsPrefixOperation)expr).getOperator();
            return op == JsUnaryOperator.VOID;
        }
        return false;
    }

    @NotNull
    public static String getFunctionTag(@NotNull CallableDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/js/translate/context/Namer", "getFunctionTag"));
        }
        String moduleName = JsDescriptorUtils.getModuleName(functionDescriptor);
        FqNameUnsafe fqNameParent = DescriptorUtils.getFqName(functionDescriptor).parent();
        String qualifier = null;
        if (!fqNameParent.isRoot()) {
            qualifier = fqNameParent.asString();
        }
        String mangledName = new NameSuggestion().suggest(functionDescriptor).getNames().get(0);
        String string = StringUtil.join(Arrays.asList(moduleName, qualifier, mangledName), ".");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getFunctionTag"));
        }
        return string;
    }

    @NotNull
    public static String getReceiverParameterName() {
        if ("$receiver" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getReceiverParameterName"));
        }
        return "$receiver";
    }

    @NotNull
    public static String getRootPackageName() {
        if ("_" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getRootPackageName"));
        }
        return "_";
    }

    @NotNull
    public static JsNameRef superMethodNameRef(@NotNull JsName superClassJsName) {
        if (superClassJsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassJsName", "org/jetbrains/kotlin/js/translate/context/Namer", "superMethodNameRef"));
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn("baseInitializer", (JsExpression)superClassJsName.makeRef());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "superMethodNameRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public static String getNameForAccessor(@NotNull String propertyName, boolean isGetter, boolean useNativeAccessor) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForAccessor"));
        }
        if (useNativeAccessor) {
            String string = propertyName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForAccessor"));
            }
            return string;
        }
        if (isGetter) {
            String string = Namer.getNameForGetter(propertyName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForAccessor"));
            }
            return string;
        }
        String string = Namer.getNameForSetter(propertyName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForAccessor"));
        }
        return string;
    }

    @NotNull
    public static String getKotlinBackingFieldName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/js/translate/context/Namer", "getKotlinBackingFieldName"));
        }
        String string = Namer.getNameWithPrefix(propertyName, "$");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getKotlinBackingFieldName"));
        }
        return string;
    }

    @NotNull
    private static String getNameForGetter(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForGetter"));
        }
        String string = Namer.getNameWithPrefix(propertyName, "get_");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForGetter"));
        }
        return string;
    }

    @NotNull
    private static String getNameForSetter(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForSetter"));
        }
        String string = Namer.getNameWithPrefix(propertyName, "set_");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForSetter"));
        }
        return string;
    }

    @NotNull
    public static String getPrototypeName() {
        if ("prototype" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getPrototypeName"));
        }
        return "prototype";
    }

    @NotNull
    private static JsNameRef getRefToPrototype(@NotNull JsExpression classOrTraitExpression) {
        if (classOrTraitExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrTraitExpression", "org/jetbrains/kotlin/js/translate/context/Namer", "getRefToPrototype"));
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn(Namer.getPrototypeName(), classOrTraitExpression);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getRefToPrototype"));
        }
        return jsNameRef;
    }

    @NotNull
    public static String getDelegatePrefix() {
        if ("$delegate" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getDelegatePrefix"));
        }
        return "$delegate";
    }

    @NotNull
    public static String getDelegateName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/js/translate/context/Namer", "getDelegateName"));
        }
        String string = propertyName + "$delegate";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getDelegateName"));
        }
        return string;
    }

    @NotNull
    public static JsNameRef getDelegateNameRef(String propertyName) {
        JsNameRef jsNameRef = new JsNameRef(Namer.getDelegateName(propertyName), (JsExpression)JsLiteral.THIS);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getDelegateNameRef"));
        }
        return jsNameRef;
    }

    @NotNull
    private static String getNameWithPrefix(@NotNull String name2, @NotNull String prefix) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameWithPrefix"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameWithPrefix"));
        }
        String string = prefix + name2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameWithPrefix"));
        }
        return string;
    }

    @NotNull
    public static JsNameRef getFunctionCallRef(@NotNull JsExpression functionExpression) {
        if (functionExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionExpression", "org/jetbrains/kotlin/js/translate/context/Namer", "getFunctionCallRef"));
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn(CALL_FUNCTION, functionExpression);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getFunctionCallRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsNameRef getFunctionApplyRef(@NotNull JsExpression functionExpression) {
        if (functionExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionExpression", "org/jetbrains/kotlin/js/translate/context/Namer", "getFunctionApplyRef"));
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn("apply", functionExpression);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getFunctionApplyRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsInvocation createObjectWithPrototypeFrom(JsNameRef referenceToClass) {
        JsInvocation jsInvocation = new JsInvocation((JsExpression)JS_OBJECT_CREATE_FUNCTION, Namer.getRefToPrototype(referenceToClass));
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "createObjectWithPrototypeFrom"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsNameRef getCapturedVarAccessor(@NotNull JsExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/js/translate/context/Namer", "getCapturedVarAccessor"));
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn("v", ref);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getCapturedVarAccessor"));
        }
        return jsNameRef;
    }

    @NotNull
    public static String isInstanceSuggestedName(@NotNull TypeParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceSuggestedName"));
        }
        String string = "is" + descriptor2.getName().getIdentifier();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceSuggestedName"));
        }
        return string;
    }

    @NotNull
    public static Namer newInstance(@NotNull JsScope rootScope2) {
        if (rootScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/kotlin/js/translate/context/Namer", "newInstance"));
        }
        Namer namer = new Namer(rootScope2);
        if (namer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "newInstance"));
        }
        return namer;
    }

    private Namer(@NotNull JsScope rootScope2) {
        if (rootScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/kotlin/js/translate/context/Namer", "<init>"));
        }
        this.kotlinScope = JsScopesKt.JsObjectScope(rootScope2, "Kotlin standard object");
        this.interfaceCreationMethodName = this.kotlinScope.declareName("createTrait");
        this.definePackage = this.kotlin("definePackage");
        this.defineRootPackage = this.kotlin("defineRootPackage");
        this.callGetProperty = this.kotlin("callGetter");
        this.callSetProperty = this.kotlin("callSetter");
        this.classCreationMethodReference = this.kotlinScope.declareName("createClass");
        this.enumClassCreationMethodName = this.kotlinScope.declareName("createEnumClass");
        this.objectCreationMethodName = this.kotlinScope.declareName("createObject");
        this.callableRefForMemberFunctionName = this.kotlinScope.declareName("getCallableRefForMemberFunction");
        this.callableRefForExtensionFunctionName = this.kotlinScope.declareName("getCallableRefForExtensionFunction");
        this.callableRefForLocalExtensionFunctionName = this.kotlinScope.declareName("getCallableRefForLocalExtensionFunction");
        this.callableRefForConstructorName = this.kotlinScope.declareName("getCallableRefForConstructor");
        this.callableRefForTopLevelProperty = this.kotlinScope.declareName("getCallableRefForTopLevelProperty");
        this.callableRefForMemberProperty = this.kotlinScope.declareName("getCallableRefForMemberProperty");
        this.callableRefForExtensionProperty = this.kotlinScope.declareName("getCallableRefForExtensionProperty");
        this.isTypeName = this.kotlinScope.declareName("isType");
    }

    @NotNull
    public static String getStableMangledNameForDescriptor(@NotNull ClassDescriptor descriptor2, @NotNull String functionName) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/Namer", "getStableMangledNameForDescriptor"));
        }
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/kotlin/js/translate/context/Namer", "getStableMangledNameForDescriptor"));
        }
        Collection<SimpleFunctionDescriptor> functions2 = descriptor2.getDefaultType().getMemberScope().getContributedFunctions(Name.identifier(functionName), NoLookupLocation.FROM_BACKEND);
        assert (functions2.size() == 1) : "Can't select a single function: " + functionName + " in " + descriptor2;
        SuggestedName suggested = new NameSuggestion().suggest(functions2.iterator().next());
        assert (suggested != null) : "Suggested name for class members is always non-null: " + functions2.iterator().next();
        String string = suggested.getNames().get(0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getStableMangledNameForDescriptor"));
        }
        return string;
    }

    @NotNull
    public JsExpression packageDefinitionMethodReference() {
        JsExpression jsExpression = this.definePackage;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "packageDefinitionMethodReference"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression rootPackageDefinitionMethodReference() {
        JsExpression jsExpression = this.defineRootPackage;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "rootPackageDefinitionMethodReference"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression callableRefForMemberFunctionReference() {
        JsNameRef jsNameRef = Namer.kotlin(this.callableRefForMemberFunctionName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForMemberFunctionReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression callableRefForExtensionFunctionReference() {
        JsNameRef jsNameRef = Namer.kotlin(this.callableRefForExtensionFunctionName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForExtensionFunctionReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression callableRefForLocalExtensionFunctionReference() {
        JsNameRef jsNameRef = Namer.kotlin(this.callableRefForLocalExtensionFunctionName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForLocalExtensionFunctionReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression callableRefForConstructorReference() {
        JsNameRef jsNameRef = Namer.kotlin(this.callableRefForConstructorName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForConstructorReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression callableRefForTopLevelPropertyReference() {
        JsNameRef jsNameRef = Namer.kotlin(this.callableRefForTopLevelProperty);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForTopLevelPropertyReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression callableRefForMemberPropertyReference() {
        JsNameRef jsNameRef = Namer.kotlin(this.callableRefForMemberProperty);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForMemberPropertyReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression callableRefForExtensionPropertyReference() {
        JsNameRef jsNameRef = Namer.kotlin(this.callableRefForExtensionProperty);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForExtensionPropertyReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsExpression throwNPEFunctionRef() {
        JsNameRef jsNameRef = new JsNameRef("throwNPE", (JsExpression)Namer.kotlinObject());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "throwNPEFunctionRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsExpression throwClassCastExceptionFunRef() {
        JsNameRef jsNameRef = new JsNameRef("throwCCE", (JsExpression)Namer.kotlinObject());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "throwClassCastExceptionFunRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsNameRef kotlin(@NotNull JsName name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/context/Namer", "kotlin"));
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn(name2, (JsExpression)Namer.kotlinObject());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "kotlin"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsNameRef kotlin(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/context/Namer", "kotlin"));
        }
        JsNameRef jsNameRef = Namer.kotlin(this.kotlinScope.declareName(name2));
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "kotlin"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsNameRef kotlinObject() {
        JsNameRef jsNameRef = JsAstUtils.pureFqn(KOTLIN_NAME, null);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "kotlinObject"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression isTypeOf(@NotNull JsExpression type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/context/Namer", "isTypeOf"));
        }
        JsExpression jsExpression = this.invokeFunctionAndSetTypeCheckMetadata("isTypeOf", type2, TypeCheck.TYPEOF);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "isTypeOf"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression isInstanceOf(@NotNull JsExpression type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceOf"));
        }
        JsExpression jsExpression = this.invokeFunctionAndSetTypeCheckMetadata("isInstanceOf", type2, TypeCheck.INSTANCEOF);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceOf"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression isInstanceOfObject(@NotNull JsExpression type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceOfObject"));
        }
        JsExpression jsExpression = this.invokeFunctionAndSetTypeCheckMetadata("isInstanceOf", type2, TypeCheck.SAME_AS);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceOfObject"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression orNull(@NotNull JsExpression callable) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/js/translate/context/Namer", "orNull"));
        }
        JsExpression jsExpression = this.invokeFunctionAndSetTypeCheckMetadata("orNull", callable, TypeCheck.OR_NULL);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "orNull"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression andPredicate(@NotNull JsExpression a, @NotNull JsExpression b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/js/translate/context/Namer", "andPredicate"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/js/translate/context/Namer", "andPredicate"));
        }
        JsExpression jsExpression = this.invokeFunctionAndSetTypeCheckMetadata("andPredicate", Arrays.asList(a, b), TypeCheck.AND_PREDICATE);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "andPredicate"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression isAny() {
        JsExpression jsExpression = this.invokeFunctionAndSetTypeCheckMetadata("isAny", Collections.<JsExpression>emptyList(), TypeCheck.IS_ANY);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "isAny"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression isComparable() {
        JsNameRef jsNameRef = this.kotlin("isComparable");
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "isComparable"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression isCharSequence() {
        JsNameRef jsNameRef = this.kotlin("isCharSequence");
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "isCharSequence"));
        }
        return jsNameRef;
    }

    @NotNull
    private JsExpression invokeFunctionAndSetTypeCheckMetadata(@NotNull String functionName, @Nullable JsExpression argument, @NotNull TypeCheck metadata) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/kotlin/js/translate/context/Namer", "invokeFunctionAndSetTypeCheckMetadata"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "org/jetbrains/kotlin/js/translate/context/Namer", "invokeFunctionAndSetTypeCheckMetadata"));
        }
        List<JsExpression> arguments2 = argument != null ? Collections.singletonList(argument) : Collections.emptyList();
        JsExpression jsExpression = this.invokeFunctionAndSetTypeCheckMetadata(functionName, arguments2, metadata);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "invokeFunctionAndSetTypeCheckMetadata"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression invokeFunctionAndSetTypeCheckMetadata(@NotNull String functionName, @NotNull List<JsExpression> arguments2, @NotNull TypeCheck metadata) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/kotlin/js/translate/context/Namer", "invokeFunctionAndSetTypeCheckMetadata"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/context/Namer", "invokeFunctionAndSetTypeCheckMetadata"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "org/jetbrains/kotlin/js/translate/context/Namer", "invokeFunctionAndSetTypeCheckMetadata"));
        }
        JsInvocation invocation = new JsInvocation((JsExpression)this.kotlin(functionName), new JsExpression[0]);
        invocation.getArguments().addAll(arguments2);
        MetadataProperties.setTypeCheck(invocation, metadata);
        MetadataProperties.setSideEffects(invocation, SideEffectKind.PURE);
        JsInvocation jsInvocation = invocation;
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "invokeFunctionAndSetTypeCheckMetadata"));
        }
        return jsInvocation;
    }

    @NotNull
    public JsExpression isInstanceOf(@NotNull JsExpression instance, @NotNull JsExpression type2) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceOf"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceOf"));
        }
        JsInvocation result2 = new JsInvocation((JsExpression)Namer.kotlin(this.isTypeName), instance, type2);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        JsInvocation jsInvocation = result2;
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceOf"));
        }
        return jsInvocation;
    }

    @NotNull
    JsObjectScope getKotlinScope() {
        JsObjectScope jsObjectScope = this.kotlinScope;
        if (jsObjectScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getKotlinScope"));
        }
        return jsObjectScope;
    }

    @NotNull
    static String generatePackageName(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/js/translate/context/Namer", "generatePackageName"));
        }
        String string = packageFqName.isRoot() ? Namer.getRootPackageName() : packageFqName.shortName().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "generatePackageName"));
        }
        return string;
    }

    @NotNull
    public JsExpression classCreateInvocation(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/Namer", "classCreateInvocation"));
        }
        switch (descriptor2.getKind()) {
            case INTERFACE: {
                JsNameRef jsNameRef = Namer.kotlin(this.interfaceCreationMethodName);
                if (jsNameRef == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "classCreateInvocation"));
                }
                return jsNameRef;
            }
            case ENUM_CLASS: {
                JsNameRef jsNameRef = Namer.kotlin(this.enumClassCreationMethodName);
                if (jsNameRef == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "classCreateInvocation"));
                }
                return jsNameRef;
            }
            case ENUM_ENTRY: 
            case OBJECT: {
                JsNameRef jsNameRef = Namer.kotlin(this.objectCreationMethodName);
                if (jsNameRef == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "classCreateInvocation"));
                }
                return jsNameRef;
            }
            case ANNOTATION_CLASS: 
            case CLASS: {
                JsNameRef jsNameRef = Namer.kotlin(this.classCreationMethodReference);
                if (jsNameRef == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "classCreateInvocation"));
                }
                return jsNameRef;
            }
        }
        throw new UnsupportedOperationException("Unsupported class kind: " + descriptor2);
    }

    @NotNull
    public static JsExpression getUndefinedExpression() {
        JsPrefixOperation jsPrefixOperation = new JsPrefixOperation(JsUnaryOperator.VOID, JsNumberLiteral.ZERO);
        if (jsPrefixOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getUndefinedExpression"));
        }
        return jsPrefixOperation;
    }

    @NotNull
    public JsExpression getCallGetProperty() {
        JsExpression jsExpression = this.callGetProperty;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getCallGetProperty"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression getCallSetProperty() {
        JsExpression jsExpression = this.callSetProperty;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getCallSetProperty"));
        }
        return jsExpression;
    }

    public static JsNameRef kotlinLong() {
        return JsAstUtils.pureFqn("Long", (JsExpression)Namer.kotlinObject());
    }

    @NotNull
    public static JsNameRef createInlineFunction() {
        JsNameRef jsNameRef = JsAstUtils.pureFqn(DEFINE_INLINE_FUNCTION, (JsExpression)Namer.kotlinObject());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "createInlineFunction"));
        }
        return jsNameRef;
    }

    @NotNull
    public static String suggestedModuleName(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/kotlin/js/translate/context/Namer", "suggestedModuleName"));
        }
        if (id.isEmpty()) {
            if ("_" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "suggestedModuleName"));
            }
            return "_";
        }
        StringBuilder sb = new StringBuilder(id.length());
        char c = id.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            sb.append(c);
        } else {
            sb.append('_');
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
            }
        }
        for (int i = 1; i < id.length(); ++i) {
            c = id.charAt(i);
            sb.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "suggestedModuleName"));
        }
        return string;
    }

    public static boolean requiresEscaping(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/context/Namer", "requiresEscaping"));
        }
        if (name2.isEmpty() || !Character.isJavaIdentifierStart(name2.charAt(0))) {
            return true;
        }
        for (int i = 1; i < name2.length(); ++i) {
            if (Character.isJavaIdentifierPart(name2.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

