/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.script.KotlinScriptExternalDependencies;
import org.jetbrains.kotlin.script.ScriptFileUtilKt;
import org.jetbrains.kotlin.script.ScriptNameUtil;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J/\u0010\u000f\u001a\u0004\u0018\u00010\u0010\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u0002H\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001b\u0010\u001b\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u0002H\u0011H\u0016\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "", "template", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "fileType", "Lorg/jetbrains/kotlin/com/intellij/openapi/fileTypes/LanguageFileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/LanguageFileType;", "name", "", "getName", "()Ljava/lang/String;", "getTemplate", "()Lkotlin/reflect/KClass;", "getDependenciesFor", "Lorg/jetbrains/kotlin/script/KotlinScriptExternalDependencies;", "TF", "file", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "previousDependencies", "(Ljava/lang/Object;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/script/KotlinScriptExternalDependencies;)Lorg/jetbrains/kotlin/script/KotlinScriptExternalDependencies;", "getScriptName", "Lorg/jetbrains/kotlin/name/Name;", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "isScript", "", "(Ljava/lang/Object;)Z", "kotlin-compiler"})
public class KotlinScriptDefinition {
    @NotNull
    private final String name = "Kotlin Script";
    @NotNull
    private final LanguageFileType fileType;
    @NotNull
    private final KClass<? extends Object> template;

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public LanguageFileType getFileType() {
        return this.fileType;
    }

    public <TF> boolean isScript(TF file2) {
        return StringsKt.endsWith$default(ScriptFileUtilKt.getFileName(file2), KotlinParserDefinition.STD_SCRIPT_EXT, false, 2, null);
    }

    @NotNull
    public Name getScriptName(@NotNull KtScript script2) {
        Intrinsics.checkParameterIsNotNull(script2, "script");
        return ScriptNameUtil.INSTANCE.fileNameWithExtensionStripped(script2, KotlinParserDefinition.STD_SCRIPT_EXT);
    }

    @Nullable
    public <TF> KotlinScriptExternalDependencies getDependenciesFor(TF file2, @NotNull Project project, @Nullable KotlinScriptExternalDependencies previousDependencies) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        return null;
    }

    @NotNull
    public final KClass<? extends Object> getTemplate() {
        return this.template;
    }

    public KotlinScriptDefinition(@NotNull KClass<? extends Object> template) {
        Intrinsics.checkParameterIsNotNull(template, "template");
        this.template = template;
        this.name = "Kotlin Script";
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull(kotlinFileType, "KotlinFileType.INSTANCE");
        this.fileType = kotlinFileType;
    }
}

