/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http.internal;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.commons.lang.IncompleteArgumentException;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.gradle.api.UncheckedIOException;
import org.gradle.caching.BuildCache;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.internal.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBuildCache
implements BuildCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpBuildCache.class);
    private static final Set<Integer> FATAL_HTTP_ERROR_CODES = ImmutableSet.of((Object)305, (Object)400, (Object)401, (Object)403, (Object)407, (Object)405, (Object[])new Integer[]{406, 411, 415, 417, 426, 505, 511});
    private final URI root;
    private final URI safeUri;
    private final CloseableHttpClient httpClient;

    public HttpBuildCache(URI root) {
        if (!root.getPath().endsWith("/")) {
            throw new IncompleteArgumentException("HTTP cache root URI must end with '/'");
        }
        this.root = root;
        this.safeUri = HttpBuildCache.safeUri(root);
        this.httpClient = HttpClients.createDefault();
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        boolean bl;
        int statusCode;
        StatusLine statusLine;
        CloseableHttpResponse response;
        block8: {
            block7: {
                URI uri = this.root.resolve("./" + key.getHashCode());
                HttpGet httpGet = new HttpGet(uri);
                response = null;
                response = this.httpClient.execute((HttpUriRequest)httpGet);
                statusLine = response.getStatusLine();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Response for GET {}: {}", (Object)HttpBuildCache.safeUri(uri), (Object)statusLine);
                }
                if (!this.isHttpSuccess(statusCode = statusLine.getStatusCode())) break block7;
                reader.readFrom(response.getEntity().getContent());
                boolean bl2 = true;
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                return bl2;
            }
            if (statusCode != 404) break block8;
            boolean bl3 = false;
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            return bl3;
        }
        try {
            bl = this.throwHttpStatusCodeException(statusCode, String.format("Loading key '%s' from %s response status %d: %s", key, this.getDescription(), statusCode, statusLine.getReasonPhrase()));
        }
        catch (IOException e) {
            try {
                throw new BuildCacheException(String.format("Loading key '%s' from %s", key, this.getDescription()), (Throwable)e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        return bl;
    }

    public void store(BuildCacheKey key, final BuildCacheEntryWriter output) throws BuildCacheException {
        URI uri = this.root.resolve(key.getHashCode());
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setEntity((HttpEntity)new AbstractHttpEntity(){

            public boolean isRepeatable() {
                return true;
            }

            public long getContentLength() {
                return -1L;
            }

            public InputStream getContent() throws IOException, UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            public void writeTo(OutputStream outstream) throws IOException {
                output.writeTo(outstream);
            }

            public boolean isStreaming() {
                return false;
            }
        });
        CloseableHttpResponse response = null;
        try {
            int statusCode;
            response = this.httpClient.execute((HttpUriRequest)httpPut);
            StatusLine statusLine = response.getStatusLine();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response for PUT {}: {}", (Object)HttpBuildCache.safeUri(uri), (Object)statusLine);
            }
            if (!this.isHttpSuccess(statusCode = statusLine.getStatusCode())) {
                this.throwHttpStatusCodeException(statusCode, String.format("Storing key '%s' in %s response status %d: %s", key, this.getDescription(), statusCode, statusLine.getReasonPhrase()));
            }
        }
        catch (IOException e) {
            try {
                throw new BuildCacheException(String.format("Storing key '%s' in %s", key, this.getDescription()), (Throwable)e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
    }

    private boolean isHttpSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private boolean throwHttpStatusCodeException(int statusCode, String message) {
        if (FATAL_HTTP_ERROR_CODES.contains(statusCode)) {
            throw new UncheckedIOException(message);
        }
        throw new BuildCacheException(message);
    }

    public String getDescription() {
        return "an HTTP build cache (" + this.safeUri + ")";
    }

    public void close() throws IOException {
        this.httpClient.close();
    }

    private static URI safeUri(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

