/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.PomReader;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.UnresolvedDependencyVersionException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.PomDependencyMgt;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.DefaultExclude;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.external.descriptor.MutableModuleDescriptorState;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.IvyDependencyMetadata;
import org.gradle.internal.component.external.model.MavenDependencyMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetadata;

public class GradlePomModuleDescriptorBuilder {
    public static final Map<String, Configuration> MAVEN2_CONFIGURATIONS = ImmutableMap.builder().put((Object)"default", (Object)new Configuration("default", true, true, (Collection<String>)ImmutableSet.of((Object)"runtime", (Object)"master"))).put((Object)"master", (Object)new Configuration("master", true, true, (Collection<String>)ImmutableSet.of())).put((Object)"compile", (Object)new Configuration("compile", true, true, (Collection<String>)ImmutableSet.of())).put((Object)"provided", (Object)new Configuration("provided", true, true, (Collection<String>)ImmutableSet.of())).put((Object)"runtime", (Object)new Configuration("runtime", true, true, (Collection<String>)ImmutableSet.of((Object)"compile"))).put((Object)"test", (Object)new Configuration("test", true, false, (Collection<String>)ImmutableSet.of((Object)"runtime"))).put((Object)"system", (Object)new Configuration("system", true, true, (Collection<String>)ImmutableSet.of())).put((Object)"sources", (Object)new Configuration("sources", true, true, (Collection<String>)ImmutableSet.of())).put((Object)"javadoc", (Object)new Configuration("javadoc", true, true, (Collection<String>)ImmutableSet.of())).put((Object)"optional", (Object)new Configuration("optional", true, true, (Collection<String>)ImmutableSet.of())).build();
    private static final Map<String, MavenScope> SCOPES = ImmutableMap.builder().put((Object)"compile", (Object)MavenScope.Compile).put((Object)"runtime", (Object)MavenScope.Runtime).put((Object)"provided", (Object)MavenScope.Provided).put((Object)"test", (Object)MavenScope.Test).put((Object)"system", (Object)MavenScope.System).build();
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("(.+)-\\d{8}\\.\\d{6}-\\d+");
    private static final String[] WILDCARD = new String[]{"*"};
    private final VersionSelectorScheme defaultVersionSelectorScheme;
    private final VersionSelectorScheme mavenVersionSelectorScheme;
    private MutableModuleDescriptorState descriptor;
    private List<DependencyMetadata> dependencies = Lists.newArrayList();
    private final PomReader pomReader;

    public GradlePomModuleDescriptorBuilder(PomReader pomReader, VersionSelectorScheme gradleVersionSelectorScheme, VersionSelectorScheme mavenVersionSelectorScheme) {
        this.defaultVersionSelectorScheme = gradleVersionSelectorScheme;
        this.mavenVersionSelectorScheme = mavenVersionSelectorScheme;
        this.pomReader = pomReader;
    }

    public List<DependencyMetadata> getDependencies() {
        return this.dependencies;
    }

    public ModuleDescriptorState getModuleDescriptor() {
        return this.descriptor;
    }

    public void setModuleRevId(String group, String module, String version) {
        Matcher matcher;
        String effectiveVersion = version;
        if (version != null && (matcher = TIMESTAMP_PATTERN.matcher(version)).matches()) {
            effectiveVersion = matcher.group(1) + "-SNAPSHOT";
        }
        String status = effectiveVersion != null && effectiveVersion.endsWith("SNAPSHOT") ? "integration" : "release";
        this.descriptor = new MutableModuleDescriptorState(DefaultModuleComponentIdentifier.newId(group, module, effectiveVersion), status, false);
    }

    public void setDescription(String description) {
        this.descriptor.setDescription(description);
    }

    public void addDependency(PomReader.PomDependencyData dep) {
        boolean hasNonJarType;
        String scopeString = dep.getScope();
        if (scopeString == null || scopeString.length() == 0) {
            scopeString = this.getDefaultScope(dep);
        }
        MavenScope scope = SCOPES.containsKey(scopeString) ? SCOPES.get(scopeString) : MavenScope.Compile;
        String version = this.determineVersion(dep);
        String mappedVersion = this.convertVersionFromMavenSyntax(version);
        ModuleVersionSelector selector = DefaultModuleVersionSelector.newSelector(dep.getGroupId(), dep.getArtifactId(), mappedVersion);
        if (selector.getGroup().equals(this.descriptor.getComponentIdentifier().getGroup()) && selector.getName().equals(this.descriptor.getComponentIdentifier().getModule())) {
            return;
        }
        boolean optional = dep.isOptional();
        ArrayList artifacts = Lists.newArrayList();
        boolean hasClassifier = dep.getClassifier() != null && dep.getClassifier().length() > 0;
        boolean bl = hasNonJarType = dep.getType() != null && !"jar".equals(dep.getType());
        if (hasClassifier || hasNonJarType) {
            String type = "jar";
            if (dep.getType() != null) {
                type = dep.getType();
            }
            String ext = this.determineExtension(type);
            String classifier = hasClassifier ? dep.getClassifier() : this.getClassifierForType(type);
            String optionalizedScope = optional ? "optional" : scope.toString().toLowerCase();
            DefaultIvyArtifactName artifactName = new DefaultIvyArtifactName(selector.getName(), type, ext, classifier);
            artifacts.add(new Artifact(artifactName, Collections.singleton(optionalizedScope)));
        }
        ArrayList excludes = Lists.newArrayList();
        List<ModuleIdentifier> excluded = dep.getExcludedModules();
        if (excluded.isEmpty()) {
            excluded = this.getDependencyMgtExclusions(dep);
        }
        for (ModuleIdentifier excludedModule : excluded) {
            DefaultExclude rule = new DefaultExclude(excludedModule.getGroup(), excludedModule.getName(), WILDCARD, "exact");
            excludes.add(rule);
        }
        this.dependencies.add(new MavenDependencyMetadata(scope, optional, selector, artifacts, excludes));
    }

    private String convertVersionFromMavenSyntax(String version) {
        VersionSelector versionSelector = this.mavenVersionSelectorScheme.parseSelector(version);
        return this.defaultVersionSelectorScheme.renderSelector(versionSelector);
    }

    private String determineExtension(String type) {
        return JarDependencyType.isJarExtension(type) ? "jar" : type;
    }

    private String getClassifierForType(String type) {
        if (JarDependencyType.TEST_JAR.getName().equals(type)) {
            return "tests";
        }
        if (JarDependencyType.EJB_CLIENT.getName().equals(type)) {
            return "client";
        }
        return null;
    }

    private String determineVersion(PomReader.PomDependencyData dependency) {
        String version = dependency.getVersion();
        String string = version = version == null || version.length() == 0 ? this.getDefaultVersion(dependency) : version;
        if (version == null) {
            throw new UnresolvedDependencyVersionException(dependency.getId());
        }
        return version;
    }

    public void addDependencyForRelocation(ModuleVersionSelector selector) {
        if (selector.getGroup().equals(this.descriptor.getComponentIdentifier().getGroup()) && selector.getName().equals(this.descriptor.getComponentIdentifier().getModule())) {
            return;
        }
        ArrayListMultimap confMappings = ArrayListMultimap.create();
        for (Configuration m2Conf : MAVEN2_CONFIGURATIONS.values()) {
            if (!m2Conf.isVisible()) continue;
            confMappings.put((Object)m2Conf.getName(), (Object)m2Conf.getName());
        }
        this.dependencies.add(new IvyDependencyMetadata(selector, (ListMultimap<String, String>)confMappings));
    }

    private String getDefaultVersion(PomReader.PomDependencyData dep) {
        PomDependencyMgt pomDependencyMgt = this.findDependencyDefault(dep);
        if (pomDependencyMgt != null) {
            return pomDependencyMgt.getVersion();
        }
        return null;
    }

    private String getDefaultScope(PomReader.PomDependencyData dep) {
        PomDependencyMgt pomDependencyMgt = this.findDependencyDefault(dep);
        String result = null;
        if (pomDependencyMgt != null) {
            result = pomDependencyMgt.getScope();
        }
        if (result == null || !SCOPES.containsKey(result)) {
            result = "compile";
        }
        return result;
    }

    private List<ModuleIdentifier> getDependencyMgtExclusions(PomReader.PomDependencyData dep) {
        PomDependencyMgt pomDependencyMgt = this.findDependencyDefault(dep);
        if (pomDependencyMgt != null) {
            return pomDependencyMgt.getExcludedModules();
        }
        return Collections.emptyList();
    }

    private PomDependencyMgt findDependencyDefault(PomReader.PomDependencyData dependency) {
        return this.pomReader.findDependencyDefaults(dependency.getId());
    }

    private static enum JarDependencyType {
        TEST_JAR("test-jar"),
        EJB_CLIENT("ejb-client"),
        EJB("ejb"),
        BUNDLE("bundle"),
        MAVEN_PLUGIN("maven-plugin"),
        ECLIPSE_PLUGIN("eclipse-plugin");

        private static final Map<String, JarDependencyType> TYPES;
        private final String name;

        private JarDependencyType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static boolean isJarExtension(String type) {
            return TYPES.containsKey(type);
        }

        static {
            TYPES = new HashMap<String, JarDependencyType>();
            for (JarDependencyType type : JarDependencyType.values()) {
                TYPES.put(type.name, type);
            }
        }
    }
}

