/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import org.gradle.api.Nullable;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.dependencies.SelfResolvingDependencyInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependenciesToModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ExcludeRuleConverter;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;

public class DefaultDependenciesToModuleDescriptorConverter
implements DependenciesToModuleDescriptorConverter {
    private DependencyDescriptorFactory dependencyDescriptorFactory;
    private ExcludeRuleConverter excludeRuleConverter;

    public DefaultDependenciesToModuleDescriptorConverter(DependencyDescriptorFactory dependencyDescriptorFactory, ExcludeRuleConverter excludeRuleConverter) {
        this.dependencyDescriptorFactory = dependencyDescriptorFactory;
        this.excludeRuleConverter = excludeRuleConverter;
    }

    @Override
    public void addDependencyDescriptors(BuildableLocalComponentMetadata metaData, ConfigurationInternal configuration) {
        this.addDependencies(metaData, configuration);
        this.addExcludeRules(metaData, configuration);
    }

    private void addDependencies(BuildableLocalComponentMetadata metaData, ConfigurationInternal configuration) {
        AttributeContainerInternal attributes = configuration.getAttributes();
        for (Dependency dependency : configuration.getDependencies()) {
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                metaData.addDependency(this.dependencyDescriptorFactory.createDependencyDescriptor(configuration.getName(), (AttributeContainer)attributes, moduleDependency));
                continue;
            }
            if (dependency instanceof FileCollectionDependency) {
                FileCollectionDependency fileDependency = (FileCollectionDependency)dependency;
                metaData.addFiles(configuration.getName(), new DefaultLocalFileDependencyMetadata(fileDependency));
                continue;
            }
            throw new IllegalArgumentException("Cannot convert dependency " + dependency + " to local component dependency metadata.");
        }
    }

    private void addExcludeRules(BuildableLocalComponentMetadata metaData, ConfigurationInternal configuration) {
        for (ExcludeRule excludeRule : configuration.getExcludeRules()) {
            metaData.addExclude(this.excludeRuleConverter.convertExcludeRule(configuration.getName(), excludeRule));
        }
    }

    private static class DefaultLocalFileDependencyMetadata
    implements LocalFileDependencyMetadata {
        private final FileCollectionDependency fileDependency;

        DefaultLocalFileDependencyMetadata(FileCollectionDependency fileDependency) {
            this.fileDependency = fileDependency;
        }

        @Override
        public FileCollectionDependency getSource() {
            return this.fileDependency;
        }

        @Override
        @Nullable
        public ComponentIdentifier getComponentId() {
            return ((SelfResolvingDependencyInternal)this.fileDependency).getTargetComponentId();
        }

        @Override
        public FileCollection getFiles() {
            return this.fileDependency.getFiles();
        }
    }
}

