/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.io.File;
import java.util.Collection;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactsResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedFileDependencyResults;
import org.gradle.api.internal.artifacts.transform.ArtifactTransforms;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.specs.Spec;

public class BuildDependenciesOnlyVisitedArtifactSet
implements VisitedArtifactSet {
    private final VisitedArtifactsResults artifactsResults;
    private final VisitedFileDependencyResults fileDependencyResults;
    private final ArtifactTransforms artifactTransforms;

    public BuildDependenciesOnlyVisitedArtifactSet(VisitedArtifactsResults artifactsResults, VisitedFileDependencyResults fileDependencyResults, ArtifactTransforms artifactTransforms) {
        this.artifactsResults = artifactsResults;
        this.fileDependencyResults = fileDependencyResults;
        this.artifactTransforms = artifactTransforms;
    }

    @Override
    public SelectedArtifactSet select(Spec<? super Dependency> dependencySpec, AttributeContainerInternal requestedAttributes, Spec<? super ComponentIdentifier> componentSpec) {
        Transformer variantSelector = this.artifactTransforms.variantSelector(requestedAttributes);
        ResolvedArtifactSet selectedArtifacts = this.artifactsResults.select(componentSpec, variantSelector).getArtifacts();
        ResolvedArtifactSet selectedFiles = this.fileDependencyResults.select(variantSelector).getFiles();
        return new BuildDependenciesOnlySelectedArtifactSet(selectedArtifacts, selectedFiles);
    }

    private static class BuildDependenciesOnlySelectedArtifactSet
    implements SelectedArtifactSet {
        private final ResolvedArtifactSet selectedArtifacts;
        private final ResolvedArtifactSet selectedFiles;

        BuildDependenciesOnlySelectedArtifactSet(ResolvedArtifactSet selectedArtifacts, ResolvedArtifactSet selectedFiles) {
            this.selectedArtifacts = selectedArtifacts;
            this.selectedFiles = selectedFiles;
        }

        @Override
        public <T extends Collection<Object>> T collectBuildDependencies(T dest) {
            this.selectedArtifacts.collectBuildDependencies(dest);
            this.selectedFiles.collectBuildDependencies(dest);
            return dest;
        }

        @Override
        public void visitArtifacts(ArtifactVisitor visitor) {
            throw new UnsupportedOperationException("Artifacts have not been resolved.");
        }

        @Override
        public <T extends Collection<? super ResolvedArtifactResult>> T collectArtifacts(T dest) throws ResolveException {
            throw new UnsupportedOperationException("Artifacts have not been resolved.");
        }

        @Override
        public <T extends Collection<? super File>> T collectFiles(T dest) throws ResolveException {
            throw new UnsupportedOperationException("Artifacts have not been resolved.");
        }
    }
}

