/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.ArtifactTransformTargets;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.dsl.dependencies.DefaultArtifactTransformTargets;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformRegistration;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformRegistrationsInternal;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.DefaultMutableAttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.reflect.DirectInstantiator;

public class DefaultArtifactTransformRegistrations
implements ArtifactTransformRegistrationsInternal {
    private final List<ArtifactTransformRegistration> transforms = Lists.newArrayList();
    private final ImmutableAttributesFactory immutableAttributesFactory;

    public DefaultArtifactTransformRegistrations(ImmutableAttributesFactory immutableAttributesFactory) {
        this.immutableAttributesFactory = immutableAttributesFactory;
    }

    public void registerTransform(Class<? extends ArtifactTransform> type, Action<? super ArtifactTransform> config) {
        for (ArtifactTransformRegistration transformRegistration : this.transforms) {
            if (transformRegistration.getType() != type) continue;
            return;
        }
        ArtifactTransform artifactTransform = (ArtifactTransform)DirectInstantiator.INSTANCE.newInstance(type, new Object[0]);
        DefaultMutableAttributeContainer from = new DefaultMutableAttributeContainer(this.immutableAttributesFactory);
        DefaultArtifactTransformTargets registry = new DefaultArtifactTransformTargets(this.immutableAttributesFactory);
        artifactTransform.configure((AttributeContainer)from, (ArtifactTransformTargets)registry);
        for (AttributeContainerInternal to : registry.getNewTargets()) {
            ArtifactTransformRegistration registration = new ArtifactTransformRegistration((AttributeContainer)from.asImmutable(), (AttributeContainer)to.asImmutable(), type, config);
            this.transforms.add(registration);
        }
    }

    @Override
    public Iterable<ArtifactTransformRegistration> getTransforms() {
        return this.transforms;
    }
}

