/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.HashSet;
import java.util.Set;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.changedetection.state.CachingFileHasher;
import org.gradle.api.internal.changedetection.state.FileTimeStampInspector;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.VersionStrategy;

public class GlobalScopeFileTimeStampInspector
extends FileTimeStampInspector
implements BuildListener {
    private CachingFileHasher fileHasher;
    private final Object lock = new Object();
    private long currentTimestamp;
    private final Set<String> filesWithCurrentTimestamp = new HashSet<String>();

    public GlobalScopeFileTimeStampInspector(CacheScopeMapping cacheScopeMapping) {
        super(cacheScopeMapping.getBaseDirectory(null, "file-changes", VersionStrategy.CachePerVersion));
    }

    public void attach(CachingFileHasher fileHasher) {
        this.fileHasher = fileHasher;
    }

    public void buildStarted(Gradle gradle) {
        this.updateOnStartBuild();
        this.currentTimestamp = this.currentTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean timestampCanBeUsedToDetectFileChange(String file, long timestamp) {
        Object object = this.lock;
        synchronized (object) {
            if (timestamp == this.currentTimestamp) {
                this.filesWithCurrentTimestamp.add(file);
            } else if (timestamp > this.currentTimestamp) {
                this.filesWithCurrentTimestamp.clear();
                this.filesWithCurrentTimestamp.add(file);
                this.currentTimestamp = timestamp;
            }
        }
        return super.timestampCanBeUsedToDetectFileChange(file, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished(BuildResult result) {
        this.updateOnFinishBuild();
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.currentTimestamp == this.getLastBuildTimestamp()) {
                    for (String path : this.filesWithCurrentTimestamp) {
                        this.fileHasher.discard(path);
                    }
                }
            }
            finally {
                this.filesWithCurrentTimestamp.clear();
            }
        }
    }

    public void settingsEvaluated(Settings settings) {
    }

    public void projectsLoaded(Gradle gradle) {
    }

    public void projectsEvaluated(Gradle gradle) {
    }
}

