/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.cache.Cache;
import com.google.common.hash.HashCode;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.MultiProcessSafeAsyncPersistentIndexedCache;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InMemoryDecoratedCache<K, V>
implements MultiProcessSafeAsyncPersistentIndexedCache<K, V> {
    private static final Logger LOG = Logging.getLogger(InMemoryDecoratedCache.class);
    private static final Object NULL = new Object();
    private final MultiProcessSafeAsyncPersistentIndexedCache<K, V> delegate;
    private final Cache<Object, Object> inMemoryCache;
    private final String cacheId;
    private final AtomicReference<FileLock.State> fileLockStateReference;

    public InMemoryDecoratedCache(MultiProcessSafeAsyncPersistentIndexedCache<K, V> delegate, Cache<Object, Object> inMemoryCache, String cacheId, AtomicReference<FileLock.State> fileLockStateReference) {
        this.delegate = delegate;
        this.inMemoryCache = inMemoryCache;
        this.cacheId = cacheId;
        this.fileLockStateReference = fileLockStateReference;
    }

    @Override
    public V get(final K key) {
        Object value;
        assert (key instanceof String || key instanceof Long || key instanceof File || key instanceof HashCode) : "Unsupported key type: " + key;
        try {
            value = this.inMemoryCache.get(key, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Object out = InMemoryDecoratedCache.this.delegate.get(key);
                    return out == null ? NULL : out;
                }
            });
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        if (value == NULL) {
            return null;
        }
        return (V)value;
    }

    @Override
    public void putLater(K key, V value, Runnable completion) {
        this.inMemoryCache.put(key, value);
        this.delegate.putLater(key, value, completion);
    }

    @Override
    public void removeLater(K key, Runnable completion) {
        this.inMemoryCache.put(key, NULL);
        this.delegate.removeLater(key, completion);
    }

    @Override
    public void afterLockAcquire(FileLock.State currentCacheState) {
        boolean outOfDate = false;
        FileLock.State previousState = this.fileLockStateReference.get();
        if (previousState == null) {
            outOfDate = true;
        } else if (currentCacheState.hasBeenUpdatedSince(previousState)) {
            LOG.info("Invalidating in-memory cache of {}", (Object)this.cacheId);
            outOfDate = true;
        }
        if (outOfDate) {
            this.inMemoryCache.invalidateAll();
        }
        this.delegate.afterLockAcquire(currentCacheState);
    }

    @Override
    public void finishWork() {
        this.delegate.finishWork();
    }

    @Override
    public void beforeLockRelease(FileLock.State currentCacheState) {
        this.fileLockStateReference.set(currentCacheState);
        this.delegate.beforeLockRelease(currentCacheState);
    }
}

