/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.repository.internal;

import org.gradle.api.Action;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.plugin.repository.GradlePluginPortal;
import org.gradle.plugin.repository.IvyPluginRepository;
import org.gradle.plugin.repository.MavenPluginRepository;
import org.gradle.plugin.repository.PluginRepositoriesSpec;
import org.gradle.plugin.repository.internal.PluginRepositoryFactory;
import org.gradle.plugin.repository.internal.PluginRepositoryRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginRepositoriesSpec
implements PluginRepositoriesSpec {
    private final PluginRepositoryFactory pluginRepositoryFactory;
    private final PluginRepositoryRegistry pluginRepositoryRegistry;
    private final FileResolver fileResolver;

    public DefaultPluginRepositoriesSpec(PluginRepositoryFactory pluginRepositoryFactory, PluginRepositoryRegistry pluginRepositoryRegistry, FileResolver fileResolver) {
        this.pluginRepositoryFactory = pluginRepositoryFactory;
        this.pluginRepositoryRegistry = pluginRepositoryRegistry;
        this.fileResolver = fileResolver;
    }

    @Override
    public MavenPluginRepository maven(Action<? super MavenPluginRepository> action) {
        MavenPluginRepository repo = this.pluginRepositoryFactory.maven(action, this.fileResolver);
        this.pluginRepositoryRegistry.add(repo);
        return repo;
    }

    @Override
    public IvyPluginRepository ivy(Action<? super IvyPluginRepository> action) {
        IvyPluginRepository repo = this.pluginRepositoryFactory.ivy(action, this.fileResolver);
        this.pluginRepositoryRegistry.add(repo);
        return repo;
    }

    @Override
    public GradlePluginPortal gradlePluginPortal() {
        GradlePluginPortal portal = this.pluginRepositoryFactory.gradlePluginPortal();
        this.pluginRepositoryRegistry.add(portal);
        return portal;
    }
}

