/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.remote.MessagingServer;
import org.gradle.process.internal.JavaExecHandleFactory;
import org.gradle.process.internal.health.memory.MemoryManager;
import org.gradle.process.internal.worker.DefaultMultiRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.DefaultSingleRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.DefaultWorkerProcessBuilder;
import org.gradle.process.internal.worker.MultiRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.SingleRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.process.internal.worker.child.ApplicationClassesInSystemClassLoaderWorkerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerProcessFactory
implements WorkerProcessFactory {
    private final LogLevel workerLogLevel;
    private final MessagingServer server;
    private final IdGenerator<?> idGenerator;
    private final File gradleUserHomeDir;
    private final JavaExecHandleFactory execHandleFactory;
    private final OutputEventListener outputEventListener;
    private final ApplicationClassesInSystemClassLoaderWorkerFactory workerFactory;
    private final MemoryManager memoryManager;
    private int connectTimeoutSeconds = 120;

    public DefaultWorkerProcessFactory(LogLevel workerLogLevel, MessagingServer server, ClassPathRegistry classPathRegistry, IdGenerator<?> idGenerator, File gradleUserHomeDir, TemporaryFileProvider temporaryFileProvider, JavaExecHandleFactory execHandleFactory, JvmVersionDetector jvmVersionDetector, OutputEventListener outputEventListener, MemoryManager memoryManager) {
        this.workerLogLevel = workerLogLevel;
        this.server = server;
        this.idGenerator = idGenerator;
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.execHandleFactory = execHandleFactory;
        this.outputEventListener = outputEventListener;
        this.workerFactory = new ApplicationClassesInSystemClassLoaderWorkerFactory(classPathRegistry, temporaryFileProvider, jvmVersionDetector);
        this.memoryManager = memoryManager;
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    @Override
    public WorkerProcessBuilder create(Action<? super WorkerProcessContext> workerAction) {
        DefaultWorkerProcessBuilder builder = this.newWorker();
        builder.worker(workerAction);
        builder.setImplementationClasspath(ClasspathUtil.getClasspath((ClassLoader)workerAction.getClass().getClassLoader()).getAsURLs());
        return builder;
    }

    private DefaultWorkerProcessBuilder newWorker() {
        DefaultWorkerProcessBuilder workerProcessBuilder = new DefaultWorkerProcessBuilder(this.execHandleFactory, this.server, this.idGenerator, this.workerFactory, this.outputEventListener, this.memoryManager);
        workerProcessBuilder.setLogLevel(this.workerLogLevel);
        workerProcessBuilder.setGradleUserHomeDir(this.gradleUserHomeDir);
        workerProcessBuilder.setConnectTimeoutSeconds(this.connectTimeoutSeconds);
        return workerProcessBuilder;
    }

    @Override
    public <P> SingleRequestWorkerProcessBuilder<P> singleRequestWorker(Class<P> protocolType, Class<? extends P> workerImplementation) {
        return new DefaultSingleRequestWorkerProcessBuilder<P>(protocolType, workerImplementation, this.newWorker());
    }

    @Override
    public <P, W extends P> MultiRequestWorkerProcessBuilder<W> multiRequestWorker(Class<W> workerType, Class<P> protocolType, Class<? extends P> workerImplementation) {
        return new DefaultMultiRequestWorkerProcessBuilder<W>(workerType, workerImplementation, this.newWorker());
    }
}

