/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringClassLoader
extends ClassLoader
implements ClassLoaderHierarchy {
    private static final ClassLoader EXT_CLASS_LOADER;
    private static final Set<String> SYSTEM_PACKAGES;
    public static final String DEFAULT_PACKAGE = "DEFAULT";
    private final Set<String> packageNames = new HashSet<String>();
    private final Set<String> packagePrefixes = new HashSet<String>();
    private final Set<String> resourcePrefixes = new HashSet<String>();
    private final Set<String> resourceNames = new HashSet<String>();
    private final Set<String> classNames = new HashSet<String>();
    private final Set<String> disallowedClassNames = new HashSet<String>();
    private final Set<String> disallowedPackagePrefixes = new HashSet<String>();

    public FilteringClassLoader(ClassLoader parent, Spec spec) {
        super(parent);
        this.packageNames.addAll(spec.packageNames);
        this.packagePrefixes.addAll(spec.packagePrefixes);
        this.resourceNames.addAll(spec.resourceNames);
        this.resourcePrefixes.addAll(spec.resourcePrefixes);
        this.classNames.addAll(spec.classNames);
        this.disallowedClassNames.addAll(spec.disallowedClassNames);
        this.disallowedPackagePrefixes.addAll(spec.disallowedPackagePrefixes);
    }

    @Override
    public void visit(ClassLoaderVisitor visitor) {
        visitor.visitSpec(new Spec(this.classNames, this.packageNames, this.packagePrefixes, this.resourcePrefixes, this.resourceNames, this.disallowedClassNames, this.disallowedPackagePrefixes));
        visitor.visitParent(this.getParent());
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return EXT_CLASS_LOADER.loadClass(name);
        }
        catch (ClassNotFoundException ignore) {
            if (!this.classAllowed(name)) {
                throw new ClassNotFoundException(name + " not found.");
            }
            Class<?> cl = super.loadClass(name, false);
            if (resolve) {
                this.resolveClass(cl);
            }
            return cl;
        }
    }

    @Override
    protected Package getPackage(String name) {
        Package p = super.getPackage(name);
        if (p == null || !this.allowed(p)) {
            return null;
        }
        return p;
    }

    @Override
    protected Package[] getPackages() {
        ArrayList<Package> packages = new ArrayList<Package>();
        for (Package p : super.getPackages()) {
            if (!this.allowed(p)) continue;
            packages.add(p);
        }
        return packages.toArray(new Package[0]);
    }

    @Override
    public URL getResource(String name) {
        if (this.allowed(name)) {
            return super.getResource(name);
        }
        return EXT_CLASS_LOADER.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.allowed(name)) {
            return super.getResources(name);
        }
        return EXT_CLASS_LOADER.getResources(name);
    }

    private boolean allowed(String resourceName) {
        if (this.resourceNames.contains(resourceName)) {
            return true;
        }
        for (String resourcePrefix : this.resourcePrefixes) {
            if (!resourceName.startsWith(resourcePrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean allowed(Package pkg) {
        for (String packagePrefix : this.disallowedPackagePrefixes) {
            if (!pkg.getName().startsWith(packagePrefix)) continue;
            return false;
        }
        if (SYSTEM_PACKAGES.contains(pkg.getName())) {
            return true;
        }
        if (this.packageNames.contains(pkg.getName())) {
            return true;
        }
        for (String packagePrefix : this.packagePrefixes) {
            if (!pkg.getName().startsWith(packagePrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean classAllowed(String className) {
        if (this.disallowedClassNames.contains(className)) {
            return false;
        }
        for (String packagePrefix : this.disallowedPackagePrefixes) {
            if (!className.startsWith(packagePrefix)) continue;
            return false;
        }
        if (this.classNames.contains(className)) {
            return true;
        }
        for (String packagePrefix : this.packagePrefixes) {
            if (className.startsWith(packagePrefix)) {
                return true;
            }
            if (!packagePrefix.startsWith(DEFAULT_PACKAGE) || !this.isInDefaultPackage(className)) continue;
            return true;
        }
        return false;
    }

    private boolean isInDefaultPackage(String className) {
        return !className.contains(".");
    }

    static {
        Package[] systemPackages;
        SYSTEM_PACKAGES = new HashSet<String>();
        EXT_CLASS_LOADER = ClassLoaderUtils.getPlatformClassLoader();
        JavaMethod<Class<ClassLoader>, Package[]> method = JavaReflectionUtil.method(ClassLoader.class, Package[].class, "getPackages", new Class[0]);
        for (Package p : systemPackages = method.invoke((Class<ClassLoader>)((Object)EXT_CLASS_LOADER), new Object[0])) {
            SYSTEM_PACKAGES.add(p.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Spec
    extends ClassLoaderSpec {
        final Set<String> packageNames = new HashSet<String>();
        final Set<String> packagePrefixes = new HashSet<String>();
        final Set<String> resourcePrefixes = new HashSet<String>();
        final Set<String> resourceNames = new HashSet<String>();
        final Set<String> classNames = new HashSet<String>();
        final Set<String> disallowedClassNames = new HashSet<String>();
        final Set<String> disallowedPackagePrefixes = new HashSet<String>();

        public Spec() {
        }

        public Spec(Spec spec) {
            this(spec.classNames, spec.packageNames, spec.packagePrefixes, spec.resourcePrefixes, spec.resourceNames, spec.disallowedClassNames, spec.disallowedPackagePrefixes);
        }

        public Spec(Collection<String> classNames, Collection<String> packageNames, Collection<String> packagePrefixes, Collection<String> resourcePrefixes, Collection<String> resourceNames, Collection<String> disallowedClassNames, Collection<String> disallowedPackagePrefixes) {
            this.classNames.addAll(classNames);
            this.packageNames.addAll(packageNames);
            this.packagePrefixes.addAll(packagePrefixes);
            this.resourcePrefixes.addAll(resourcePrefixes);
            this.resourceNames.addAll(resourceNames);
            this.disallowedClassNames.addAll(disallowedClassNames);
            this.disallowedPackagePrefixes.addAll(disallowedPackagePrefixes);
        }

        public void allowPackage(String packageName) {
            this.packageNames.add(packageName);
            this.packagePrefixes.add(packageName + ".");
            this.resourcePrefixes.add(packageName.replace('.', '/') + '/');
        }

        public void allowClass(Class<?> clazz) {
            this.classNames.add(clazz.getName());
        }

        public void disallowClass(String className) {
            this.disallowedClassNames.add(className);
        }

        public void disallowPackage(String packagePrefix) {
            this.disallowedPackagePrefixes.add(packagePrefix + ".");
        }

        public void allowResources(String resourcePrefix) {
            this.resourcePrefixes.add(resourcePrefix + "/");
        }

        public void allowResource(String resourceName) {
            this.resourceNames.add(resourceName);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Spec other = (Spec)obj;
            return other.packageNames.equals(this.packageNames) && other.packagePrefixes.equals(this.packagePrefixes) && other.resourceNames.equals(this.resourceNames) && other.resourcePrefixes.equals(this.resourcePrefixes) && other.classNames.equals(this.classNames) && other.disallowedClassNames.equals(this.disallowedClassNames) && other.disallowedPackagePrefixes.equals(this.disallowedPackagePrefixes);
        }

        public int hashCode() {
            return this.packageNames.hashCode() ^ this.packagePrefixes.hashCode() ^ this.resourceNames.hashCode() ^ this.resourcePrefixes.hashCode() ^ this.classNames.hashCode() ^ this.disallowedClassNames.hashCode() ^ this.disallowedPackagePrefixes.hashCode();
        }

        Set<String> getPackageNames() {
            return this.packageNames;
        }

        Set<String> getPackagePrefixes() {
            return this.packagePrefixes;
        }

        Set<String> getResourcePrefixes() {
            return this.resourcePrefixes;
        }

        Set<String> getResourceNames() {
            return this.resourceNames;
        }

        Set<String> getClassNames() {
            return this.classNames;
        }

        Set<String> getDisallowedClassNames() {
            return this.disallowedClassNames;
        }

        Set<String> getDisallowedPackagePrefixes() {
            return this.disallowedPackagePrefixes;
        }
    }
}

