/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.foundation.PathParserPortion;
import org.gradle.foundation.TaskView;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectView
implements Comparable<ProjectView>,
Serializable {
    private final String name;
    private final ProjectView parentProject;
    private final List<ProjectView> subProjects = new ArrayList<ProjectView>();
    private final List<TaskView> tasks = new ArrayList<TaskView>();
    private final File buildFile;
    private final String description;

    ProjectView(ProjectView parentProject, String name, File buildFile, String description) {
        this.parentProject = parentProject;
        this.name = name;
        this.buildFile = buildFile;
        this.description = (String)GUtil.elvis((Object)description, (Object)"");
        if (parentProject != null) {
            parentProject.addSubProject(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public File getBuildFile() {
        return this.buildFile;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }

    public ProjectView getParentProject() {
        return this.parentProject;
    }

    @Override
    public int compareTo(ProjectView otherProject) {
        return this.name.compareTo(otherProject.name);
    }

    void createTask(String name, String description, boolean isDefault) {
        TaskView taskView = new TaskView(this, name, description, isDefault);
        this.tasks.add(taskView);
    }

    void addSubProject(ProjectView subProject) {
        this.subProjects.add(subProject);
    }

    public List<TaskView> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    public List<ProjectView> getSubProjects() {
        return Collections.unmodifiableList(this.subProjects);
    }

    public void sortSubProjectsAndTasks() {
        Collections.sort(this.tasks);
        Collections.sort(this.subProjects);
    }

    public ProjectView getSubProject(String name) {
        for (ProjectView subProject : this.subProjects) {
            if (!name.equals(subProject.getName())) continue;
            return subProject;
        }
        return null;
    }

    public TaskView getTask(String name) {
        for (TaskView task : this.tasks) {
            if (!name.equals(task.getName())) continue;
            return task;
        }
        return null;
    }

    public ProjectView getSubProjectFromFullPath(String fullProjectName) {
        if (fullProjectName == null) {
            return null;
        }
        PathParserPortion portion = new PathParserPortion(fullProjectName);
        ProjectView subProject = this.getSubProject(portion.getFirstPart());
        if (!portion.hasRemainder()) {
            return subProject;
        }
        if (subProject == null) {
            return null;
        }
        return subProject.getSubProjectFromFullPath(portion.getRemainder());
    }

    public TaskView getTaskFromFullPath(String fullTaskName) {
        if (fullTaskName == null) {
            return null;
        }
        PathParserPortion portion = new PathParserPortion(fullTaskName);
        if (!portion.hasRemainder()) {
            return this.getTask(portion.getFirstPart());
        }
        ProjectView subProject = this.getSubProject(portion.getFirstPart());
        if (subProject == null) {
            return null;
        }
        return subProject.getTaskFromFullPath(portion.getRemainder());
    }

    public String getFullProjectName() {
        ProjectView ancestorProject = this.getParentProject();
        if (ancestorProject == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(this.name);
        while (ancestorProject != null && ancestorProject.getParentProject() != null) {
            builder.insert(0, ancestorProject.getName() + ':');
            ancestorProject = ancestorProject.getParentProject();
        }
        return builder.toString();
    }

    public List<TaskView> getDefaultTasks() {
        ArrayList<TaskView> defaultTasks = new ArrayList<TaskView>();
        for (TaskView taskView : this.tasks) {
            if (!taskView.isDefault()) continue;
            defaultTasks.add(taskView);
        }
        return defaultTasks;
    }
}

