/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.collections;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WeakValuedMap<Key, Value> {
    private final Map<Key, KeyedReference<Key, Value>> map = new ConcurrentHashMap<Key, KeyedReference<Key, Value>>();
    private final ReferenceQueue<Value> deadRefs = new ReferenceQueue();

    public final void put(Key key, Value value) {
        this.cleanReferences();
        this.map.put(key, new KeyedReference<Key, Value>(value, key, this.deadRefs));
    }

    public final Value get(Key key) {
        this.cleanReferences();
        KeyedReference<Key, Value> reference = this.map.get(key);
        if (reference == null) {
            return null;
        }
        return (Value)reference.get();
    }

    public void clear() {
        this.cleanReferences();
        this.map.clear();
    }

    public int size() {
        this.cleanReferences();
        return this.map.size();
    }

    private void cleanReferences() {
        KeyedReference ref;
        while ((ref = (KeyedReference)this.deadRefs.poll()) != null) {
            this.map.remove(ref.key);
        }
    }

    protected static class KeyedReference<Key, Value>
    extends WeakReference<Value> {
        protected final Key key;

        public KeyedReference(Value object, Key key, ReferenceQueue<? super Value> queue) {
            super(object, queue);
            this.key = key;
        }
    }
}

