/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.CatalogTexture;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexturesCategory
implements Comparable<TexturesCategory> {
    private final String name;
    private List<CatalogTexture> textures;
    private static final Collator COMPARATOR = Collator.getInstance();

    public TexturesCategory(String string) {
        this.name = string;
        this.textures = new ArrayList<CatalogTexture>();
    }

    public String getName() {
        return this.name;
    }

    public List<CatalogTexture> getTextures() {
        return Collections.unmodifiableList(this.textures);
    }

    public int getTexturesCount() {
        return this.textures.size();
    }

    public CatalogTexture getTexture(int n) {
        return this.textures.get(n);
    }

    public int getIndexOfTexture(CatalogTexture catalogTexture) {
        return this.textures.indexOf(catalogTexture);
    }

    void add(CatalogTexture catalogTexture) {
        catalogTexture.setCategory(this);
        int n = Collections.binarySearch(this.textures, catalogTexture);
        if (n < 0) {
            n = -n - 1;
        }
        this.textures.add(n, catalogTexture);
    }

    void delete(CatalogTexture catalogTexture) {
        int n = this.textures.indexOf(catalogTexture);
        if (n == -1) {
            throw new IllegalArgumentException(this.name + " doesn't contain texture " + catalogTexture.getName());
        }
        this.textures = new ArrayList<CatalogTexture>(this.textures);
        this.textures.remove(n);
    }

    public boolean equals(Object object) {
        return object instanceof TexturesCategory && COMPARATOR.equals(this.name, ((TexturesCategory)object).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(TexturesCategory texturesCategory) {
        return COMPARATOR.compare(this.name, texturesCategory.name);
    }
}

