/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.HomePrintableComponent;
import com.eteks.sweethome3d.swing.ProportionalLayout;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.PrintPreviewController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;

public class PrintPreviewPanel
extends JPanel
implements DialogView {
    private final UserPreferences preferences;
    private JToolBar toolBar;
    private HomePrintableComponent printableComponent;
    private JLabel pageLabel;

    public PrintPreviewPanel(Home home, UserPreferences userPreferences, HomeController homeController, PrintPreviewController printPreviewController) {
        super(new ProportionalLayout());
        this.preferences = userPreferences;
        this.createActions(userPreferences);
        this.installKeyboardActions();
        this.createComponents(home, homeController);
        this.layoutComponents();
        this.updateComponents();
    }

    private void createActions(UserPreferences userPreferences) {
        ResourceAction resourceAction = new ResourceAction(userPreferences, PrintPreviewPanel.class, ActionType.SHOW_PREVIOUS_PAGE.name()){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreviewPanel.this.printableComponent.setPage(PrintPreviewPanel.this.printableComponent.getPage() - 1);
                PrintPreviewPanel.this.updateComponents();
            }
        };
        ResourceAction resourceAction2 = new ResourceAction(userPreferences, PrintPreviewPanel.class, ActionType.SHOW_NEXT_PAGE.name()){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreviewPanel.this.printableComponent.setPage(PrintPreviewPanel.this.printableComponent.getPage() + 1);
                PrintPreviewPanel.this.updateComponents();
            }
        };
        ActionMap actionMap = this.getActionMap();
        actionMap.put((Object)ActionType.SHOW_PREVIOUS_PAGE, resourceAction);
        actionMap.put((Object)ActionType.SHOW_NEXT_PAGE, resourceAction2);
    }

    private void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), (Object)ActionType.SHOW_PREVIOUS_PAGE);
        inputMap.put(KeyStroke.getKeyStroke("UP"), (Object)ActionType.SHOW_PREVIOUS_PAGE);
        inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), (Object)ActionType.SHOW_PREVIOUS_PAGE);
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), (Object)ActionType.SHOW_NEXT_PAGE);
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), (Object)ActionType.SHOW_NEXT_PAGE);
        inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), (Object)ActionType.SHOW_NEXT_PAGE);
    }

    private void createComponents(Home home, HomeController homeController) {
        this.printableComponent = new HomePrintableComponent(home, homeController, this.getFont());
        this.printableComponent.setBorder(BorderFactory.createCompoundBorder(new AbstractBorder(){

            public Insets getBorderInsets(Component component) {
                return new Insets(0, 0, 5, 5);
            }

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color = graphics2D.getColor();
                for (int i = 0; i < 5; ++i) {
                    graphics2D.setColor(new Color(128, 128, 128, 200 - i * 45));
                    graphics2D.drawLine(n + n3 - 5 + i, n2 + i, n + n3 - 5 + i, n2 + n4 - 5 + i);
                    graphics2D.drawLine(n + i, n2 + n4 - 5 + i, n + n3 - 5 + i - 1, n2 + n4 - 5 + i);
                }
                graphics2D.setColor(color);
            }
        }, BorderFactory.createLineBorder(Color.BLACK)));
        this.pageLabel = new JLabel();
        this.toolBar = new JToolBar(){

            public void applyComponentOrientation(ComponentOrientation componentOrientation) {
            }
        };
        this.toolBar.setFloatable(false);
        ActionMap actionMap = this.getActionMap();
        if (OperatingSystem.isMacOSXLeopardOrSuperior() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
            class HigherInsetsButton
            extends JButton {
                public HigherInsetsButton(Action action) {
                    super(action);
                }

                public Insets getInsets() {
                    Insets insets = super.getInsets();
                    insets.top += 3;
                    insets.bottom += 3;
                    return insets;
                }
            }
            this.toolBar.add(new HigherInsetsButton(actionMap.get((Object)ActionType.SHOW_PREVIOUS_PAGE)));
            this.toolBar.add(new HigherInsetsButton(actionMap.get((Object)ActionType.SHOW_NEXT_PAGE)));
        } else {
            this.toolBar.add(actionMap.get((Object)ActionType.SHOW_PREVIOUS_PAGE));
            this.toolBar.add(actionMap.get((Object)ActionType.SHOW_NEXT_PAGE));
        }
        this.updateToolBarButtonsStyle(this.toolBar);
        this.toolBar.add(Box.createHorizontalStrut(20));
        this.toolBar.add(this.pageLabel);
        int n = this.toolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.toolBar.getComponentAtIndex(i).setFocusable(false);
        }
    }

    private void updateToolBarButtonsStyle(JToolBar jToolBar) {
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            JComponent jComponent = (JComponent)jToolBar.getComponentAtIndex(0);
            jComponent.putClientProperty("JButton.buttonType", "segmentedTextured");
            jComponent.putClientProperty("JButton.segmentPosition", "first");
            JComponent jComponent2 = (JComponent)jToolBar.getComponentAtIndex(1);
            jComponent2.putClientProperty("JButton.buttonType", "segmentedTextured");
            jComponent2.putClientProperty("JButton.segmentPosition", "last");
        }
    }

    private void layoutComponents() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.toolBar);
        this.add((Component)jPanel, (Object)ProportionalLayout.Constraints.TOP);
        this.add((Component)this.printableComponent, (Object)ProportionalLayout.Constraints.BOTTOM);
    }

    private void updateComponents() {
        ActionMap actionMap = this.getActionMap();
        actionMap.get((Object)ActionType.SHOW_PREVIOUS_PAGE).setEnabled(this.printableComponent.getPage() > 0);
        actionMap.get((Object)ActionType.SHOW_NEXT_PAGE).setEnabled(this.printableComponent.getPage() < this.printableComponent.getPageCount() - 1);
        this.pageLabel.setText(this.preferences.getLocalizedString(PrintPreviewPanel.class, "pageLabel.text", this.printableComponent.getPage() + 1, this.printableComponent.getPageCount()));
    }

    public void displayView(View view) {
        String string = this.preferences.getLocalizedString(PrintPreviewPanel.class, "printPreview.title", new Object[0]);
        JOptionPane jOptionPane = new JOptionPane(this, -1, -1);
        if (view != null) {
            jOptionPane.setComponentOrientation(((JComponent)((Object)view)).getComponentOrientation());
        }
        JDialog jDialog = jOptionPane.createDialog(SwingUtilities.getRootPane((JComponent)((Object)view)), string);
        jDialog.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        jDialog.setResizable(true);
        jDialog.pack();
        jDialog.setMinimumSize(jDialog.getPreferredSize());
        jDialog.setVisible(true);
        jDialog.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ActionType {
        SHOW_PREVIOUS_PAGE,
        SHOW_NEXT_PAGE;

    }
}

