/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.Undoable;
import java.awt.event.MouseEvent;

public class ConnectedTextTool
extends TextTool {
    private boolean fConnected = false;

    public ConnectedTextTool(DrawingEditor editor, Figure prototype) {
        super(editor, prototype);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        Figure pressedFigure = this.drawing().findFigureInside(x, y);
        TextHolder textHolder = this.getTypingTarget();
        if (!this.fConnected && pressedFigure != null && textHolder != null && pressedFigure != textHolder) {
            textHolder.connect(pressedFigure);
            ((UndoActivity)this.getUndoActivity()).setConnectedFigure(pressedFigure);
            this.fConnected = true;
        }
    }

    public void activate() {
        super.activate();
        this.fConnected = false;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.getTypingTarget().getText());
    }

    public static class UndoActivity
    extends TextTool.UndoActivity {
        private Figure myConnectedFigure;

        public UndoActivity(DrawingView newDrawingView, String newOriginalText) {
            super(newDrawingView, newOriginalText);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasMoreElements()) {
                Figure currentFigure = fe.nextFigure();
                if (!(currentFigure instanceof TextHolder)) continue;
                TextHolder currentTextHolder = (TextHolder)((Object)currentFigure);
                if (!this.isValidText(this.getOriginalText())) {
                    currentTextHolder.disconnect(this.getConnectedFigure());
                    continue;
                }
                if (this.isValidText(this.getBackupText())) continue;
                currentTextHolder.connect(this.getConnectedFigure());
            }
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasMoreElements()) {
                Figure currentFigure = fe.nextFigure();
                if (!(currentFigure instanceof TextHolder)) continue;
                TextHolder currentTextHolder = (TextHolder)((Object)currentFigure);
                if (!this.isValidText(this.getBackupText())) {
                    currentTextHolder.disconnect(this.getConnectedFigure());
                    continue;
                }
                if (this.isValidText(this.getOriginalText())) continue;
                currentTextHolder.connect(this.getConnectedFigure());
            }
            return true;
        }

        public void setConnectedFigure(Figure newConnectedFigure) {
            this.myConnectedFigure = newConnectedFigure;
        }

        public Figure getConnectedFigure() {
            return this.myConnectedFigure;
        }
    }
}

