/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.interlis.tools;

import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.interlis.attributes.AttributeDef;
import ch.ehi.interlis.modeltopicclass.AbstractClassDef;
import ch.ehi.interlis.tools.RoleDefUtility;
import ch.ehi.uml1_4.implementation.AbstractModelElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class AbstractClassDefUtility {
    private AbstractClassDefUtility() {
    }

    public static List getIliAttributes(AbstractClassDef aclass) {
        Iterator it = aclass.iteratorFeature();
        ArrayList<AbstractModelElement> attrlist = new ArrayList<AbstractModelElement>();
        while (it != null && it.hasNext()) {
            Object feature = it.next();
            if (!(feature instanceof AttributeDef)) continue;
            attrlist.add((AttributeDef)feature);
        }
        ArrayList<RoleDef> rolesSorted = new ArrayList<RoleDef>();
        it = aclass.iteratorAssociation();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof RoleDef) || !RoleDefUtility.isIliAttr((RoleDef)obj)) continue;
            rolesSorted.add(RoleDefUtility.getOppEnd((RoleDef)obj));
        }
        Collections.sort(rolesSorted, new Comparator(){

            public int compare(Object o1, Object o2) {
                int idx2;
                int idx1 = ((RoleDef)o1).getIliAttributeIdx();
                if (idx1 == (idx2 = ((RoleDef)o2).getIliAttributeIdx())) {
                    if (idx1 == -1) {
                        return ((RoleDef)o1).getDefLangName().compareTo(((RoleDef)o2).getDefLangName());
                    }
                    return 0;
                }
                if (idx1 == -1) {
                    return 1;
                }
                if (idx2 == -1) {
                    return -1;
                }
                if (idx1 < idx2) {
                    return -1;
                }
                return 1;
            }
        });
        for (RoleDef role : rolesSorted) {
            int idx = role.getIliAttributeIdx();
            if (idx == -1 || idx >= attrlist.size()) {
                attrlist.add(role);
                continue;
            }
            attrlist.add(idx, role);
        }
        return attrlist;
    }
}

