/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view;

import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.CommonUserAccess;
import ch.softenvironment.view.SimpleEditorPanelListener;
import ch.softenvironment.view.SimpleEditorPanelListenerEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class SimpleEditorPanel
extends JPanel {
    private boolean hasContentsChanged = false;
    private JTextArea ivjTxaEditor = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JSeparator ivjJSeparator2 = null;
    private JSeparator ivjJSeparator22 = null;
    private JMenuItem ivjMniCopy = null;
    private JMenuItem ivjMniCut = null;
    private JMenuItem ivjMniPaste = null;
    private JMenuItem ivjMniRedo = null;
    private JMenuItem ivjMniSelectAll = null;
    private JMenuItem ivjMniUndo = null;
    private JPopupMenu ivjMnuEdit = null;
    private JMenuItem ivjMniDelete = null;
    private JScrollPane ivjScpEditor = null;
    protected transient SimpleEditorPanelListener fieldSimpleEditorPanelListenerEventMulticaster = null;

    public SimpleEditorPanel() {
        this.initialize();
    }

    public SimpleEditorPanel(LayoutManager layout) {
        super(layout);
        this.initialize();
    }

    public SimpleEditorPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initialize();
    }

    public void addSimpleEditorPanelListener(SimpleEditorPanelListener newListener) {
        this.fieldSimpleEditorPanelListenerEventMulticaster = SimpleEditorPanelListenerEventMulticaster.add(this.fieldSimpleEditorPanelListenerEventMulticaster, newListener);
    }

    public void append(String text) {
        this.getTxaEditor().append(text);
        this.setContentsChanged();
    }

    public void clearAll() {
        this.getTxaEditor().selectAll();
        this.mniDelete();
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.mniDelete();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC10(MouseEvent arg1) {
        try {
            this.genericPopupDisplay(arg1, this.getMnuEdit());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.mniUndo();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.mniRedo();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(MouseEvent arg1) {
        try {
            this.genericPopupDisplay(arg1, this.getMnuEdit());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(KeyEvent arg1) {
        try {
            this.setContentsChanged();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(ActionEvent arg1) {
        try {
            this.mniCut();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(ActionEvent arg1) {
        try {
            this.mniCopy();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC9(ActionEvent arg1) {
        try {
            this.mniPaste();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            this.getTxaEditor().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2(FocusEvent arg1) {
        try {
            this.getTxaEditor().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    protected void fireTxaEditorKey_keyReleased(EventObject newEvent) {
        if (this.fieldSimpleEditorPanelListenerEventMulticaster == null) {
            return;
        }
        this.fieldSimpleEditorPanelListenerEventMulticaster.txaEditorKey_keyReleased(newEvent);
    }

    private void genericPopupDisplay(MouseEvent event, JPopupMenu popupMenu) {
        boolean isEnabled = this.getTxaEditor().isEnabled();
        if (event.isPopupTrigger() && isEnabled) {
            boolean isEditable = this.getTxaEditor().isEditable();
            boolean isSelected = this.getTxaEditor().getSelectedText() != null;
            this.getMniCopy().setEnabled(isSelected);
            this.getMniCut().setEnabled(isEditable && isSelected);
            this.getMniDelete().setEnabled(isEditable && isSelected);
            this.getMniSelectAll().setEnabled(this.getTxaEditor().getText().length() > 0);
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            this.getMniPaste().setEnabled(isEditable && clipboard.getContents(this) != null);
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    private JSeparator getJSeparator2() {
        if (this.ivjJSeparator2 == null) {
            try {
                this.ivjJSeparator2 = new JSeparator();
                this.ivjJSeparator2.setName("JSeparator2");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator2;
    }

    private JSeparator getJSeparator22() {
        if (this.ivjJSeparator22 == null) {
            try {
                this.ivjJSeparator22 = new JSeparator();
                this.ivjJSeparator22.setName("JSeparator22");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator22;
    }

    private JMenuItem getMniCopy() {
        if (this.ivjMniCopy == null) {
            try {
                this.ivjMniCopy = new JMenuItem();
                this.ivjMniCopy.setName("MniCopy");
                this.ivjMniCopy.setText("Kopieren");
                this.ivjMniCopy.setEnabled(false);
                this.ivjMniCopy.setText(ResourceManager.getResource(CommonUserAccess.class, "MniEditCopy_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMniCopy;
    }

    private JMenuItem getMniCut() {
        if (this.ivjMniCut == null) {
            try {
                this.ivjMniCut = new JMenuItem();
                this.ivjMniCut.setName("MniCut");
                this.ivjMniCut.setText("Ausschneiden");
                this.ivjMniCut.setEnabled(false);
                this.ivjMniCut.setText(ResourceManager.getResource(CommonUserAccess.class, "MniEditCut_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMniCut;
    }

    private JMenuItem getMniDelete() {
        if (this.ivjMniDelete == null) {
            try {
                this.ivjMniDelete = new JMenuItem();
                this.ivjMniDelete.setName("MniDelete");
                this.ivjMniDelete.setText("L\u00f6schen");
                this.ivjMniDelete.setEnabled(false);
                this.ivjMniDelete.setText(ResourceManager.getResource(CommonUserAccess.class, "MniEditRemove_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMniDelete;
    }

    private JMenuItem getMniPaste() {
        if (this.ivjMniPaste == null) {
            try {
                this.ivjMniPaste = new JMenuItem();
                this.ivjMniPaste.setName("MniPaste");
                this.ivjMniPaste.setText("Einf\u00fcgen");
                this.ivjMniPaste.setEnabled(false);
                this.ivjMniPaste.setText(ResourceManager.getResource(CommonUserAccess.class, "MniEditPaste_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMniPaste;
    }

    private JMenuItem getMniRedo() {
        if (this.ivjMniRedo == null) {
            try {
                this.ivjMniRedo = new JMenuItem();
                this.ivjMniRedo.setName("MniRedo");
                this.ivjMniRedo.setText("Wiederherstellen");
                this.ivjMniRedo.setEnabled(false);
                this.ivjMniRedo.setText(ResourceManager.getResource(CommonUserAccess.class, "MniEditRedo_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMniRedo;
    }

    private JMenuItem getMniSelectAll() {
        if (this.ivjMniSelectAll == null) {
            try {
                this.ivjMniSelectAll = new JMenuItem();
                this.ivjMniSelectAll.setName("MniSelectAll");
                this.ivjMniSelectAll.setText("Alles markieren");
                this.ivjMniSelectAll.setEnabled(false);
                this.ivjMniSelectAll.setText(ResourceManager.getResource(CommonUserAccess.class, "MniEditSelectAll_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMniSelectAll;
    }

    private JMenuItem getMniUndo() {
        if (this.ivjMniUndo == null) {
            try {
                this.ivjMniUndo = new JMenuItem();
                this.ivjMniUndo.setName("MniUndo");
                this.ivjMniUndo.setText("R\u00fcckg\u00e4ngig");
                this.ivjMniUndo.setEnabled(false);
                this.ivjMniUndo.setText(ResourceManager.getResource(CommonUserAccess.class, "MniEditUndo_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMniUndo;
    }

    private JPopupMenu getMnuEdit() {
        if (this.ivjMnuEdit == null) {
            try {
                this.ivjMnuEdit = new JPopupMenu();
                this.ivjMnuEdit.setName("MnuEdit");
                this.ivjMnuEdit.add(this.getMniUndo());
                this.ivjMnuEdit.add(this.getMniRedo());
                this.ivjMnuEdit.add(this.getJSeparator22());
                this.ivjMnuEdit.add(this.getMniCut());
                this.ivjMnuEdit.add(this.getMniCopy());
                this.ivjMnuEdit.add(this.getMniPaste());
                this.ivjMnuEdit.add(this.getMniDelete());
                this.ivjMnuEdit.add(this.getJSeparator2());
                this.ivjMnuEdit.add(this.getMniSelectAll());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMnuEdit;
    }

    private JScrollPane getScpEditor() {
        if (this.ivjScpEditor == null) {
            try {
                this.ivjScpEditor = new JScrollPane();
                this.ivjScpEditor.setName("ScpEditor");
                this.ivjScpEditor.setAutoscrolls(true);
                this.getScpEditor().setViewportView(this.getTxaEditor());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjScpEditor;
    }

    public String getText() {
        return this.getTxaEditor().getText();
    }

    private JTextArea getTxaEditor() {
        if (this.ivjTxaEditor == null) {
            try {
                this.ivjTxaEditor = new JTextArea();
                this.ivjTxaEditor.setName("TxaEditor");
                this.ivjTxaEditor.setLineWrap(true);
                this.ivjTxaEditor.setWrapStyleWord(true);
                this.ivjTxaEditor.setBounds(0, 0, 160, 117);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxaEditor;
    }

    public boolean getTxaEditorEditable() {
        return this.getTxaEditor().isEditable();
    }

    private void handleException(Throwable exception) {
        Tracer.getInstance().uncaughtException(exception);
    }

    public boolean hasContentsChanged() {
        return this.hasContentsChanged;
    }

    private void initConnections() throws Exception {
        this.getMniUndo().addActionListener(this.ivjEventHandler);
        this.getMniRedo().addActionListener(this.ivjEventHandler);
        this.getMniSelectAll().addActionListener(this.ivjEventHandler);
        this.getTxaEditor().addMouseListener(this.ivjEventHandler);
        this.getMniDelete().addActionListener(this.ivjEventHandler);
        this.getTxaEditor().addKeyListener(this.ivjEventHandler);
        this.getMniCut().addActionListener(this.ivjEventHandler);
        this.getMniCopy().addActionListener(this.ivjEventHandler);
        this.getMniPaste().addActionListener(this.ivjEventHandler);
        this.getTxaEditor().addFocusListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("PnlEditor");
            this.setAutoscrolls(true);
            this.setLayout(new BoxLayout(this, 0));
            this.setSize(160, 120);
            this.add((Component)this.getScpEditor(), this.getScpEditor().getName());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void mniCopy() {
        this.getTxaEditor().copy();
    }

    private void mniCut() {
        this.getTxaEditor().cut();
        this.setContentsChanged();
    }

    private void mniDelete() {
        this.getTxaEditor().replaceSelection("");
        this.setContentsChanged();
    }

    private void mniPaste() {
        this.getTxaEditor().paste();
        this.setContentsChanged();
    }

    private void mniRedo() {
        this.setContentsChanged();
    }

    private void mniUndo() {
        this.setContentsChanged();
    }

    public void removeSimpleEditorPanelListener(SimpleEditorPanelListener newListener) {
        this.fieldSimpleEditorPanelListenerEventMulticaster = SimpleEditorPanelListenerEventMulticaster.remove(this.fieldSimpleEditorPanelListenerEventMulticaster, newListener);
    }

    @Override
    public void setBackground(Color color) {
        this.getTxaEditor().setBackground(color);
    }

    private void setContentsChanged() {
        this.hasContentsChanged = true;
        this.fireTxaEditorKey_keyReleased(new EventObject(this));
    }

    public void setEditable(boolean isEditable) {
        this.getTxaEditor().setEditable(isEditable);
        if (isEditable) {
            this.getTxaEditor().setBackground(Color.white);
        } else {
            this.getTxaEditor().setBackground(Color.lightGray);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.getTxaEditor().setEnabled(isEnabled);
    }

    public void setLineWrap(boolean isLineWrap) {
        this.getTxaEditor().setLineWrap(isLineWrap);
    }

    public void setText(String text) {
        this.getTxaEditor().setText(text);
    }

    @Override
    public void setToolTipText(String toolTip) {
        this.getTxaEditor().setToolTipText(toolTip);
    }

    public void setTxaEditorEditable(boolean arg1) {
        this.getTxaEditor().setEditable(arg1);
    }

    class IvjEventHandler
    implements ActionListener,
    FocusListener,
    KeyListener,
    MouseListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SimpleEditorPanel.this.getMniUndo()) {
                SimpleEditorPanel.this.connEtoC2(e);
            }
            if (e.getSource() == SimpleEditorPanel.this.getMniRedo()) {
                SimpleEditorPanel.this.connEtoC3(e);
            }
            if (e.getSource() == SimpleEditorPanel.this.getMniSelectAll()) {
                SimpleEditorPanel.this.connEtoM1(e);
            }
            if (e.getSource() == SimpleEditorPanel.this.getMniDelete()) {
                SimpleEditorPanel.this.connEtoC1(e);
            }
            if (e.getSource() == SimpleEditorPanel.this.getMniCut()) {
                SimpleEditorPanel.this.connEtoC6(e);
            }
            if (e.getSource() == SimpleEditorPanel.this.getMniCopy()) {
                SimpleEditorPanel.this.connEtoC7(e);
            }
            if (e.getSource() == SimpleEditorPanel.this.getMniPaste()) {
                SimpleEditorPanel.this.connEtoC9(e);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == SimpleEditorPanel.this.getTxaEditor()) {
                SimpleEditorPanel.this.connEtoM2(e);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getSource() == SimpleEditorPanel.this.getTxaEditor()) {
                SimpleEditorPanel.this.connEtoC5(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == SimpleEditorPanel.this.getTxaEditor()) {
                SimpleEditorPanel.this.connEtoC10(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == SimpleEditorPanel.this.getTxaEditor()) {
                SimpleEditorPanel.this.connEtoC4(e);
            }
        }
    }
}

