/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view.swingext;

import ch.softenvironment.util.BeanReflector;
import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.util.Evaluator;
import ch.softenvironment.util.ListUtils;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class JComboBoxUtility {
    public static final int SORT_KEEP_ORDER = 100;
    public static final int SORT_ASCENDING = 101;

    public static void initComboBox(JComboBox comboBox, List items, String property) {
        JComboBoxUtility.initComboBox(comboBox, items, property, false);
    }

    public static void initComboBox(JComboBox comboBox, List items, String property, boolean addNullElement) {
        JComboBoxUtility.initComboBox(comboBox, items, property, addNullElement, new BeanEvaluator());
    }

    public static void initComboBox(JComboBox comboBox, List items, String property, boolean addNullElement, Evaluator evaluator) {
        JComboBoxUtility.initComboBox(comboBox, items, property, addNullElement, evaluator, 101);
    }

    public static void initComboBox(JComboBox comboBox, List items, String property, boolean addNullElement, Evaluator evaluator, int sort) {
        Evaluator eval = evaluator;
        if (eval == null) {
            eval = new BeanEvaluator();
        }
        comboBox.setRenderer(new ObjectComboBoxRenderer(eval, property));
        comboBox.setModel(new SortedComboBoxModel(items, eval, property, addNullElement, sort));
    }

    protected static class SortedComboBoxModel
    extends DefaultComboBoxModel {
        protected SortedComboBoxModel(List items, Evaluator evaluator, String property, boolean addNullElement, int sort) {
            if (addNullElement) {
                this.addElement(null);
            }
            Iterator iterator = null;
            iterator = sort == 101 ? ListUtils.sort(items, evaluator, property).iterator() : items.iterator();
            while (iterator.hasNext()) {
                this.addElement(iterator.next());
            }
        }
    }

    protected static class ObjectComboBoxRenderer
    extends BasicComboBoxRenderer {
        private Evaluator evaluator = null;
        private String property = null;

        protected ObjectComboBoxRenderer(Evaluator evaluator, String property) {
            this.evaluator = evaluator;
            this.property = property;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
            } else if (value == null) {
                this.setText("");
            } else {
                Object result = this.evaluator.evaluate(value, this.property);
                if (result == null) {
                    this.setText("");
                } else {
                    this.setText(result.toString());
                }
            }
            return this;
        }
    }

    protected static class BeanEvaluator
    implements Evaluator {
        protected BeanEvaluator() {
        }

        @Override
        public Object evaluate(Object owner, String property) {
            try {
                if (owner != null) {
                    BeanReflector br = new BeanReflector(owner, property);
                    return br.getValue();
                }
            }
            catch (Throwable e) {
                throw new DeveloperException("cannot determine value: " + e.getLocalizedMessage());
            }
            return null;
        }
    }
}

