/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.swing.graphics.AbstractPanelArtist;
import org.freehep.swing.graphics.BackedPanel;
import org.freehep.swing.graphics.GraphicalSelectionPanel;
import org.freehep.swing.layout.StackedLayout;

public class StackedPanel
extends JLayeredPane
implements Serializable,
PropertyChangeListener {
    private Component componentToPrint = null;
    VectorGraphics printGraphics = null;
    private boolean inhibitRepaint = false;
    public static final String NEED_GRAPHICAL_SELECTION_PANEL = "Class must be a type of GraphicalSelectionPanel";
    private AbstractPanelArtist panelArtist = null;
    private UpdateTask updateTask;
    private Timer timer;
    public static final Integer INTERACTION_LAYER = new Integer(PALETTE_LAYER - 1);
    public static final Integer MINIMUM_LAYER = DEFAULT_LAYER;
    public static final Integer MAXIMUM_LAYER = INTERACTION_LAYER;
    private LinkedList panelList = new LinkedList();
    private HashMap panelHash = new HashMap(15);
    private boolean redrawNeeded;

    public StackedPanel() {
        this(null);
    }

    public StackedPanel(AbstractPanelArtist panelArtist) {
        this.updateTask = new UpdateTask();
        this.timer = new Timer(300, this.updateTask);
        this.setRedrawNeeded(true);
        this.setLayout(new StackedLayout());
        this.setPanelArtist(panelArtist);
    }

    public void addLayer(String layerName, int sublayers, boolean opaque) {
        if (sublayers <= 0) {
            throw new IllegalArgumentException();
        }
        JComponent[] panels = new JComponent[sublayers];
        for (int i = 0; i < sublayers; ++i) {
            panels[i] = new BackedPanel(opaque && i == sublayers - 1);
        }
        this.addLayer(layerName, panels);
    }

    public void addLayer(String layerName, JComponent panel) {
        this.addLayer(layerName, new JComponent[]{panel});
    }

    public void addLayer(String layerName, JComponent[] panels) {
        PanelArray panelArray = new PanelArray(panels);
        if (this.panelList.contains(layerName)) {
            this.removeLayer(layerName);
        }
        for (int i = 0; i < panels.length; ++i) {
            this.add(panels[i]);
        }
        this.panelList.add(layerName);
        this.panelHash.put(layerName, panelArray);
        this.reorderLayers();
    }

    public void removeLayer(String layerName) {
        PanelArray panelArray = (PanelArray)this.panelHash.get(layerName);
        if (panelArray != null) {
            Component[] comps = panelArray.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.remove(comps[i]);
            }
            panelArray.clear();
            this.panelList.remove(layerName);
            this.panelHash.remove(layerName);
            this.reorderLayers();
        }
    }

    public void reorderLayers() {
        int layer = MINIMUM_LAYER;
        Iterator i = this.panelList.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            PanelArray panelArray = (PanelArray)this.panelHash.get(key);
            if (panelArray == null) continue;
            Component[] comps = panelArray.getComponents();
            for (int j = comps.length - 1; j >= 0; --j) {
                this.setLayer(comps[j], layer++);
            }
        }
    }

    public void addGraphicalSelectionPanel(GraphicalSelectionPanel panel) {
        panel.setVisible(false);
        this.add((Component)panel, INTERACTION_LAYER);
    }

    public void removeGraphicalSelectionPanel(GraphicalSelectionPanel panel) {
        this.remove(panel);
    }

    public void activateGraphicalSelectionPanelOfClass(Class c) throws InstantiationException, IllegalAccessException {
        if (!GraphicalSelectionPanel.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException(NEED_GRAPHICAL_SELECTION_PANEL);
        }
        Component[] components = this.getComponentsInLayer(INTERACTION_LAYER);
        boolean create = true;
        for (int i = 0; i < components.length; ++i) {
            boolean test = c == components[i].getClass();
            components[i].setVisible(test);
            if (!test) continue;
            create = false;
        }
        if (create) {
            GraphicalSelectionPanel newSelector = (GraphicalSelectionPanel)c.newInstance();
            this.addGraphicalSelectionPanel(newSelector);
            newSelector.setVisible(true);
            if (this.panelArtist != null) {
                newSelector.addGraphicalSelectionListener(this.panelArtist);
            }
        }
    }

    public void activateGraphicalSelectionPanel(GraphicalSelectionPanel panel) {
        Component[] components = this.getComponentsInLayer(INTERACTION_LAYER);
        for (int i = 0; i < components.length; ++i) {
            components[i].setVisible(components[i] == panel);
        }
    }

    public void deactivateGraphicalSelectionPanels() {
        Component[] components = this.getComponentsInLayer(INTERACTION_LAYER);
        for (int i = 0; i < components.length; ++i) {
            components[i].setVisible(false);
        }
    }

    public void setVisible(String layerName, boolean[] visible) {
        PanelArray panelArray = (PanelArray)this.panelHash.get(layerName);
        if (panelArray != null) {
            Component[] comps = panelArray.getComponents();
            if (visible.length < comps.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < comps.length; ++i) {
                comps[i].setVisible(visible[i]);
            }
        }
    }

    public void setPanelArtist(AbstractPanelArtist panelArtist) {
        Component[] components = this.getComponentsInLayer(INTERACTION_LAYER);
        for (int i = 0; i < components.length; ++i) {
            GraphicalSelectionPanel selector = (GraphicalSelectionPanel)components[i];
            if (this.panelArtist != null) {
                selector.removeGraphicalSelectionListener(this.panelArtist);
            }
            if (panelArtist == null) continue;
            selector.addGraphicalSelectionListener(panelArtist);
        }
        if (this.panelArtist != null) {
            this.panelArtist.setStackedPanel(null);
        }
        this.panelArtist = panelArtist;
        if (panelArtist != null) {
            panelArtist.setStackedPanel(this);
            if (panelArtist instanceof MouseListener) {
                this.addMouseListener((MouseListener)((Object)panelArtist));
            }
        }
    }

    public AbstractPanelArtist getPanelArtist() {
        return this.panelArtist;
    }

    public boolean isRedrawNeeded() {
        return this.redrawNeeded;
    }

    public void setRedrawNeeded(boolean redrawNeeded) {
        this.redrawNeeded = redrawNeeded;
    }

    public void getGraphics(String layerName, Graphics[] g) {
        PanelArray panelArray = (PanelArray)this.panelHash.get(layerName);
        if (panelArray != null) {
            Component[] comps = panelArray.getComponents();
            if (g.length < comps.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < comps.length; ++i) {
                if (this.componentToPrint != null && comps[i] == this.componentToPrint) {
                    g[i] = this.printGraphics;
                    continue;
                }
                if (this.componentToPrint != null) {
                    g[i] = null;
                    continue;
                }
                if (comps[i] == null) continue;
                g[i] = comps[i].getGraphics();
            }
        }
    }

    public void clearAllLayers() {
        Iterator iterator = this.panelHash.keySet().iterator();
        while (iterator.hasNext()) {
            this.clearLayer((String)iterator.next());
        }
    }

    public void clearLayer(String layerName) {
        if (this.componentToPrint == null) {
            Graphics[] g = new Graphics2D[2];
            this.getGraphics(layerName, g);
            Insets insets = this.getInsets();
            int w = this.getWidth() - (insets.left + insets.right);
            int h = this.getHeight() - (insets.top + insets.bottom);
            for (int i = 0; i < 2; ++i) {
                Graphics g2d = g[i];
                if (g2d == null) continue;
                ((Graphics2D)g2d).setComposite(AlphaComposite.Clear);
                g2d.fillRect(0, 0, w, h);
                ((Graphics2D)g2d).setComposite(AlphaComposite.Src);
            }
        }
    }

    public void setAntialias(String layerName, boolean antialias) {
        if (this.componentToPrint == null) {
            Graphics[] g = new Graphics[2];
            this.getGraphics(layerName, g);
            for (int i = 0; i < 2; ++i) {
                Graphics2D g2d = (Graphics2D)g[i];
                if (g2d == null) continue;
                if (antialias) {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    continue;
                }
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        System.out.println("Done");
    }

    public void paintChildren(Graphics g) {
        System.out.println("Children...");
        long t0 = System.currentTimeMillis();
        super.paintChildren(g);
        long t1 = System.currentTimeMillis();
        System.out.println("Children took: " + (t1 - t0) + " ms.");
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.redrawNeeded && !this.inhibitRepaint) {
            this.setRedrawNeeded(false);
            this.stopPeriodicUpdate();
            if (this.panelArtist != null && !this.panelArtist.drawPanel()) {
                this.startPeriodicUpdate();
            }
        }
    }

    public void printComponent(Graphics g) {
        if (this.panelArtist != null) {
            int i;
            VectorGraphics tempGraphics = VectorGraphics.create(g);
            Insets insets = this.getInsets();
            int w = this.getWidth();
            int h = this.getHeight();
            this.printGraphics = (VectorGraphics)tempGraphics.create(insets.left, insets.top, w - (insets.left + insets.right), h - (insets.top + insets.bottom));
            this.printGraphics.printComment("StackedPanel: START ");
            Component[] clist = this.getComponents();
            Object[] indexed = new ComponentIndex[clist.length];
            for (i = 0; i < clist.length; ++i) {
                Component c = clist[i];
                indexed[i] = new ComponentIndex(c, this.getLayer(c), this.getPosition(c));
            }
            Arrays.sort(indexed);
            for (i = 0; i < indexed.length; ++i) {
                this.componentToPrint = ((ComponentIndex)indexed[i]).getComponent();
                if (!this.componentToPrint.isVisible()) continue;
                if (this.componentToPrint instanceof BackedPanel) {
                    this.printGraphics.printComment("StackedPanel: " + i + " " + this.panelArtist.getDescription());
                    this.panelArtist.drawPanel();
                    continue;
                }
                if (this.componentToPrint instanceof JComponent) {
                    this.printGraphics.printComment("StackedPanel: " + i + " JComponent " + this.componentToPrint.getClass().getName());
                    this.componentToPrint.print(g);
                    continue;
                }
                this.printGraphics.printComment("StackedPanel: " + i + " Component " + this.componentToPrint.getClass().getName());
                this.componentToPrint.paintAll(g);
            }
            this.printGraphics.printComment("StackedPanel: END ");
            this.componentToPrint = null;
            this.printGraphics.dispose();
            this.printGraphics = null;
        }
    }

    public void drawComplete() {
        this.stopPeriodicUpdate();
        this.updateTask.actionPerformed(new ActionEvent(this, 1001, "timer.stop"));
    }

    public void setUpdatePeriod(int period) {
        this.timer.setDelay(Math.max(0, period));
    }

    public long getUpdatePeriod() {
        return this.timer.getDelay();
    }

    protected void startPeriodicUpdate() {
        this.timer.restart();
    }

    protected void stopPeriodicUpdate() {
        this.timer.stop();
    }

    public void setBorder(Border border) {
        Insets insets = this.getInsets();
        Insets borderInsets = null;
        borderInsets = border != null ? border.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        if (insets.left != borderInsets.left || insets.top != borderInsets.top || insets.right != borderInsets.right || insets.bottom != borderInsets.bottom) {
            this.setRedrawNeeded(true);
        }
        super.setBorder(border);
    }

    public void setBounds(int x, int y, int w, int h) {
        if (!this.inhibitRepaint) {
            super.setBounds(x, y, w, h);
            if (this.panelArtist != null) {
                this.panelArtist.panelResized();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("InhibitRepaint")) {
            if (evt.getNewValue() == null) {
                this.inhibitRepaint = false;
                this.invalidate();
                this.validate();
                this.repaint();
            } else {
                this.inhibitRepaint = true;
            }
        }
    }

    public void printBorder(Graphics g) {
        VectorGraphics vg = null;
        if (g instanceof VectorGraphics) {
            vg = (VectorGraphics)g;
        }
        if (vg != null) {
            vg.printComment("StackedPanel: (border) START ");
        }
        super.printBorder(g);
        if (vg != null) {
            vg.printComment("StackedPanel: (border) END ");
        }
    }

    public void printChildren(Graphics g) {
        VectorGraphics vg = null;
        if (g instanceof VectorGraphics) {
            vg = (VectorGraphics)g;
        }
        if (vg != null) {
            vg.printComment("StackedPanel: (children) START ");
        }
        super.printChildren(g);
        if (vg != null) {
            vg.printComment("StackedPanel: (children) END ");
        }
    }

    private class ComponentIndex
    implements Comparable {
        private Component component;
        private int layer;
        private int position;

        public ComponentIndex(Component component, int layer, int position) {
            this.component = component;
            this.layer = layer;
            this.position = position;
        }

        public Component getComponent() {
            return this.component;
        }

        public int hashcode() {
            return this.layer ^ this.position;
        }

        public boolean equals(Object o) {
            ComponentIndex other = (ComponentIndex)o;
            return this.layer == other.layer && this.position == other.position;
        }

        public int compareTo(Object o) {
            ComponentIndex other = (ComponentIndex)o;
            if (this.layer < other.layer) {
                return -1;
            }
            if (this.layer > other.layer) {
                return 1;
            }
            if (this.position > other.position) {
                return -1;
            }
            if (this.position < other.position) {
                return 1;
            }
            return 0;
        }
    }

    protected class PanelArray {
        private JComponent[] panels;

        public PanelArray(JComponent[] panels) {
            this.panels = panels;
        }

        public Component[] getComponents() {
            return this.panels;
        }

        public JComponent getComponent(int index) {
            return this.panels[index];
        }

        public void clear() {
            for (int i = 0; i < this.panels.length; ++i) {
                this.panels[i] = null;
            }
            this.panels = null;
        }
    }

    class UpdateTask
    implements ActionListener {
        UpdateTask() {
        }

        public void actionPerformed(ActionEvent event) {
            StackedPanel.this.repaint();
        }
    }
}

