/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.xtf;

import ch.interlis.ili2c.generator.XSD24Generator;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom_j.ViewableProperties;
import ch.interlis.iom_j.ViewableProperty;
import ch.interlis.iom_j.itf.ModelUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Ili2cUtility {
    private Ili2cUtility() {
    }

    public static ViewableProperties getIoxMappingTable(TransferDescription td) {
        ViewableProperties mapping = new ViewableProperties();
        if (td.getLastModel().getIliVersion().equals("2.4")) {
            mapping.setXtf24nameMapping(XSD24Generator.createName2NameMapping(td));
            HashMap tagv = XSD24Generator.createDef2NameMapping(td);
            for (Element ili2cEle : tagv.keySet()) {
                ViewableProperty prop;
                String tag = null;
                ArrayList<ViewableProperty> propv = new ArrayList<ViewableProperty>();
                if (ili2cEle instanceof AttributeDef) {
                    AttributeDef attr = (AttributeDef)ili2cEle;
                    tag = String.valueOf(ili2cEle.getContainer().getScopedName(null)) + "." + ili2cEle.getName();
                    Table linattrTab = ((AreaType)attr.getDomainResolvingAliases()).getLineAttributeStructure();
                    if (linattrTab != null) {
                        Iterator<ViewableTransferElement> iter = linattrTab.getAttributesAndRoles2();
                        while (iter.hasNext()) {
                            String propName = null;
                            ViewableTransferElement obj = iter.next();
                            if (obj.obj instanceof AttributeDef) {
                                propName = ((AttributeDef)obj.obj).getName();
                            }
                            if (obj.obj instanceof RoleDef) {
                                AssociationDef roleOwner;
                                RoleDef role = (RoleDef)obj.obj;
                                if (obj.embedded && (roleOwner = (AssociationDef)role.getContainer()).getDerivedFrom() == null) {
                                    propName = role.getName();
                                }
                            }
                            if (propName == null) continue;
                            prop = new ViewableProperty(propName);
                            propv.add(prop);
                        }
                    }
                    ViewableProperty prop2 = new ViewableProperty(ModelUtilities.getHelperTableGeomAttrName(attr));
                    if (attr.isFinal()) {
                        prop2.setTypeFinal(true);
                    }
                    propv.add(prop2);
                } else if (ili2cEle instanceof Viewable) {
                    Viewable v = (Viewable)ili2cEle;
                    tag = v.getScopedName((Container)null);
                    Iterator<ViewableTransferElement> iter = v.getAttributesAndRoles2();
                    while (iter.hasNext()) {
                        AssociationDef roleOwner;
                        ViewableProperty prop3;
                        ViewableTransferElement obj = iter.next();
                        if (obj.obj instanceof AttributeDef) {
                            AttributeDef attr = (AttributeDef)obj.obj;
                            prop3 = new ViewableProperty(attr.getName());
                            Type type = attr.getDomain();
                            if (type instanceof TypeAlias) {
                                Domain domainDef = ((TypeAlias)type).getAliasing();
                                if (domainDef.getType() instanceof EnumerationType) {
                                    prop3.setEnumType(domainDef.getScopedName(null));
                                }
                                if (domainDef.isFinal()) {
                                    prop3.setTypeFinal(true);
                                }
                            } else {
                                if (type instanceof EnumerationType) {
                                    prop3.setEnumType(String.valueOf(attr.getContainer().getScopedName(null)) + ":" + attr.getName());
                                }
                                if (attr.isFinal()) {
                                    prop3.setTypeFinal(true);
                                }
                            }
                            if (attr.getDomainResolvingAliases() instanceof OIDType) {
                                prop3.setTypeOid(true);
                            }
                            AttributeDef baseAttr = attr;
                            if (attr.getExtending() != null) {
                                baseAttr = (AttributeDef)attr.getExtending();
                                while (baseAttr.getExtending() != null) {
                                    baseAttr = (AttributeDef)baseAttr.getExtending();
                                }
                            }
                            if (baseAttr.getContainer() != v) {
                                prop3.setBaseDefInClass(baseAttr.getContainer().getScopedName(null));
                            }
                            propv.add(prop3);
                        }
                        if (!(obj.obj instanceof RoleDef)) continue;
                        RoleDef role = (RoleDef)obj.obj;
                        if (!obj.embedded && !((AssociationDef)v).isLightweight()) {
                            prop3 = new ViewableProperty(role.getName());
                            RoleDef baseRole = role.getRootExtending();
                            if (baseRole == null) {
                                baseRole = role;
                            }
                            if (baseRole.getContainer() != v) {
                                prop3.setBaseDefInClass(baseRole.getContainer().getScopedName(null));
                            }
                            propv.add(prop3);
                        }
                        if (!obj.embedded || (roleOwner = (AssociationDef)role.getContainer()).getDerivedFrom() != null) continue;
                        prop = new ViewableProperty(role.getName());
                        RoleDef baseOppRole = role.getOppEnd().getRootExtending();
                        if (baseOppRole == null) {
                            baseOppRole = role.getOppEnd();
                        }
                        if (baseOppRole.getDestination() != v) {
                            prop.setBaseDefInClass(baseOppRole.getDestination().getScopedName((Container)null));
                        }
                        propv.add(prop);
                    }
                }
                mapping.defineClass(tag, propv.toArray(new ViewableProperty[propv.size()]));
            }
        } else {
            HashMap tagv = XSDGenerator.getTagMap(td);
            for (String tag : tagv.keySet()) {
                Viewable v = (Viewable)tagv.get(tag);
                Iterator<ViewableTransferElement> iter = v.getAttributesAndRoles2();
                ArrayList<ViewableProperty> propv = new ArrayList<ViewableProperty>();
                while (iter.hasNext()) {
                    AssociationDef roleOwner;
                    ViewableProperty prop;
                    ViewableTransferElement obj = iter.next();
                    if (obj.obj instanceof AttributeDef) {
                        AttributeDef attr = (AttributeDef)obj.obj;
                        prop = new ViewableProperty(attr.getName());
                        Type type = attr.getDomain();
                        if (type instanceof TypeAlias) {
                            Domain domainDef = ((TypeAlias)type).getAliasing();
                            if (domainDef.getType() instanceof EnumerationType) {
                                prop.setEnumType(domainDef.getScopedName(null));
                            }
                            if (domainDef.isFinal()) {
                                prop.setTypeFinal(true);
                            }
                        } else {
                            if (type instanceof EnumerationType) {
                                prop.setEnumType(String.valueOf(attr.getContainer().getScopedName(null)) + ":" + attr.getName());
                            }
                            if (attr.isFinal()) {
                                prop.setTypeFinal(true);
                            }
                        }
                        if (attr.getDomainResolvingAliases() instanceof OIDType) {
                            prop.setTypeOid(true);
                        }
                        AttributeDef baseAttr = attr;
                        if (attr.getExtending() != null) {
                            baseAttr = (AttributeDef)attr.getExtending();
                            while (baseAttr.getExtending() != null) {
                                baseAttr = (AttributeDef)baseAttr.getExtending();
                            }
                        }
                        if (baseAttr.getContainer() != v) {
                            prop.setBaseDefInClass(baseAttr.getContainer().getScopedName(null));
                        }
                        propv.add(prop);
                    }
                    if (!(obj.obj instanceof RoleDef)) continue;
                    RoleDef role = (RoleDef)obj.obj;
                    if (!obj.embedded && !((AssociationDef)v).isLightweight()) {
                        prop = new ViewableProperty(role.getName());
                        RoleDef baseRole = role.getRootExtending();
                        if (baseRole == null) {
                            baseRole = role;
                        }
                        if (baseRole.getContainer() != v) {
                            prop.setBaseDefInClass(baseRole.getContainer().getScopedName(null));
                        }
                        propv.add(prop);
                    }
                    if (!obj.embedded || (roleOwner = (AssociationDef)role.getContainer()).getDerivedFrom() != null) continue;
                    ViewableProperty prop4 = new ViewableProperty(role.getName());
                    RoleDef baseOppRole = role.getOppEnd().getRootExtending();
                    if (baseOppRole == null) {
                        baseOppRole = role.getOppEnd();
                    }
                    if (baseOppRole.getDestination() != v) {
                        prop4.setBaseDefInClass(baseOppRole.getDestination().getScopedName((Container)null));
                    }
                    propv.add(prop4);
                }
                mapping.defineClass(tag, propv.toArray(new ViewableProperty[propv.size()]));
            }
        }
        return mapping;
    }
}

