/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.db;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iom.IomObject;
import ch.interlis.iox_j.db.DbUtility;
import ch.interlis.iox_j.db.EnumMapper;
import ch.interlis.iox_j.db.IdMapper;
import java.sql.Date;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

public class Db2Xtf {
    private Db2Xtf() {
    }

    public static String getString(ResultSet rs, String colName, boolean isOptional, String recInfo, IomObject iomObj, String iliAttrName) {
        String val = DbUtility.getStringOrNull(rs, colName, isOptional, recInfo);
        if (val != null) {
            iomObj.setattrvalue(iliAttrName, val);
        }
        return val;
    }

    public static Integer getInt(ResultSet rs, String colName, boolean isOptional, String recInfo, IomObject iomObj, String iliAttrName) {
        Integer val = DbUtility.getInt(rs, colName, isOptional, recInfo);
        if (val != null) {
            iomObj.setattrvalue(iliAttrName, val.toString());
        }
        return val;
    }

    public static Double getDouble(ResultSet rs, String colName, boolean isOptional, String recInfo, IomObject iomObj, String iliAttrName) {
        Double val = DbUtility.getDouble(rs, colName, isOptional, recInfo);
        if (val != null) {
            iomObj.setattrvalue(iliAttrName, val.toString());
        }
        return val;
    }

    public static Date getXtfDate(ResultSet rs, String colName, boolean isOptional, String recInfo, IomObject iomObj, String iliAttrName) {
        Date val = DbUtility.getDate(rs, colName, isOptional, recInfo);
        if (val != null) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            iomObj.setattrvalue(iliAttrName, fmt.format(val));
        }
        return val;
    }

    public static String getDate(ResultSet rs, String colName, boolean isOptional, String recInfo, IomObject iomObj, String iliAttrName) {
        String val = DbUtility.getStringOrNull(rs, colName, isOptional, recInfo);
        if (val != null) {
            EhiLogger.debug("pre date <" + val + ">");
            int startPos = val.indexOf(46);
            int startPos2 = val.indexOf(46, startPos + 1);
            DecimalFormat digit4 = new DecimalFormat("0000");
            DecimalFormat digit2 = new DecimalFormat("00");
            if (startPos != -1 && startPos2 != -1) {
                String year = val.substring(0, startPos);
                String month = val.substring(startPos + 1, startPos2);
                String date = val.substring(startPos2 + 1);
                try {
                    int yearNum = Integer.parseInt(year);
                    if (yearNum < 10) {
                        yearNum += 2000;
                    } else if (yearNum < 100) {
                        yearNum += 1900;
                    }
                    val = String.valueOf(digit4.format(yearNum)) + "-" + digit2.format(Integer.parseInt(month)) + "-" + digit2.format(Integer.parseInt(date));
                }
                catch (NumberFormatException e) {
                    val = null;
                }
            } else if (val.length() == 8) {
                String year = val.substring(0, 4);
                String month = val.substring(4, 6);
                String date = val.substring(6, 8);
                try {
                    val = String.valueOf(digit4.format(Integer.parseInt(year))) + "-" + digit2.format(Integer.parseInt(month)) + "-" + digit2.format(Integer.parseInt(date));
                }
                catch (NumberFormatException e) {
                    val = null;
                }
            }
            EhiLogger.debug("post date <" + val + ">");
            if (val == null) {
                EhiLogger.logError(String.valueOf(recInfo) + ": illegal value <" + val + "> for column " + colName + "; ignored");
            } else {
                iomObj.setattrvalue(iliAttrName, val);
            }
        }
        return val;
    }

    public static String getMultiLineString(ResultSet rs, String colName, boolean isOptional, String recInfo, IomObject iomObj, String iliAttrName) {
        String val = DbUtility.getString(rs, colName, isOptional, recInfo);
        if (val != null) {
            val = val.replace('\n', ' ');
            val = val.replace('\r', ' ');
            val = val.replace('\t', ' ');
            if ((val = val.trim()).length() == 0) {
                val = null;
            }
        }
        if (val != null) {
            iomObj.setattrvalue(iliAttrName, val);
        }
        return val;
    }

    public static void getCoordFromWKT(ResultSet rs, String colName, boolean isOptional, String recInfo, IomObject iomObj, String iliAttrName) {
        String val = DbUtility.getStringFromBinary(rs, colName, isOptional, recInfo);
        if (val != null && (val = val.trim()).length() == 0) {
            val = null;
        }
        if (val != null) {
            String c1 = null;
            String c2 = null;
            if (val.startsWith("POINT")) {
                String c1c2;
                int startC2;
                int endC2;
                int startC1 = val.indexOf(40, 5);
                if (startC1 != -1 && (endC2 = val.indexOf(41, startC1)) != -1 && (startC2 = (c1c2 = val.substring(startC1 + 1, endC2).trim()).indexOf(32)) != -1) {
                    c1 = c1c2.substring(0, startC2);
                    c2 = c1c2.substring(startC2 + 1);
                    IomObject coord = iomObj.addattrobj(iliAttrName, "COORD");
                    coord.setattrvalue("C1", c1);
                    coord.setattrvalue("C2", c2);
                    return;
                }
                EhiLogger.logError(String.valueOf(recInfo) + ": failed to parse WKT column " + colName);
            }
        }
    }

    public static Boolean getBoolean(ResultSet rs, String colName, boolean isOptional, String recInfo, IomObject iomObj, String iliAttrName) {
        String val = DbUtility.getString(rs, colName, isOptional, recInfo);
        if (val != null && (val = val.trim()).length() == 0) {
            val = null;
        }
        if (val != null) {
            if (val.equals("1")) {
                iomObj.setattrvalue(iliAttrName, "true");
                return new Boolean(true);
            }
            iomObj.setattrvalue(iliAttrName, "false");
            return new Boolean(false);
        }
        return null;
    }

    public static String getEnum(ResultSet rs, String colName, boolean isOptional, String recInfo, EnumMapper enumMapper, IomObject iomObj, String iliAttrName) {
        String val = DbUtility.getString(rs, colName, isOptional, recInfo);
        if (val != null && (val = val.trim()).length() == 0) {
            val = null;
        }
        if (val != null) {
            String iliCode = enumMapper.mapToIliCode(recInfo, val);
            iomObj.setattrvalue(iliAttrName, iliCode);
            return iliCode;
        }
        return null;
    }

    public static String getRef(ResultSet rs, String colName, boolean isOptional, String recInfo, IdMapper idMapper, String idSpace, IomObject iomObj, String iliAttrName, String iliAssocName) {
        String val = DbUtility.getString(rs, colName, isOptional, recInfo);
        if (val != null && ((val = val.trim()).length() == 0 || val.equals("0"))) {
            val = null;
        }
        if (val != null) {
            IomObject ref = iomObj.addattrobj(iliAttrName, iliAssocName);
            val = idMapper.mapId(idSpace, val);
            ref.setobjectrefoid(val);
        }
        return val;
    }
}

