/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000b\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"BUILTIN_FUNCTIONS", "", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassDescriptor$Kind;", "createSynthesizedFunctionWithFirstParameterAsReceiver", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "descriptor", "createSynthesizedInvokes", "", "functions", "isSynthesizedInvoke", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kotlin-compiler"})
public final class SynthesizedInvokesKt {
    private static final Set<FunctionClassDescriptor.Kind> BUILTIN_FUNCTIONS = SetsKt.setOf(new FunctionClassDescriptor.Kind[]{FunctionClassDescriptor.Kind.Function, FunctionClassDescriptor.Kind.SuspendFunction});

    @NotNull
    public static final Collection<FunctionDescriptor> createSynthesizedInvokes(@NotNull Collection<? extends FunctionDescriptor> functions2) {
        Intrinsics.checkParameterIsNotNull(functions2, "functions");
        ArrayList<FunctionDescriptor> result2 = new ArrayList<FunctionDescriptor>(1);
        for (FunctionDescriptor functionDescriptor : functions2) {
            FunctionDescriptor functionDescriptor2;
            if (!(functionDescriptor instanceof FunctionInvokeDescriptor) || functionDescriptor.getValueParameters().isEmpty()) continue;
            Iterable iterable = BUILTIN_FUNCTIONS;
            DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
            if (!(declarationDescriptor instanceof FunctionClassDescriptor)) {
                declarationDescriptor = null;
            }
            FunctionClassDescriptor functionClassDescriptor = (FunctionClassDescriptor)declarationDescriptor;
            if (CollectionsKt.contains(iterable, functionClassDescriptor != null ? functionClassDescriptor.getFunctionKind() : null)) {
                functionDescriptor2 = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver(functionDescriptor);
            } else {
                FunctionDescriptor invokeDeclaration;
                FunctionDescriptor functionDescriptor3 = invokeDeclaration = (FunctionDescriptor)CollectionsKt.single((Iterable)functionDescriptor.getOverriddenDescriptors());
                Intrinsics.checkExpressionValueIsNotNull(functionDescriptor3, "invokeDeclaration");
                FunctionDescriptor synthesizedSuperFun = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver(functionDescriptor3);
                FunctionDescriptor fakeOverride = synthesizedSuperFun.copy(functionDescriptor.getContainingDeclaration(), synthesizedSuperFun.getModality(), synthesizedSuperFun.getVisibility(), CallableMemberDescriptor.Kind.FAKE_OVERRIDE, false);
                DescriptorUtilsKt.setSingleOverridden(fakeOverride, synthesizedSuperFun);
                FunctionDescriptor functionDescriptor4 = fakeOverride;
                functionDescriptor2 = functionDescriptor4;
                Intrinsics.checkExpressionValueIsNotNull(functionDescriptor4, "fakeOverride");
            }
            FunctionDescriptor synthesized = functionDescriptor2;
            ReceiverParameterDescriptor receiverParameterDescriptor = functionDescriptor.getDispatchReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            FunctionDescriptor functionDescriptor5 = synthesized.substitute(TypeSubstitutor.create(receiverParameterDescriptor.getType()));
            if (functionDescriptor5 == null) {
                continue;
            }
            result2.add(functionDescriptor5);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final FunctionDescriptor createSynthesizedFunctionWithFirstParameterAsReceiver(FunctionDescriptor descriptor2) {
        Collection<ValueParameterDescriptor> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        FunctionDescriptor.CopyBuilder<? extends FunctionDescriptor> copyBuilder;
        FunctionDescriptor.CopyBuilder<? extends FunctionDescriptor> $receiver = copyBuilder = descriptor2.getOriginal().newCopyBuilder();
        $receiver.setExtensionReceiverType(CollectionsKt.first(descriptor2.getOriginal().getValueParameters()).getType());
        Iterable iterable = CollectionsKt.drop((Iterable)descriptor2.getOriginal().getValueParameters(), 1);
        FunctionDescriptor.CopyBuilder<? extends FunctionDescriptor> copyBuilder2 = $receiver;
        void var5_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            FunctionDescriptor functionDescriptor = descriptor2.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "descriptor.original");
            CallableDescriptor callableDescriptor = functionDescriptor;
            Name name2 = Name.identifier("p" + (p.getIndex() + 1));
            Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier(\"p${p.index + 1}\")");
            ValueParameterDescriptor valueParameterDescriptor2 = p.copy(callableDescriptor, name2, p.getIndex() - 1);
            collection.add(valueParameterDescriptor2);
        }
        collection = (List)destination$iv$iv;
        copyBuilder2.setValueParameters((List<ValueParameterDescriptor>)collection);
        FunctionDescriptor functionDescriptor = copyBuilder.build();
        if (functionDescriptor == null) {
            Intrinsics.throwNpe();
        }
        return functionDescriptor;
    }

    public static final boolean isSynthesizedInvoke(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (Intrinsics.areEqual(descriptor2.getName(), OperatorNameConventions.INVOKE) ^ true || !(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor real = (FunctionDescriptor)descriptor2;
        while (!real.getKind().isReal()) {
            if ((FunctionDescriptor)CollectionsKt.singleOrNull((Iterable)real.getOverriddenDescriptors()) != null) continue;
            return false;
        }
        return Intrinsics.areEqual((Object)real.getKind(), (Object)CallableMemberDescriptor.Kind.SYNTHESIZED) && real.getContainingDeclaration() instanceof FunctionClassDescriptor;
    }
}

