/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class ExplicitConstructorCall
extends Statement
implements Invocation {
    public Expression[] arguments;
    public Expression qualification;
    public MethodBinding binding;
    MethodBinding syntheticAccessor;
    public int accessMode;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public static final int ImplicitSuper = 1;
    public static final int Super = 2;
    public static final int This = 3;
    public VariableBinding[][] implicitArguments;
    public int typeArgumentsSourceStart;

    public ExplicitConstructorCall(int n) {
        this.accessMode = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            ((MethodScope)blockScope).isConstructorCall = true;
            if (this.qualification != null) {
                flowInfo = this.qualification.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            }
            if (this.arguments != null) {
                boolean bl = blockScope.compilerOptions().analyseResourceLeaks;
                int n = this.arguments.length;
                for (int i = 0; i < n; ++i) {
                    flowInfo = this.arguments[i].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                    if (bl) {
                        flowInfo = FakedTrackingVariable.markPassedToOutside(blockScope, this.arguments[i], flowInfo, flowContext, false);
                    }
                    this.arguments[i].checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
                }
                this.analyseArguments(blockScope, flowContext, flowInfo, this.binding, this.arguments);
            }
            TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
            if (this.binding.thrownExceptions != Binding.NO_EXCEPTIONS) {
                if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                    typeBindingArray = blockScope.environment().convertToRawTypes(this.binding.thrownExceptions, true, true);
                }
                flowContext.checkExceptionHandlers(typeBindingArray, this.accessMode == 1 ? (ASTNode)((Object)blockScope.methodScope().referenceContext) : this, flowInfo, blockScope);
            }
            this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
            this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
            FlowInfo flowInfo2 = flowInfo;
            return flowInfo2;
        }
        finally {
            ((MethodScope)blockScope).isConstructorCall = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        try {
            ((MethodScope)blockScope).isConstructorCall = true;
            int n = codeStream.position;
            codeStream.aload_0();
            MethodBinding methodBinding = this.binding.original();
            ReferenceBinding referenceBinding = methodBinding.declaringClass;
            if (referenceBinding.erasure().id == 41 || referenceBinding.isEnum()) {
                codeStream.aload_1();
                codeStream.iload_2();
            }
            if (referenceBinding.isNestedType()) {
                codeStream.generateSyntheticEnclosingInstanceValues(blockScope, referenceBinding, (this.bits & 0x2000) != 0 ? null : this.qualification, this);
            }
            this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
            if (referenceBinding.isNestedType()) {
                codeStream.generateSyntheticOuterArgumentValues(blockScope, referenceBinding, this);
            }
            if (this.syntheticAccessor != null) {
                int n2 = this.syntheticAccessor.parameters.length - methodBinding.parameters.length;
                for (int i = 0; i < n2; ++i) {
                    codeStream.aconst_null();
                }
                codeStream.invoke((byte)-73, this.syntheticAccessor, null, this.typeArguments);
            } else {
                codeStream.invoke((byte)-73, methodBinding, null, this.typeArguments);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
        }
        finally {
            ((MethodScope)blockScope).isConstructorCall = false;
        }
    }

    @Override
    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isImplicitSuper() {
        return this.accessMode == 1;
    }

    @Override
    public boolean isSuperAccess() {
        return this.accessMode != 3;
    }

    @Override
    public boolean isTypeAccess() {
        return true;
    }

    void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding.declaringClass.erasure();
        if ((flowInfo.tagBits & 1) == 0 && referenceBinding.isNestedType() && blockScope.enclosingSourceType().isLocalType()) {
            if (referenceBinding.isLocalType()) {
                ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, this.qualification != null);
            } else {
                blockScope.propagateInnerEmulation(referenceBinding, this.qualification != null);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            MethodBinding methodBinding = this.binding.original();
            if (this.binding.isPrivate() && this.accessMode != 3) {
                ReferenceBinding referenceBinding = methodBinding.declaringClass;
                if ((referenceBinding.tagBits & 0x10L) != 0L && blockScope.compilerOptions().complianceLevel >= 0x300000L) {
                    methodBinding.tagBits |= 0x200L;
                } else {
                    this.syntheticAccessor = ((SourceTypeBinding)referenceBinding).addSyntheticMethod(methodBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                }
            }
        }
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        int n2;
        ExplicitConstructorCall.printIndent(n, stringBuffer);
        if (this.qualification != null) {
            this.qualification.printExpression(0, stringBuffer).append('.');
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n2 = this.typeArguments.length - 1;
            for (int i = 0; i < n2; ++i) {
                this.typeArguments[i].print(0, stringBuffer);
                stringBuffer.append(", ");
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if (this.accessMode == 3) {
            stringBuffer.append("this(");
        } else {
            stringBuffer.append("super(");
        }
        if (this.arguments != null) {
            for (n2 = 0; n2 < this.arguments.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].printExpression(0, stringBuffer);
            }
        }
        return stringBuffer.append(");");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolve(BlockScope blockScope) {
        MethodScope methodScope = blockScope.methodScope();
        try {
            int n;
            int n2;
            Object object;
            AbstractMethodDeclaration abstractMethodDeclaration = methodScope.referenceMethod();
            if (abstractMethodDeclaration == null || !abstractMethodDeclaration.isConstructor() || ((ConstructorDeclaration)abstractMethodDeclaration).constructorCall != this) {
                int n3;
                int n4;
                blockScope.problemReporter().invalidExplicitConstructorCall(this);
                if (this.qualification != null) {
                    this.qualification.resolveType(blockScope);
                }
                if (this.typeArguments != null) {
                    n4 = this.typeArguments.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.typeArguments[n3].resolveType(blockScope, true);
                    }
                }
                if (this.arguments != null) {
                    n4 = this.arguments.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.arguments[n3].resolveType(blockScope);
                    }
                }
                return;
            }
            methodScope.isConstructorCall = true;
            ReferenceBinding referenceBinding = blockScope.enclosingReceiverType();
            boolean bl = false;
            if (this.accessMode != 3) {
                referenceBinding = referenceBinding.superclass();
                object = blockScope.referenceType().superclass;
                if (object != null && ((TypeReference)object).resolvedType != null && !((TypeReference)object).resolvedType.isValidBinding()) {
                    bl = true;
                }
            }
            if (referenceBinding != null) {
                if (this.accessMode == 2 && referenceBinding.erasure().id == 41) {
                    blockScope.problemReporter().cannotInvokeSuperConstructorInEnum(this, methodScope.referenceMethod().binding);
                }
                if (this.qualification != null) {
                    if (this.accessMode != 2) {
                        blockScope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, referenceBinding);
                    }
                    if (!bl) {
                        object = referenceBinding.enclosingType();
                        if (object == null) {
                            blockScope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, referenceBinding);
                            this.bits |= 0x2000;
                        } else {
                            TypeBinding typeBinding = this.qualification.resolveTypeExpecting(blockScope, (TypeBinding)object);
                            this.qualification.computeConversion(blockScope, typeBinding, typeBinding);
                        }
                    }
                }
            }
            long l = blockScope.compilerOptions().sourceLevel;
            if (this.typeArguments != null) {
                boolean bl2 = l < 0x310000L;
                n2 = this.typeArguments.length;
                this.genericTypeArguments = new TypeBinding[n2];
                for (n = 0; n < n2; n += 1) {
                    TypeReference typeReference = this.typeArguments[n];
                    this.genericTypeArguments[n] = typeReference.resolveType(blockScope, true);
                    if (this.genericTypeArguments[n] == null) {
                        bl2 = true;
                    }
                    if (!bl2 || !(typeReference instanceof Wildcard)) continue;
                    blockScope.problemReporter().illegalUsageOfWildcard(typeReference);
                }
                if (bl2) {
                    if (this.arguments != null) {
                        int n5 = this.arguments.length;
                        for (n = 0; n < n5; n += 1) {
                            this.arguments[n].resolveType(blockScope);
                        }
                    }
                    return;
                }
            }
            TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
            n2 = 0;
            if (this.arguments != null) {
                n = 0;
                int n6 = this.arguments.length;
                typeBindingArray = new TypeBinding[n6];
                for (int i = 0; i < n6; ++i) {
                    Expression expression = this.arguments[i];
                    if (expression instanceof CastExpression) {
                        expression.bits |= 0x20;
                        n2 = 1;
                    }
                    expression.setExpressionContext(ExpressionContext.INVOCATION_CONTEXT);
                    typeBindingArray[i] = expression.resolveType(blockScope);
                    if (typeBindingArray[i] != null) continue;
                    n = 1;
                }
                if (n) {
                    MethodBinding methodBinding;
                    if (referenceBinding == null) {
                        return;
                    }
                    TypeBinding[] typeBindingArray2 = new TypeBinding[n6];
                    int n7 = n6;
                    while (--n7 >= 0) {
                        typeBindingArray2[n7] = typeBindingArray[n7] == null ? TypeBinding.NULL : typeBindingArray[n7];
                    }
                    this.binding = blockScope.findMethod(referenceBinding, TypeConstants.INIT, typeBindingArray2, this, false);
                    if (this.binding != null && !this.binding.isValidBinding() && (methodBinding = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                        if (methodBinding.original().typeVariables != Binding.NO_TYPE_VARIABLES) {
                            methodBinding = blockScope.environment().createParameterizedGenericMethod(methodBinding.original(), (RawTypeBinding)null);
                        }
                        this.binding = methodBinding;
                        MethodBinding methodBinding2 = methodBinding.original();
                        if (methodBinding2.isOrEnclosedByPrivateType() && !blockScope.isDefinedInMethod(methodBinding2)) {
                            methodBinding2.modifiers |= 0x8000000;
                        }
                    }
                    return;
                }
            } else if (referenceBinding.erasure().id == 41) {
                typeBindingArray = new TypeBinding[]{blockScope.getJavaLangString(), TypeBinding.INT};
            }
            if (referenceBinding == null) {
                return;
            }
            this.binding = this.findConstructorBinding(blockScope, this, referenceBinding, typeBindingArray);
            if (this.binding.isValidBinding()) {
                if ((this.binding.tagBits & 0x80L) != 0L && !methodScope.enclosingSourceType().isAnonymousType()) {
                    blockScope.problemReporter().missingTypeInConstructor(this, this.binding);
                }
                if (this.isMethodUseDeprecated(this.binding, blockScope, this.accessMode != 1)) {
                    blockScope.problemReporter().deprecatedMethod(this.binding, this);
                }
                if (ExplicitConstructorCall.checkInvocationArguments(blockScope, null, referenceBinding, this.binding, this.arguments, typeBindingArray, n2 != 0, this)) {
                    this.bits |= 0x10000;
                }
                if (this.binding.isOrEnclosedByPrivateType()) {
                    this.binding.original().modifiers |= 0x8000000;
                }
                if (this.typeArguments != null && this.binding.original().typeVariables == Binding.NO_TYPE_VARIABLES) {
                    blockScope.problemReporter().unnecessaryTypeArgumentsForMethodInvocation(this.binding, this.genericTypeArguments, this.typeArguments);
                }
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = referenceBinding;
                }
                if (bl) {
                    return;
                }
                blockScope.problemReporter().invalidConstructor(this, this.binding);
            }
        }
        finally {
            methodScope.isConstructorCall = false;
        }
    }

    @Override
    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    @Override
    public void setDepth(int n) {
    }

    @Override
    public void setFieldIndex(int n) {
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.qualification != null) {
                this.qualification.traverse(aSTVisitor, blockScope);
            }
            if (this.typeArguments != null) {
                n2 = this.typeArguments.length;
                for (n = 0; n < n2; ++n) {
                    this.typeArguments[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                for (n = 0; n < n2; ++n) {
                    this.arguments[n].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public MethodBinding binding() {
        return this.binding;
    }

    @Override
    public void registerInferenceContext(ParameterizedGenericMethodBinding parameterizedGenericMethodBinding, InferenceContext18 inferenceContext18) {
    }

    @Override
    public void registerResult(TypeBinding typeBinding, MethodBinding methodBinding) {
    }

    @Override
    public InferenceContext18 getInferenceContext(ParameterizedMethodBinding parameterizedMethodBinding) {
        return null;
    }

    @Override
    public void cleanUpInferenceContexts() {
    }

    @Override
    public Expression[] arguments() {
        return this.arguments;
    }

    @Override
    public InferenceContext18 freshInferenceContext(Scope scope) {
        return new InferenceContext18(scope, this.arguments, this, null);
    }
}

