/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassLoaderTable;
import org.netbeans.lib.profiler.classfile.ClassRepository;

public class SameNameClassGroup {
    private List classes = new ArrayList(4);

    public List getAll() {
        return this.classes;
    }

    public void add(BaseClassInfo baseClassInfo) {
        this.classes.add(baseClassInfo);
    }

    public static BaseClassInfo checkForCompatibility(BaseClassInfo baseClassInfo, int n) {
        int n2 = baseClassInfo.getLoaderId();
        if (n2 == n) {
            return baseClassInfo;
        }
        if (SameNameClassGroup.isParentLoaderTo(n2, n)) {
            return baseClassInfo;
        }
        if (SameNameClassGroup.isParentLoaderTo(n, n2)) {
            baseClassInfo.setLoaderId(n);
            return baseClassInfo;
        }
        if (n > 0) {
            int n3 = ClassRepository.getDefiningClassLoaderId(baseClassInfo.getName(), n);
            if (n3 == -1) {
                return null;
            }
            if (n3 == n2) {
                return baseClassInfo;
            }
        }
        return null;
    }

    public BaseClassInfo findCompatibleClass(int n) {
        BaseClassInfo baseClassInfo;
        int n2;
        int n3 = this.classes.size();
        for (n2 = 0; n2 < n3; ++n2) {
            baseClassInfo = (BaseClassInfo)this.classes.get(n2);
            if (baseClassInfo.getLoaderId() != n) continue;
            return baseClassInfo;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            baseClassInfo = (BaseClassInfo)this.classes.get(n2);
            if ((baseClassInfo = SameNameClassGroup.checkForCompatibility(baseClassInfo, n)) == null) continue;
            return baseClassInfo;
        }
        return null;
    }

    public void replace(BaseClassInfo baseClassInfo, BaseClassInfo baseClassInfo2) {
        this.classes.remove(baseClassInfo);
        this.classes.add(baseClassInfo2);
    }

    private static boolean isParentLoaderTo(int n, int n2) {
        int n3 = ClassLoaderTable.getParentLoader(n2);
        while (n3 != n) {
            if (n3 == 0) {
                return false;
            }
            n3 = ClassLoaderTable.getParentLoader(n3);
        }
        return true;
    }
}

