/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.EmbeddedSignature;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.RevocationKey;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;

public class PGPSignatureSubpacketGenerator {
    List list = new ArrayList();

    public void setRevocable(boolean bl, boolean bl2) {
        this.list.add(new Revocable(bl, bl2));
    }

    public void setExportable(boolean bl, boolean bl2) {
        this.list.add(new Exportable(bl, bl2));
    }

    public void setFeature(boolean bl, byte by) {
        this.list.add(new Features(bl, by));
    }

    public void setTrust(boolean bl, int n, int n2) {
        this.list.add(new TrustSignature(bl, n, n2));
    }

    public void setKeyExpirationTime(boolean bl, long l) {
        this.list.add(new KeyExpirationTime(bl, l));
    }

    public void setSignatureExpirationTime(boolean bl, long l) {
        this.list.add(new SignatureExpirationTime(bl, l));
    }

    public void setSignatureCreationTime(boolean bl, Date date) {
        this.list.add(new SignatureCreationTime(bl, date));
    }

    public void setPreferredHashAlgorithms(boolean bl, int[] nArray) {
        this.list.add(new PreferredAlgorithms(21, bl, nArray));
    }

    public void setPreferredSymmetricAlgorithms(boolean bl, int[] nArray) {
        this.list.add(new PreferredAlgorithms(11, bl, nArray));
    }

    public void setPreferredCompressionAlgorithms(boolean bl, int[] nArray) {
        this.list.add(new PreferredAlgorithms(22, bl, nArray));
    }

    public void setKeyFlags(boolean bl, int n) {
        this.list.add(new KeyFlags(bl, n));
    }

    public void setSignerUserID(boolean bl, String string) {
        if (string == null) {
            throw new IllegalArgumentException("attempt to set null SignerUserID");
        }
        this.list.add(new SignerUserID(bl, string));
    }

    public void setSignerUserID(boolean bl, byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("attempt to set null SignerUserID");
        }
        this.list.add(new SignerUserID(bl, false, byArray));
    }

    public void setEmbeddedSignature(boolean bl, PGPSignature pGPSignature) throws IOException {
        byte[] byArray = pGPSignature.getEncoded();
        byte[] byArray2 = byArray.length - 1 > 256 ? new byte[byArray.length - 3] : new byte[byArray.length - 2];
        System.arraycopy(byArray, byArray.length - byArray2.length, byArray2, 0, byArray2.length);
        this.list.add(new EmbeddedSignature(bl, false, byArray2));
    }

    public void setPrimaryUserID(boolean bl, boolean bl2) {
        this.list.add(new PrimaryUserID(bl, bl2));
    }

    public void setNotationData(boolean bl, boolean bl2, String string, String string2) {
        this.list.add(new NotationData(bl, bl2, string, string2));
    }

    public void setRevocationReason(boolean bl, byte by, String string) {
        this.list.add(new RevocationReason(bl, by, string));
    }

    public void setRevocationKey(boolean bl, int n, byte[] byArray) {
        this.list.add(new RevocationKey(bl, -128, n, byArray));
    }

    public void setIssuerKeyID(boolean bl, long l) {
        this.list.add(new IssuerKeyID(bl, l));
    }

    public PGPSignatureSubpacketVector generate() {
        return new PGPSignatureSubpacketVector(this.list.toArray(new SignatureSubpacket[this.list.size()]));
    }
}

