// Generated by gmmproc 2.50.0 -- DO NOT MODIFY!
#ifndef _GTKMM_ACCELLABEL_H
#define _GTKMM_ACCELLABEL_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/label.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkAccelLabel = struct _GtkAccelLabel;
using GtkAccelLabelClass = struct _GtkAccelLabelClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class AccelLabel_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** A label which displays an accelerator key on the right of the text.
 * Used for menu item labels, for instance.
 *
 * @ingroup Widgets
 */

class AccelLabel : public Label
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef AccelLabel CppObjectType;
  typedef AccelLabel_Class CppClassType;
  typedef GtkAccelLabel BaseObjectType;
  typedef GtkAccelLabelClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  AccelLabel(AccelLabel&& src) noexcept;
  AccelLabel& operator=(AccelLabel&& src) noexcept;

  // noncopyable
  AccelLabel(const AccelLabel&) = delete;
  AccelLabel& operator=(const AccelLabel&) = delete;

  ~AccelLabel() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class AccelLabel_Class;
  static CppClassType accellabel_class_;

protected:
  explicit AccelLabel(const Glib::ConstructParams& construct_params);
  explicit AccelLabel(GtkAccelLabel* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkAccelLabel*       gobj()       { return reinterpret_cast<GtkAccelLabel*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkAccelLabel* gobj() const { return reinterpret_cast<GtkAccelLabel*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

  
public:

  //The default ctor doesn't correspond to any _new function, but gtkmenuitem.cc does a simple g_object_new() with no properties.
  /** Default constructor to create an AccelLabel object
   */
  AccelLabel();

  /** Constructor to create an AccelLabel object with a default label
   * @param label The label string.
   * @param mnemonic If true, characters preceded by an underscore (_) will be underlined and used as a keyboard accelerator.
   */
  explicit AccelLabel(const Glib::ustring& label, bool mnemonic = false);

  
  /** Sets the widget to be monitored by this accelerator label.
   * 
   * @param accel_widget The widget to be monitored.
   */
  void set_accel_widget(const Widget& accel_widget);
  /// Forget the accel widget previously set by set_accel_widget().
  void unset_accel_widget();

  
  /** Fetches the widget monitored by this accelerator label. See
   * set_accel_widget().
   * 
   * @return The object monitored by the accelerator label, or <tt>nullptr</tt>.
   */
  Widget* get_accel_widget();
  
  /** Fetches the widget monitored by this accelerator label. See
   * set_accel_widget().
   * 
   * @return The object monitored by the accelerator label, or <tt>nullptr</tt>.
   */
  const Widget* get_accel_widget() const;

  
  /** Gets the width needed to display this accelerator label. This is used by menus to align all of the Gtk::MenuItem widgets, and shouldn't be needed by applications.
   * 
   * @return Width of this accelerator label.
   */
  guint get_accel_width() const;
  
  /** Recreates the string representing the accelerator keys.
   * 
   * @return Always returns <tt>false</tt>.
   */
  bool refetch();

  
  /** Manually sets a keyval and modifier mask as the accelerator rendered
   * by @a accel_label.
   * 
   * If a keyval and modifier are explicitly set then these values are
   * used regardless of any associated accel closure or widget.
   * 
   * Providing an @a accelerator_key of 0 removes the manual setting.
   * 
   * @newin{3,6}
   * 
   * @param accelerator_key A keyval, or 0.
   * @param accelerator_mods The modifier mask for the accel.
   */
  void set_accel(guint accelerator_key, Gdk::ModifierType accelerator_mods);
 

  /** Gets the keyval and modifier mask set with
   * set_accel().
   * 
   * @newin{3,12}
   * 
   * @param accelerator_key Return location for the keyval.
   * @param accelerator_mods Return location for the modifier mask.
   */
  void get_accel(guint& accelerator_key, Gdk::ModifierType& accelerator_mods);

  //_WRAP_PROPERTY("accel-closure", Glib::Object) //GClosure
  /** The widget to be monitored for accelerator changes.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gtk::Widget* > property_accel_widget() ;

/** The widget to be monitored for accelerator changes.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gtk::Widget* > property_accel_widget() const;


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::AccelLabel
   */
  Gtk::AccelLabel* wrap(GtkAccelLabel* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_ACCELLABEL_H */

