/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.CmapFormat;
import org.apache.batik.svggen.font.table.CmapIndexEntry;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.Table;

public class CmapTable
implements Table {
    private int version;
    private int numTables;
    private CmapIndexEntry[] entries;
    private CmapFormat[] formats;

    protected CmapTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) throws IOException {
        int n;
        randomAccessFile.seek(directoryEntry.getOffset());
        long l = randomAccessFile.getFilePointer();
        this.version = randomAccessFile.readUnsignedShort();
        this.numTables = randomAccessFile.readUnsignedShort();
        this.entries = new CmapIndexEntry[this.numTables];
        this.formats = new CmapFormat[this.numTables];
        for (n = 0; n < this.numTables; ++n) {
            this.entries[n] = new CmapIndexEntry(randomAccessFile);
        }
        for (n = 0; n < this.numTables; ++n) {
            randomAccessFile.seek(l + (long)this.entries[n].getOffset());
            int n2 = randomAccessFile.readUnsignedShort();
            this.formats[n] = CmapFormat.create(n2, randomAccessFile);
        }
    }

    public CmapFormat getCmapFormat(short s, short s2) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.entries[i].getPlatformId() != s || this.entries[i].getEncodingId() != s2) continue;
            return this.formats[i];
        }
        return null;
    }

    @Override
    public int getType() {
        return 1668112752;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.numTables * 8).append("cmap\n");
        for (n = 0; n < this.numTables; ++n) {
            stringBuffer.append('\t').append(this.entries[n].toString()).append('\n');
        }
        for (n = 0; n < this.numTables; ++n) {
            stringBuffer.append('\t').append(this.formats[n].toString()).append('\n');
        }
        return stringBuffer.toString();
    }
}

