/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadReferrersTask;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadReferrersAction
extends JosmAction {
    public DownloadReferrersAction() {
        super(I18n.tr("Download parent ways/relations...", new Object[0]), "download", I18n.tr("Download objects referring to one of the selected objects", new Object[0]), Shortcut.registerShortcut("file:downloadreferrers", I18n.tr("File: {0}", I18n.tr("Download parent ways/relations...", new Object[0])), 68, 5008), true, "downloadreferrers", true);
        this.putValue("help", HelpUtil.ht("/Action/DownloadParentWaysAndRelation"));
    }

    public static void downloadReferrers(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Main.worker.submit(new DownloadReferrersTask(osmDataLayer, collection));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        OsmDataLayer osmDataLayer = Main.getLayerManager().getEditLayer();
        if (osmDataLayer == null) {
            return;
        }
        Collection<OsmPrimitive> collection = osmDataLayer.data.getSelected();
        DownloadReferrersAction.downloadReferrers(osmDataLayer, collection);
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

