/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.tools.I18n;

public class OffsetBookmark {
    private static final List<OffsetBookmark> allBookmarks = new ArrayList<OffsetBookmark>();
    public String projectionCode;
    public String layerName;
    public String name;
    public double dx;
    public double dy;
    public double centerX;
    public double centerY;

    public boolean isUsable(ImageryLayer imageryLayer) {
        if (this.projectionCode == null) {
            return false;
        }
        if (!Main.getProjection().toCode().equals(this.projectionCode)) {
            return false;
        }
        return imageryLayer.getInfo().getName().equals(this.layerName);
    }

    public OffsetBookmark(String string, String string2, String string3, double d, double d2) {
        this(string, string2, string3, d, d2, 0.0, 0.0);
    }

    public OffsetBookmark(String string, String string2, String string3, double d, double d2, double d3, double d4) {
        this.projectionCode = string;
        this.layerName = string2;
        this.name = string3;
        this.dx = d;
        this.dy = d2;
        this.centerX = d3;
        this.centerY = d4;
    }

    public OffsetBookmark(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        this.projectionCode = (String)arrayList.get(0);
        this.layerName = (String)arrayList.get(1);
        this.name = (String)arrayList.get(2);
        this.dx = Double.parseDouble((String)arrayList.get(3));
        this.dy = Double.parseDouble((String)arrayList.get(4));
        if (arrayList.size() >= 7) {
            this.centerX = Double.parseDouble((String)arrayList.get(5));
            this.centerY = Double.parseDouble((String)arrayList.get(6));
        }
        if (this.projectionCode == null) {
            Main.error(I18n.tr("Projection ''{0}'' is not found, bookmark ''{1}'' is not usable", this.projectionCode, this.name));
        }
    }

    public List<String> getInfoArray() {
        ArrayList<String> arrayList = new ArrayList<String>(7);
        if (this.projectionCode != null) {
            arrayList.add(this.projectionCode);
        } else {
            arrayList.add("");
        }
        arrayList.add(this.layerName);
        arrayList.add(this.name);
        arrayList.add(String.valueOf(this.dx));
        arrayList.add(String.valueOf(this.dy));
        if (this.centerX != 0.0 || this.centerY != 0.0) {
            arrayList.add(String.valueOf(this.centerX));
            arrayList.add(String.valueOf(this.centerY));
        }
        return arrayList;
    }

    public static void loadBookmarks() {
        for (Collection<String> collection : Main.pref.getArray("imagery.offsets", Collections.emptySet())) {
            allBookmarks.add(new OffsetBookmark(collection));
        }
    }

    public static void saveBookmarks() {
        LinkedList<Collection<String>> linkedList = new LinkedList<Collection<String>>();
        for (OffsetBookmark offsetBookmark : allBookmarks) {
            linkedList.add(offsetBookmark.getInfoArray());
        }
        Main.pref.putArray("imagery.offsets", linkedList);
    }

    public static List<OffsetBookmark> getBookmarks() {
        return Collections.unmodifiableList(allBookmarks);
    }

    public static int getBookmarksSize() {
        return allBookmarks.size();
    }

    public static boolean addBookmark(OffsetBookmark offsetBookmark) {
        return allBookmarks.add(offsetBookmark);
    }

    public static boolean removeBookmark(OffsetBookmark offsetBookmark) {
        return allBookmarks.remove(offsetBookmark);
    }

    public static OffsetBookmark getBookmarkByIndex(int n) {
        return allBookmarks.get(n);
    }

    public static OffsetBookmark getBookmarkByName(ImageryLayer imageryLayer, String string) {
        for (OffsetBookmark offsetBookmark : allBookmarks) {
            if (!offsetBookmark.isUsable(imageryLayer) || !string.equals(offsetBookmark.name)) continue;
            return offsetBookmark;
        }
        return null;
    }

    public static void bookmarkOffset(String string, AbstractTileSourceLayer abstractTileSourceLayer) {
        LatLon latLon = Main.isDisplayingMapView() ? Main.getProjection().eastNorth2latlon(Main.map.mapView.getCenter()) : LatLon.ZERO;
        OffsetBookmark offsetBookmark = new OffsetBookmark(Main.getProjection().toCode(), abstractTileSourceLayer.getInfo().getName(), string, abstractTileSourceLayer.getDisplaySettings().getDx(), abstractTileSourceLayer.getDisplaySettings().getDy(), latLon.lon(), latLon.lat());
        ListIterator<OffsetBookmark> listIterator = allBookmarks.listIterator();
        while (listIterator.hasNext()) {
            OffsetBookmark offsetBookmark2 = listIterator.next();
            if (!offsetBookmark2.isUsable(abstractTileSourceLayer) || !string.equals(offsetBookmark2.name)) continue;
            listIterator.set(offsetBookmark);
            OffsetBookmark.saveBookmarks();
            return;
        }
        allBookmarks.add(offsetBookmark);
        OffsetBookmark.saveBookmarks();
    }
}

