/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSRule
implements Comparable<MapCSSRule> {
    public final Selector selector;
    public final Declaration declaration;

    public MapCSSRule(Selector selector, Declaration declaration) {
        this.selector = selector;
        this.declaration = declaration;
    }

    public void execute(Environment environment) {
        this.declaration.execute(environment);
    }

    @Override
    public int compareTo(MapCSSRule mapCSSRule) {
        return this.declaration.idx - mapCSSRule.declaration.idx;
    }

    public String toString() {
        return this.selector + " {\n  " + Utils.join("\n  ", this.declaration.instructions) + "\n}";
    }

    public static class Declaration {
        public final List<Instruction> instructions;
        public final int idx;

        public Declaration(List<Instruction> list, int n) {
            this.instructions = list;
            this.idx = n;
        }

        public void execute(Environment environment) {
            for (Instruction instruction : this.instructions) {
                instruction.execute(environment);
            }
        }

        public int hashCode() {
            return Objects.hash(this.instructions, this.idx);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Declaration declaration = (Declaration)object;
            return this.idx == declaration.idx && Objects.equals(this.instructions, declaration.instructions);
        }

        public String toString() {
            return "Declaration [instructions=" + this.instructions + ", idx=" + this.idx + ']';
        }
    }
}

