/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.draw.SymbolShape;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.gui.mappaint.styleelement.BoxTextElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.MapImage;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.Symbol;
import org.openstreetmap.josm.gui.util.RotationAngle;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class NodeElement
extends StyleElement {
    public final MapImage mapImage;
    public final RotationAngle mapImageAngle;
    public final Symbol symbol;
    private static final String[] ICON_KEYS = new String[]{"icon-image", "icon-width", "icon-height", "icon-opacity", "icon-offset-x", "icon-offset-y"};
    public static final NodeElement SIMPLE_NODE_ELEMSTYLE;
    public static final BoxTextElement.BoxProvider SIMPLE_NODE_ELEMSTYLE_BOXPROVIDER;
    public static final StyleElementList DEFAULT_NODE_STYLELIST;
    public static final StyleElementList DEFAULT_NODE_STYLELIST_TEXT;

    protected NodeElement(Cascade cascade, MapImage mapImage, Symbol symbol, float f, RotationAngle rotationAngle) {
        super(cascade, f);
        this.mapImage = mapImage;
        this.symbol = symbol;
        this.mapImageAngle = Objects.requireNonNull(rotationAngle, "rotationAngle");
    }

    public static NodeElement create(Environment environment) {
        return NodeElement.create(environment, 4.0f, false);
    }

    private static NodeElement create(Environment environment, float f, boolean bl) {
        Cascade cascade = environment.mc.getCascade(environment.layer);
        MapImage mapImage = NodeElement.createIcon(environment);
        Symbol symbol = null;
        if (mapImage == null) {
            symbol = NodeElement.createSymbol(environment);
        }
        RotationAngle rotationAngle = NodeElement.createRotationAngle(environment);
        if (!bl && symbol == null && mapImage == null) {
            return null;
        }
        return new NodeElement(cascade, mapImage, symbol, f, rotationAngle);
    }

    public static RotationAngle createRotationAngle(Environment environment) {
        Cascade cascade = environment.mc.getCascade(environment.layer);
        RotationAngle rotationAngle = RotationAngle.NO_ROTATION;
        Float f = cascade.get("icon-rotation", null, Float.class, true);
        if (f != null) {
            rotationAngle = RotationAngle.buildStaticRotation(f.floatValue());
        } else {
            Keyword keyword = cascade.get("icon-rotation", null, Keyword.class);
            if (keyword != null) {
                if ("way".equals(keyword.val)) {
                    rotationAngle = RotationAngle.buildWayDirectionRotation();
                } else {
                    try {
                        rotationAngle = RotationAngle.buildStaticRotation(keyword.val);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Main.trace(illegalArgumentException);
                    }
                }
            }
        }
        return rotationAngle;
    }

    public static MapImage createIcon(Environment environment) {
        return NodeElement.createIcon(environment, ICON_KEYS);
    }

    public static MapImage createIcon(Environment environment, String ... stringArray) {
        CheckParameterUtil.ensureParameterNotNull(environment, "env");
        CheckParameterUtil.ensureParameterNotNull(stringArray, "keys");
        Cascade cascade = environment.mc.getCascade(environment.layer);
        MapPaintStyles.IconReference iconReference = cascade.get(stringArray[0], null, MapPaintStyles.IconReference.class, true);
        if (iconReference == null) {
            return null;
        }
        Cascade cascade2 = environment.mc.getCascade("default");
        Float f = cascade2.get(stringArray[1], null, Float.class);
        if (f != null && f.floatValue() <= 0.0f) {
            f = null;
        }
        Float f2 = NodeElement.getWidth(cascade, stringArray[1], f);
        Float f3 = cascade2.get(stringArray[2], null, Float.class);
        if (f3 != null && f3.floatValue() <= 0.0f) {
            f3 = null;
        }
        Float f4 = NodeElement.getWidth(cascade, stringArray[2], f3);
        int n = f2 == null ? -1 : Math.round(f2.floatValue());
        int n2 = f4 == null ? -1 : Math.round(f4.floatValue());
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (stringArray[4] != null) {
            f5 = cascade.get(stringArray[4], Float.valueOf(0.0f), Float.class).floatValue();
            f6 = cascade.get(stringArray[5], Float.valueOf(0.0f), Float.class).floatValue();
        }
        MapImage mapImage = new MapImage(iconReference.iconName, iconReference.source);
        mapImage.width = n;
        mapImage.height = n2;
        mapImage.offsetX = Math.round(f5);
        mapImage.offsetY = Math.round(f6);
        mapImage.alpha = Utils.clamp(Main.pref.getInteger("mappaint.icon-image-alpha", 255), 0, 255);
        Integer n3 = Utils.colorFloat2int(cascade.get(stringArray[3], null, Float.TYPE));
        if (n3 != null) {
            mapImage.alpha = n3;
        }
        return mapImage;
    }

    private static Symbol createSymbol(Environment environment) {
        Integer n;
        Serializable serializable;
        Float f;
        Cascade cascade = environment.mc.getCascade(environment.layer);
        Keyword keyword = cascade.get("symbol-shape", null, Keyword.class);
        if (keyword == null) {
            return null;
        }
        Optional<SymbolShape> optional = SymbolShape.forName(keyword.val);
        if (!optional.isPresent()) {
            return null;
        }
        Cascade cascade2 = environment.mc.getCascade("default");
        Float f2 = cascade2.get("symbol-size", null, Float.class);
        if (f2 != null && f2.floatValue() <= 0.0f) {
            f2 = null;
        }
        if ((f = Optional.ofNullable(NodeElement.getWidth(cascade, "symbol-size", f2)).orElse(Float.valueOf(10.0f))).floatValue() <= 0.0f) {
            return null;
        }
        Float f3 = NodeElement.getWidth(cascade2, "symbol-stroke-width", null);
        Float f4 = NodeElement.getWidth(cascade, "symbol-stroke-width", f3);
        Color color = cascade.get("symbol-stroke-color", null, Color.class);
        if (f4 == null && color != null) {
            f4 = Float.valueOf(1.0f);
        } else if (f4 != null && color == null) {
            color = Color.ORANGE;
        }
        BasicStroke basicStroke = null;
        if (color != null && f4 != null) {
            serializable = Utils.colorFloat2int(cascade.get("symbol-stroke-opacity", null, Float.class));
            if (serializable != null) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (Integer)serializable);
            }
            basicStroke = new BasicStroke(f4.floatValue());
        }
        serializable = cascade.get("symbol-fill-color", null, Color.class);
        if (basicStroke == null && serializable == null) {
            serializable = Color.BLUE;
        }
        if (serializable != null && (n = Utils.colorFloat2int(cascade.get("symbol-fill-opacity", null, Float.class))) != null) {
            serializable = new Color(((Color)serializable).getRed(), ((Color)serializable).getGreen(), ((Color)serializable).getBlue(), n);
        }
        return new Symbol(optional.get(), Math.round(f.floatValue()), basicStroke, color, (Color)serializable);
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer, boolean bl, boolean bl2, boolean bl3) {
        if (osmPrimitive instanceof Node) {
            Node node = (Node)osmPrimitive;
            if (this.mapImage != null && styledMapRenderer.isShowIcons()) {
                styledMapRenderer.drawNodeIcon(node, this.mapImage, styledMapRenderer.isInactiveMode() || node.isDisabled(), bl, bl3, this.mapImageAngle == null ? 0.0 : this.mapImageAngle.getRotationAngle(osmPrimitive));
            } else if (this.symbol != null) {
                this.paintWithSymbol(mapPaintSettings, styledMapRenderer, bl, bl3, node);
            } else {
                boolean bl4 = node.isConnectionNode();
                Color color = styledMapRenderer.isInactiveMode() || node.isDisabled() ? mapPaintSettings.getInactiveColor() : (bl ? mapPaintSettings.getSelectedColor() : (bl3 ? mapPaintSettings.getRelationSelectedColor() : (bl4 ? (node.isTagged() ? mapPaintSettings.getTaggedConnectionColor() : mapPaintSettings.getConnectionColor()) : (node.isTagged() ? mapPaintSettings.getTaggedColor() : mapPaintSettings.getNodeColor()))));
                int n = NodeElement.max(bl ? mapPaintSettings.getSelectedNodeSize() : 0, node.isTagged() ? mapPaintSettings.getTaggedNodeSize() : 0, bl4 ? mapPaintSettings.getConnectionNodeSize() : 0, mapPaintSettings.getUnselectedNodeSize());
                boolean bl5 = bl && mapPaintSettings.isFillSelectedNode() || node.isTagged() && mapPaintSettings.isFillTaggedNode() || bl4 && mapPaintSettings.isFillConnectionNode() || mapPaintSettings.isFillUnselectedNode();
                styledMapRenderer.drawNode(node, color, n, bl5);
            }
        } else if (osmPrimitive instanceof Relation && this.mapImage != null) {
            styledMapRenderer.drawRestriction((Relation)osmPrimitive, this.mapImage, styledMapRenderer.isInactiveMode() || osmPrimitive.isDisabled());
        }
    }

    private void paintWithSymbol(MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer, boolean bl, boolean bl2, Node node) {
        Color color;
        Color color2 = this.symbol.fillColor;
        if (color2 != null) {
            if (styledMapRenderer.isInactiveMode() || node.isDisabled()) {
                color2 = mapPaintSettings.getInactiveColor();
            } else if (this.defaultSelectedHandling && bl) {
                color2 = mapPaintSettings.getSelectedColor(color2.getAlpha());
            } else if (bl2) {
                color2 = mapPaintSettings.getRelationSelectedColor(color2.getAlpha());
            }
        }
        if ((color = this.symbol.strokeColor) != null) {
            if (styledMapRenderer.isInactiveMode() || node.isDisabled()) {
                color = mapPaintSettings.getInactiveColor();
            } else if (this.defaultSelectedHandling && bl) {
                color = mapPaintSettings.getSelectedColor(color.getAlpha());
            } else if (bl2) {
                color = mapPaintSettings.getRelationSelectedColor(color.getAlpha());
            }
        }
        styledMapRenderer.drawNodeSymbol(node, this.symbol, color2, color);
    }

    public BoxTextElement.BoxProvider getBoxProvider() {
        if (this.mapImage != null) {
            return this.mapImage.getBoxProvider();
        }
        if (this.symbol != null) {
            return new BoxTextElement.SimpleBoxProvider(new Rectangle(-this.symbol.size / 2, -this.symbol.size / 2, this.symbol.size, this.symbol.size));
        }
        int n = NodeElement.max(Main.pref.getInteger("mappaint.node.selected-size", 5), Main.pref.getInteger("mappaint.node.unselected-size", 3), Main.pref.getInteger("mappaint.node.connection-size", 5), Main.pref.getInteger("mappaint.node.tagged-size", 3));
        return new BoxTextElement.SimpleBoxProvider(new Rectangle(-n / 2, -n / 2, n, n));
    }

    private static int max(int ... nArray) {
        return IntStream.of(nArray).max().orElseThrow(IllegalStateException::new);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mapImage, this.mapImageAngle, this.symbol);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        NodeElement nodeElement = (NodeElement)object;
        return Objects.equals(this.mapImage, nodeElement.mapImage) && Objects.equals(this.mapImageAngle, nodeElement.mapImageAngle) && Objects.equals(this.symbol, nodeElement.symbol);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64).append("NodeElement{").append(super.toString());
        if (this.mapImage != null) {
            stringBuilder.append(" icon=[" + this.mapImage + ']');
        }
        if (this.mapImage != null && this.mapImageAngle != null) {
            stringBuilder.append(" mapImageAngle=[" + this.mapImageAngle + ']');
        }
        if (this.symbol != null) {
            stringBuilder.append(" symbol=[" + this.symbol + ']');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    static {
        MultiCascade multiCascade = new MultiCascade();
        multiCascade.getOrCreateCascade("default");
        SIMPLE_NODE_ELEMSTYLE = NodeElement.create(new Environment(null, multiCascade, "default", null), 4.1f, true);
        if (SIMPLE_NODE_ELEMSTYLE == null) {
            throw new AssertionError();
        }
        SIMPLE_NODE_ELEMSTYLE_BOXPROVIDER = SIMPLE_NODE_ELEMSTYLE.getBoxProvider();
        DEFAULT_NODE_STYLELIST = new StyleElementList(SIMPLE_NODE_ELEMSTYLE);
        DEFAULT_NODE_STYLELIST_TEXT = new StyleElementList(SIMPLE_NODE_ELEMSTYLE, BoxTextElement.SIMPLE_NODE_TEXT_ELEMSTYLE);
    }
}

