/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.oauth.AbstractAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.AccessTokenInfoPanel;
import org.openstreetmap.josm.gui.oauth.OsmLoginFailedException;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationClient;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationException;
import org.openstreetmap.josm.gui.oauth.OsmPrivilegesPanel;
import org.openstreetmap.josm.gui.oauth.TestAccessTokenTask;
import org.openstreetmap.josm.gui.preferences.server.UserNameValidator;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.DefaultTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmPasswordField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

public class FullyAutomaticAuthorizationUI
extends AbstractAuthorizationUI {
    private final JosmTextField tfUserName = new JosmTextField();
    private final JosmPasswordField tfPassword = new JosmPasswordField();
    private transient UserNameValidator valUserName;
    private transient PasswordValidator valPassword;
    private final AccessTokenInfoPanel pnlAccessTokenInfo = new AccessTokenInfoPanel();
    private OsmPrivilegesPanel pnlOsmPrivileges;
    private JPanel pnlPropertiesPanel;
    private JPanel pnlActionButtonsPanel;
    private JPanel pnlResult;
    private final transient Executor executor;

    protected VerticallyScrollablePanel buildGrantsPanel() {
        this.pnlOsmPrivileges = new OsmPrivilegesPanel();
        return this.pnlOsmPrivileges;
    }

    protected VerticallyScrollablePanel buildUserNamePasswordPanel() {
        VerticallyScrollablePanel verticallyScrollablePanel = new VerticallyScrollablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        verticallyScrollablePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        HtmlPanel htmlPanel = new HtmlPanel();
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)htmlPanel.getEditorPane().getEditorKit();
        hTMLEditorKit.getStyleSheet().addRule(".warning-body {background-color:#DDFFDD; padding: 10pt; border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
        hTMLEditorKit.getStyleSheet().addRule("ol {margin-left: 1cm}");
        htmlPanel.setText("<html><body><p class=\"warning-body\">" + I18n.tr("Please enter your OSM user name and password. The password will <strong>not</strong> be saved in clear text in the JOSM preferences and it will be submitted to the OSM server <strong>only once</strong>. Subsequent data upload requests don''t use your password any more.", new Object[0]) + "</p></body></html>");
        verticallyScrollablePanel.add((Component)htmlPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        verticallyScrollablePanel.add((Component)new JLabel(I18n.tr("Username: ", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)this.tfUserName, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfUserName);
        this.valUserName = new UserNameValidator(this.tfUserName);
        this.valUserName.validate();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        verticallyScrollablePanel.add((Component)new JLabel(I18n.tr("Password: ", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)this.tfPassword, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfPassword);
        this.valPassword = new PasswordValidator(this.tfPassword);
        this.valPassword.validate();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        verticallyScrollablePanel.add((Component)new JPanel(), gridBagConstraints);
        return verticallyScrollablePanel;
    }

    protected JPanel buildPropertiesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(this.buildUserNamePasswordPanel().getVerticalScrollPane());
        jTabbedPane.add(this.buildGrantsPanel().getVerticalScrollPane());
        jTabbedPane.add(this.getAdvancedPropertiesPanel().getVerticalScrollPane());
        jTabbedPane.setTitleAt(0, I18n.tr("Basic", new Object[0]));
        jTabbedPane.setTitleAt(1, I18n.tr("Granted rights", new Object[0]));
        jTabbedPane.setTitleAt(2, I18n.tr("Advanced OAuth properties", new Object[0]));
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    @Override
    public void initFromPreferences(Preferences preferences) {
        super.initFromPreferences(preferences);
        CredentialsManager credentialsManager = CredentialsManager.getInstance();
        try {
            PasswordAuthentication passwordAuthentication = credentialsManager.lookup(Authenticator.RequestorType.SERVER, OsmApi.getOsmApi().getHost());
            if (passwordAuthentication == null) {
                this.tfUserName.setText("");
                this.tfPassword.setText("");
            } else {
                this.tfUserName.setText(passwordAuthentication.getUserName() == null ? "" : passwordAuthentication.getUserName());
                this.tfPassword.setText(passwordAuthentication.getPassword() == null ? "" : String.valueOf(passwordAuthentication.getPassword()));
            }
        }
        catch (CredentialsAgentException credentialsAgentException) {
            Main.error(credentialsAgentException);
            this.tfUserName.setText("");
            this.tfPassword.setText("");
        }
    }

    protected JPanel buildActionButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        RunAuthorisationAction runAuthorisationAction = new RunAuthorisationAction();
        this.tfPassword.getDocument().addDocumentListener(runAuthorisationAction);
        this.tfUserName.getDocument().addDocumentListener(runAuthorisationAction);
        jPanel.add(new JButton(runAuthorisationAction));
        return jPanel;
    }

    protected JPanel buildResultsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JMultilineLabel jMultilineLabel = new JMultilineLabel("");
        jMultilineLabel.setFont(jMultilineLabel.getFont().deriveFont(0));
        String string = I18n.tr("Accept Access Token", new Object[0]);
        jMultilineLabel.setText(I18n.tr("<html>You have successfully retrieved an OAuth Access Token from the OSM website. Click on <strong>{0}</strong> to accept the token. JOSM will use it in subsequent requests to gain access to the OSM API.</html>", string));
        jPanel.add((Component)jMultilineLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)this.pnlAccessTokenInfo, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JButton(new BackAction()));
        jPanel2.add(new JButton(new TestAccessTokenAction()));
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return jPanel;
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.pnlPropertiesPanel = this.buildPropertiesPanel();
        this.pnlActionButtonsPanel = this.buildActionButtonPanel();
        this.pnlResult = this.buildResultsPanel();
        this.prepareUIForEnteringRequest();
    }

    protected void prepareUIForEnteringRequest() {
        this.removeAll();
        this.add((Component)this.pnlPropertiesPanel, "Center");
        this.add((Component)this.pnlActionButtonsPanel, "South");
        this.pnlPropertiesPanel.revalidate();
        this.pnlActionButtonsPanel.revalidate();
        this.validate();
        this.repaint();
        this.setAccessToken(null);
    }

    protected void prepareUIForResultDisplay() {
        this.removeAll();
        this.add((Component)this.pnlResult, "Center");
        this.validate();
        this.repaint();
    }

    protected String getOsmUserName() {
        return this.tfUserName.getText();
    }

    protected String getOsmPassword() {
        return String.valueOf(this.tfPassword.getPassword());
    }

    public FullyAutomaticAuthorizationUI(String string, Executor executor) {
        super(string);
        this.executor = executor;
        this.build();
    }

    @Override
    public boolean isSaveAccessTokenToPreferences() {
        return this.pnlAccessTokenInfo.isSaveToPreferences();
    }

    @Override
    protected void setAccessToken(OAuthToken oAuthToken) {
        super.setAccessToken(oAuthToken);
        this.pnlAccessTokenInfo.setAccessToken(oAuthToken);
    }

    class FullyAutomaticAuthorisationTask
    extends PleaseWaitRunnable {
        private boolean canceled;

        FullyAutomaticAuthorisationTask(Component component) {
            super(component, I18n.tr("Authorize JOSM to access the OSM API", new Object[0]), false);
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
        }

        protected void alertAuthorisationFailed() {
            HelpAwareOptionPane.showOptionDialog(FullyAutomaticAuthorizationUI.this, I18n.tr("<html>The automatic process for retrieving an OAuth Access Token<br>from the OSM server failed.<br><br>Please try again or choose another kind of authorization process,<br>i.e. semi-automatic or manual authorization.</html>", new Object[0]), I18n.tr("OAuth authorization failed", new Object[0]), 0, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#FullyAutomaticProcessFailed"));
        }

        protected void alertInvalidLoginUrl() {
            HelpAwareOptionPane.showOptionDialog(FullyAutomaticAuthorizationUI.this, I18n.tr("<html>The automatic process for retrieving an OAuth Access Token<br>from the OSM server failed because JOSM was not able to build<br>a valid login URL from the OAuth Authorize Endpoint URL ''{0}''.<br><br>Please check your advanced setting and try again.</html>", FullyAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters().getAuthoriseUrl()), I18n.tr("OAuth authorization failed", new Object[0]), 0, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#FullyAutomaticProcessFailed"));
        }

        protected void alertLoginFailed() {
            String string = FullyAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters().getOsmLoginUrl();
            HelpAwareOptionPane.showOptionDialog(FullyAutomaticAuthorizationUI.this, I18n.tr("<html>The automatic process for retrieving an OAuth Access Token<br>from the OSM server failed. JOSM failed to log into {0}<br>for user {1}.<br><br>Please check username and password and try again.</html>", string, FullyAutomaticAuthorizationUI.this.getOsmUserName()), I18n.tr("OAuth authorization failed", new Object[0]), 0, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#FullyAutomaticProcessFailed"));
        }

        protected void handleException(OsmOAuthAuthorizationException osmOAuthAuthorizationException) {
            Runnable runnable = () -> {
                if (osmOAuthAuthorizationException instanceof OsmLoginFailedException) {
                    this.alertLoginFailed();
                } else {
                    this.alertAuthorisationFailed();
                }
            };
            Main.error(osmOAuthAuthorizationException);
            GuiHelper.runInEDT(runnable);
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.getProgressMonitor().setTicksCount(3);
                OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = new OsmOAuthAuthorizationClient(FullyAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters());
                OAuthToken oAuthToken = osmOAuthAuthorizationClient.getRequestToken(this.getProgressMonitor().createSubTaskMonitor(1, false));
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
                osmOAuthAuthorizationClient.authorise(oAuthToken, FullyAutomaticAuthorizationUI.this.getOsmUserName(), FullyAutomaticAuthorizationUI.this.getOsmPassword(), FullyAutomaticAuthorizationUI.this.pnlOsmPrivileges.getPrivileges(), this.getProgressMonitor().createSubTaskMonitor(1, false));
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
                OAuthToken oAuthToken2 = osmOAuthAuthorizationClient.getAccessToken(this.getProgressMonitor().createSubTaskMonitor(1, false));
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
                GuiHelper.runInEDT(() -> {
                    FullyAutomaticAuthorizationUI.this.prepareUIForResultDisplay();
                    FullyAutomaticAuthorizationUI.this.setAccessToken(oAuthToken2);
                });
            }
            catch (OsmOAuthAuthorizationException osmOAuthAuthorizationException) {
                this.handleException(osmOAuthAuthorizationException);
            }
        }
    }

    static class PasswordValidator
    extends DefaultTextComponentValidator {
        PasswordValidator(JTextComponent jTextComponent) {
            super(jTextComponent, I18n.tr("Please enter your OSM password", new Object[0]), I18n.tr("The password cannot be empty. Please enter your OSM password", new Object[0]));
        }
    }

    class TestAccessTokenAction
    extends AbstractAction {
        TestAccessTokenAction() {
            this.putValue("Name", I18n.tr("Test Access Token", new Object[0]));
            new ImageProvider("logo").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FullyAutomaticAuthorizationUI.this.executor.execute(new TestAccessTokenTask(FullyAutomaticAuthorizationUI.this, FullyAutomaticAuthorizationUI.this.getApiUrl(), FullyAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters(), FullyAutomaticAuthorizationUI.this.getAccessToken()));
        }
    }

    class BackAction
    extends AbstractAction {
        BackAction() {
            this.putValue("Name", I18n.tr("Back", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Run the automatic authorization steps again", new Object[0]));
            new ImageProvider("dialogs", "previous").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FullyAutomaticAuthorizationUI.this.prepareUIForEnteringRequest();
        }
    }

    class RunAuthorisationAction
    extends AbstractAction
    implements DocumentListener {
        RunAuthorisationAction() {
            this.putValue("Name", I18n.tr("Authorize now", new Object[0]));
            new ImageProvider("oauth", "oauth-small").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Click to redirect you to the authorization form on the JOSM web site", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FullyAutomaticAuthorizationUI.this.executor.execute(new FullyAutomaticAuthorisationTask(FullyAutomaticAuthorizationUI.this));
        }

        protected final void updateEnabledState() {
            this.setEnabled(FullyAutomaticAuthorizationUI.this.valPassword.isValid() && FullyAutomaticAuthorizationUI.this.valUserName.isValid());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }
    }
}

