/*
 * Decompiled with CFR 0.152.
 */
package jnr.enxio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import jnr.constants.platform.Errno;
import jnr.enxio.channels.Native;

final class Common {
    private int _fd = -1;

    Common(int fd) {
        this._fd = fd;
    }

    void setFD(int fd) {
        this._fd = fd;
    }

    int getFD() {
        return this._fd;
    }

    int read(ByteBuffer dst) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(dst.remaining());
        int n = Native.read(this._fd, buffer);
        buffer.flip();
        dst.put(buffer);
        switch (n) {
            case 0: {
                return -1;
            }
            case -1: {
                Errno lastError = Native.getLastError();
                switch (lastError) {
                    case EAGAIN: 
                    case EWOULDBLOCK: {
                        return 0;
                    }
                }
                throw new IOException(Native.getLastErrorString());
            }
        }
        return n;
    }

    long read(ByteBuffer[] dsts, int offset2, int length2) throws IOException {
        long total2 = 0L;
        for (int i2 = 0; i2 < length2; ++i2) {
            ByteBuffer dst = dsts[offset2 + i2];
            long read2 = this.read(dst);
            if (read2 == -1L) {
                return read2;
            }
            total2 += read2;
        }
        return total2;
    }

    int write(ByteBuffer src) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(src.remaining());
        buffer.put(src);
        buffer.position(0);
        int n = Native.write(this._fd, buffer);
        if (n < 0) {
            throw new IOException(Native.getLastErrorString());
        }
        return n;
    }

    long write(ByteBuffer[] srcs, int offset2, int length2) throws IOException {
        long result2 = 0L;
        int index2 = 0;
        for (index2 = offset2; index2 < length2; ++index2) {
            result2 += (long)this.write(srcs[index2]);
        }
        return result2;
    }
}

