/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.core.cast.SplatCastNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.DispatchNode;
import org.jruby.truffle.language.dispatch.MissingBehavior;

@NodeChild(value="child")
public abstract class ArrayCastNode
extends RubyNode {
    private final SplatCastNode.NilBehavior nilBehavior;
    @Node.Child
    private CallDispatchHeadNode toArrayNode = DispatchHeadNodeFactory.createMethodCall(true, MissingBehavior.RETURN_MISSING);

    public ArrayCastNode() {
        this(SplatCastNode.NilBehavior.NIL);
    }

    public ArrayCastNode(SplatCastNode.NilBehavior nilBehavior) {
        this.nilBehavior = nilBehavior;
    }

    protected abstract RubyNode getChild();

    @Specialization
    public DynamicObject cast(boolean value) {
        return this.nil();
    }

    @Specialization
    public DynamicObject cast(int value) {
        return this.nil();
    }

    @Specialization
    public DynamicObject cast(long value) {
        return this.nil();
    }

    @Specialization
    public DynamicObject cast(double value) {
        return this.nil();
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public DynamicObject castBignum(DynamicObject value) {
        return this.nil();
    }

    @Specialization(guards={"isRubyArray(array)"})
    public DynamicObject castArray(DynamicObject array) {
        return array;
    }

    @Specialization(guards={"isNil(nil)"})
    public Object cast(Object nil) {
        switch (this.nilBehavior) {
            case EMPTY_ARRAY: {
                return this.createArray(null, 0);
            }
            case ARRAY_WITH_NIL: {
                return this.createArray(new Object[]{this.nil()}, 1);
            }
            case NIL: {
                return nil;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Specialization(guards={"!isNil(object)", "!isRubyBignum(object)", "!isRubyArray(object)"})
    public Object cast(VirtualFrame frame, DynamicObject object, @Cached(value="create()") BranchProfile errorProfile) {
        Object result = this.toArrayNode.call(frame, object, "to_ary", new Object[0]);
        if (result == this.nil()) {
            return this.nil();
        }
        if (result == DispatchNode.MISSING) {
            return this.nil();
        }
        if (!RubyGuards.isRubyArray(result)) {
            errorProfile.enter();
            throw new RaiseException(this.coreExceptions().typeErrorCantConvertTo(object, "Array", "to_ary", result, this));
        }
        return result;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.getChild().executeVoid(frame);
    }
}

