/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.util.function.Supplier;
import org.jruby.truffle.language.RubyNode;

public class LazyRubyNode
extends RubyNode {
    private final Supplier<RubyNode> resolver;

    public LazyRubyNode(Supplier<RubyNode> resolver) {
        this.resolver = resolver;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.resolve().execute(frame);
    }

    public RubyNode resolve() {
        return this.atomic(() -> {
            RubyNode resolved = this.resolver.get();
            this.replace(resolved, "lazy node resolved");
            return resolved;
        });
    }
}

