/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.core.basicobject.BasicObjectNodes;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.globals.GlobalVariableStorage;
import org.jruby.truffle.language.objects.shared.WriteBarrierNode;

@NodeChild(value="value")
public abstract class WriteGlobalVariableNode
extends RubyNode {
    private final String name;
    @Node.Child
    protected BasicObjectNodes.ReferenceEqualNode referenceEqualNode = BasicObjectNodes.ReferenceEqualNode.create();
    @Node.Child
    protected WriteBarrierNode writeBarrierNode = WriteBarrierNode.create();

    public WriteGlobalVariableNode(String name) {
        this.name = name;
    }

    @Specialization(guards={"referenceEqualNode.executeReferenceEqual(value, previousValue)"}, assumptions={"storage.getUnchangedAssumption()"})
    public Object writeTryToKeepConstant(Object value, @Cached(value="getStorage()") GlobalVariableStorage storage, @Cached(value="storage.getValue()") Object previousValue) {
        storage.setValueInternal(value);
        return previousValue;
    }

    @Specialization(guards={"storage.isAssumeConstant()"}, assumptions={"storage.getUnchangedAssumption()"})
    public Object writeAssumeConstant(Object value, @Cached(value="getStorage()") GlobalVariableStorage storage) {
        if (this.getContext().getSharedObjects().isSharing()) {
            this.writeBarrierNode.executeWriteBarrier(value);
        }
        storage.setValueInternal(value);
        storage.updateAssumeConstant();
        return value;
    }

    @Specialization(guards={"workaround()", "!storage.isAssumeConstant()"}, contains={"writeAssumeConstant"})
    public Object write(Object value, @Cached(value="getStorage()") GlobalVariableStorage storage) {
        if (this.getContext().getSharedObjects().isSharing()) {
            this.writeBarrierNode.executeWriteBarrier(value);
        }
        storage.setValueInternal(value);
        return value;
    }

    protected boolean workaround() {
        return true;
    }

    protected GlobalVariableStorage getStorage() {
        return this.getContext().getCoreLibrary().getGlobalVariables().getStorage(this.name);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.coreStrings().ASSIGNMENT.createInstance();
    }
}

