/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.options;

import org.jruby.truffle.options.OptionDescription;
import org.jruby.truffle.options.OptionTypeException;
import org.jruby.truffle.options.Verbosity;

public class VerbosityOptionDescription
extends OptionDescription {
    private final Verbosity defaultValue;

    public VerbosityOptionDescription(String name, String description, Verbosity defaultValue) {
        super(name, description);
        this.defaultValue = defaultValue;
    }

    public Verbosity getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object checkValue(Object value) {
        if (value == null) {
            return Verbosity.NIL;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return Verbosity.TRUE;
            }
            return Verbosity.FALSE;
        }
        if (value instanceof Integer) {
            switch ((Integer)value) {
                case 0: {
                    return Verbosity.NIL;
                }
                case 1: {
                    return Verbosity.FALSE;
                }
                case 2: {
                    return Verbosity.TRUE;
                }
            }
            throw new OptionTypeException(this.getName(), value.toString());
        }
        if (value instanceof String) {
            switch ((String)value) {
                case "nil": {
                    return Verbosity.NIL;
                }
                case "false": {
                    return Verbosity.FALSE;
                }
                case "true": {
                    return Verbosity.TRUE;
                }
                case "0": {
                    return Verbosity.NIL;
                }
                case "1": {
                    return Verbosity.FALSE;
                }
                case "2": {
                    return Verbosity.TRUE;
                }
            }
            throw new OptionTypeException(this.getName(), value.toString());
        }
        if (value instanceof Verbosity) {
            return value;
        }
        throw new OptionTypeException(this.getName(), value.toString());
    }
}

