/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.platform;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class Platform {
    public static final CPU_TYPE CPU = Platform.determineCPU();
    public static final OS_TYPE OS = Platform.determineOS();
    public static final String LIBPREFIX = OS == OS_TYPE.WINDOWS ? "" : "lib";
    public static final String LIBSUFFIX = Platform.determineLibExt();
    public static final String LIBC = Platform.determineLibC();
    public static final boolean IS_WINDOWS = OS.equals((Object)OS_TYPE.WINDOWS);
    public static final boolean IS_BSD = OS.equals((Object)OS_TYPE.WINDOWS);
    protected final Pattern libPattern;
    private static final String RUBY_DARWIN = "darwin";
    private static final String RUBY_LINUX = "linux";
    private static final String RUBY_WIN32 = "mswin32";
    private static final String RUBY_SOLARIS = "solaris";
    private static final String RUBY_FREEBSD = "freebsd";
    private static final String RUBY_AIX = "aix";
    public static final Map<String, String> RUBY_OS_NAMES = new HashMap<String, String>();

    private static final OS_TYPE determineOS() {
        String osName = System.getProperty("os.name").split(" ")[0];
        if (Platform.startsWithIgnoreCase(osName, "mac") || Platform.startsWithIgnoreCase(osName, RUBY_DARWIN)) {
            return OS_TYPE.DARWIN;
        }
        if (Platform.startsWithIgnoreCase(osName, "sunos") || Platform.startsWithIgnoreCase(osName, RUBY_SOLARIS)) {
            return OS_TYPE.SOLARIS;
        }
        for (OS_TYPE os : OS_TYPE.values()) {
            if (!Platform.startsWithIgnoreCase(osName, os.toString())) continue;
            return os;
        }
        return OS_TYPE.UNKNOWN;
    }

    private static final Platform determinePlatform(OS_TYPE os) {
        switch (os) {
            case DARWIN: {
                return new Darwin();
            }
            case LINUX: {
                return new Linux();
            }
            case AIX: {
                return new AIX();
            }
            case WINDOWS: {
                return new Windows();
            }
            case UNKNOWN: {
                return new Unsupported(os);
            }
        }
        return new Default(os);
    }

    private static final CPU_TYPE determineCPU() {
        String archString = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
        if ("x86".equals(archString) || "i386".equals(archString) || "i86pc".equals(archString)) {
            return CPU_TYPE.I386;
        }
        if ("x86_64".equals(archString) || "amd64".equals(archString)) {
            return CPU_TYPE.X86_64;
        }
        if ("ppc".equals(archString) || "powerpc".equals(archString)) {
            return CPU_TYPE.POWERPC;
        }
        if ("ppc64".equals(archString)) {
            return CPU_TYPE.POWERPC64;
        }
        if ("ppc64le".equals(archString)) {
            return CPU_TYPE.POWERPC64LE;
        }
        if ("sparc".equals(archString)) {
            return CPU_TYPE.SPARC;
        }
        if ("sparcv9".equals(archString)) {
            return CPU_TYPE.SPARCV9;
        }
        if ("s390x".equals(archString)) {
            return CPU_TYPE.S390X;
        }
        if ("arm".equals(archString)) {
            return CPU_TYPE.ARM;
        }
        if ("universal".equals(archString)) {
            String bits = System.getProperty("sun.arch.data.model", null);
            if ("32".equals(bits)) {
                System.setProperty("os.arch", "i386");
                return CPU_TYPE.I386;
            }
            if ("64".equals(bits)) {
                System.setProperty("os.arch", "x86_64");
                return CPU_TYPE.X86_64;
            }
        }
        return CPU_TYPE.UNKNOWN;
    }

    private static final String determineLibC() {
        switch (OS) {
            case WINDOWS: {
                return "msvcrt.dll";
            }
            case LINUX: {
                return "libc.so.6";
            }
            case AIX: {
                if (Integer.getInteger("sun.arch.data.model") == 32) {
                    return "libc.a(shr.o)";
                }
                return "libc.a(shr_64.o)";
            }
        }
        return LIBPREFIX + "c." + LIBSUFFIX;
    }

    private static final String determineLibExt() {
        switch (OS) {
            case WINDOWS: {
                return "dll";
            }
            case AIX: {
                return "a";
            }
            case DARWIN: {
                return "dylib";
            }
        }
        return "so";
    }

    protected Platform(OS_TYPE os) {
        String libpattern = null;
        switch (os) {
            case WINDOWS: {
                libpattern = ".*\\.dll$";
                break;
            }
            case DARWIN: {
                libpattern = "lib.*\\.(dylib|jnilib)$";
                break;
            }
            case AIX: {
                libpattern = "lib.*\\.a$";
                break;
            }
            default: {
                libpattern = "lib.*\\.so.*$";
            }
        }
        this.libPattern = Pattern.compile(libpattern);
    }

    public static final Platform getPlatform() {
        return SingletonHolder.PLATFORM;
    }

    public final OS_TYPE getOS() {
        return OS;
    }

    public String getName() {
        return (Object)((Object)CPU) + "-" + (Object)((Object)OS);
    }

    private static boolean startsWithIgnoreCase(String s1, String s2) {
        return s1.startsWith(s2) || s1.toUpperCase(Locale.ENGLISH).startsWith(s2.toUpperCase(Locale.ENGLISH)) || s1.toLowerCase(Locale.ENGLISH).startsWith(s2.toLowerCase(Locale.ENGLISH));
    }

    public static String getOSName() {
        if (jnr.posix.util.Platform.IS_WINDOWS) {
            return RUBY_WIN32;
        }
        String OSName = jnr.posix.util.Platform.getOSName();
        String theOSName = RUBY_OS_NAMES.get(OSName);
        return theOSName == null ? OSName : theOSName;
    }

    public static String getArchitecture() {
        String architecture = jnr.posix.util.Platform.ARCH;
        if (architecture == null) {
            architecture = "unknown";
        }
        if (architecture.equals("amd64")) {
            architecture = "x86_64";
        }
        return architecture;
    }

    static /* synthetic */ OS_TYPE access$000() {
        return Platform.determineOS();
    }

    static /* synthetic */ Platform access$100(OS_TYPE x0) {
        return Platform.determinePlatform(x0);
    }

    static {
        RUBY_OS_NAMES.put("Mac OS X", RUBY_DARWIN);
        RUBY_OS_NAMES.put("Darwin", RUBY_DARWIN);
        RUBY_OS_NAMES.put("Linux", RUBY_LINUX);
        RUBY_OS_NAMES.put("Windows 95", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 98", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Me", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows NT", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 2000", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows NT (unknown)", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows XP", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 2003", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Vista", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 7", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Server 2008", RUBY_WIN32);
        RUBY_OS_NAMES.put("Solaris", RUBY_SOLARIS);
        RUBY_OS_NAMES.put("SunOS", RUBY_SOLARIS);
        RUBY_OS_NAMES.put("FreeBSD", RUBY_FREEBSD);
        RUBY_OS_NAMES.put("AIX", RUBY_AIX);
    }

    private static class Windows
    extends Supported {
        public Windows() {
            super(OS_TYPE.WINDOWS);
        }
    }

    private static final class AIX
    extends Supported {
        public AIX() {
            super(OS_TYPE.AIX);
        }
    }

    private static final class Linux
    extends Supported {
        public Linux() {
            super(OS_TYPE.LINUX);
        }
    }

    private static final class Darwin
    extends Supported {
        public Darwin() {
            super(OS_TYPE.DARWIN);
        }
    }

    private static final class Default
    extends Platform {
        public Default(OS_TYPE os) {
            super(os);
        }
    }

    private static class Unsupported
    extends Platform {
        public Unsupported(OS_TYPE os) {
            super(os);
        }
    }

    private static class Supported
    extends Platform {
        public Supported(OS_TYPE os) {
            super(os);
        }
    }

    private static final class SingletonHolder {
        private static final Platform PLATFORM = Platform.access$100(Platform.access$000());

        private SingletonHolder() {
        }
    }

    public static enum CPU_TYPE {
        I386,
        X86_64,
        POWERPC,
        POWERPC64,
        POWERPC64LE,
        SPARC,
        SPARCV9,
        S390X,
        ARM,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum OS_TYPE {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        LINUX,
        SOLARIS,
        AIX,
        WINDOWS,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

