/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk;

import java.util.Date;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public final class UtilDetailsProvider
extends DetailsProvider.Basic {
    private static final String LOGGER_MASK = "java.util.logging.Logger+";
    private static final String LEVEL_MASK = "java.util.logging.Level+";
    private static final String LOCALE_MASK = "java.util.Locale";
    private static final String DATE_MASK = "java.util.Date+";
    private static final String TIMEZONE_MASK = "java.util.TimeZone+";
    private static final String PATTERN_MASK = "java.util.regex.Pattern";
    private static final String CURRENCY_MASK = "java.util.Currency";

    public UtilDetailsProvider() {
        super(LOGGER_MASK, LEVEL_MASK, LOCALE_MASK, DATE_MASK, TIMEZONE_MASK, PATTERN_MASK, CURRENCY_MASK);
    }

    @Override
    public String getDetailsString(String string, Instance instance, Heap heap) {
        if (LOGGER_MASK.equals(string) || LEVEL_MASK.equals(string)) {
            return DetailsUtils.getInstanceFieldString(instance, "name", heap);
        }
        if (LOCALE_MASK.equals(string)) {
            String string2;
            String string3 = DetailsUtils.getInstanceFieldString(instance, "language", heap);
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = DetailsUtils.getInstanceFieldString(instance, "country", heap)) == null) {
                string2 = "";
            }
            if (!string3.isEmpty() || !string2.isEmpty()) {
                if (string3.isEmpty() || string2.isEmpty()) {
                    return string3 + string2;
                }
                return string3 + "_" + string2;
            }
        } else {
            if (DATE_MASK.equals(string)) {
                long l = DetailsUtils.getLongFieldValue(instance, "fastTime", -1L);
                return new Date(l).toString();
            }
            if (TIMEZONE_MASK.equals(string)) {
                return DetailsUtils.getInstanceFieldString(instance, "ID", heap);
            }
            if (PATTERN_MASK.equals(string)) {
                return DetailsUtils.getInstanceFieldString(instance, "pattern", heap);
            }
            if (CURRENCY_MASK.equals(string)) {
                return DetailsUtils.getInstanceFieldString(instance, "currencyCode", heap);
            }
        }
        return null;
    }
}

