

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Universal csv with field structure in first line (unicsv){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Universal csv with field structure in first line (unicsv)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="fmt_tiger.html">Prev</a> </td><th width="60%" align="center">Chapter 3. The Formats</th><td width="20%" align="right"> <a accesskey="n" href="fmt_vcard.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="fmt_unicsv"></a>Universal csv with field structure in first line (unicsv)</h2></div></div></div><p class="fmtcapshdr">
    This format can...
    </p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p class="fmtcapsitem">
          read and write waypoints
        </p></li><li class="listitem"><p class="fmtcapsitem">
          read and write tracks
        </p></li><li class="listitem"><p class="fmtcapsitem">
          read and write routes
        </p></li></ul></div><p>This format has the following options: <a class="link" href="fmt_unicsv.html#fmt_unicsv_o_datum" title="datum option">datum</a>, <a class="link" href="fmt_unicsv.html#fmt_unicsv_o_grid" title="grid option">grid</a>, <a class="link" href="fmt_unicsv.html#fmt_unicsv_o_utc" title="utc option">utc</a>, <a class="link" href="fmt_unicsv.html#fmt_unicsv_o_format" title="format option">format</a>, <a class="link" href="fmt_unicsv.html#fmt_unicsv_o_filename" title="filename option">filename</a>, <a class="link" href="fmt_unicsv.html#fmt_unicsv_o_fields" title="fields option">fields</a> .</p><p>
   Unicsv examines the first line of a file to determine the field
   order and field separator in that file.   On write, it tries to 
   figure out what data it has and writes headers and all the data it can.
</p><p>
   If the first line contains any tabs, the data lines are assumed
   to be tab separated.   Otherwise the fields are assumed to be
   separated by commas.
</p><p>
   The list of keywords include:
   </p><pre class="screen">
      alt =      Elevation (in meters) of the point. Add "ft" or "feet" for feet.
      arch =     <a class="link" href="style_define.html#style_def_isarchived" title="GEOCACHE_ISARCHIVED">Geocache archived flag</a>
      avail =    <a class="link" href="style_define.html#style_def_isavailable" title="GEOCACHE_ISAVAILABLE">Geocache available flag</a>
      bng_e =    British National Grid's easting
      bng =      full coordinate in BNG format (zone easting northing)
      bng_pos =  full coordinate in BNG format (zone easting northing)
      bng_n =    British National Grid's northing
      bng_z =    British National Grid's zone
      caden =    Cadence
      comment =  Notes
      cont =     <a class="link" href="style_define.html#style_def_geocontainer" title="GEOCACHE_CONTAINER">Geocache container</a>
      cour =     Heading / Course true
      date =     Date (yyyy/mm/dd)
      depth =    Depth (in meters).  Add "ft" or "feet" for feet.
      desc =     Description
      diff =     <a class="link" href="style_define.html#style_def_geodiff" title="GEOCACHE_DIFF">Geocache difficulty</a>
      ele =      Elevation (in meters) of the point. Add "ft" or "feet" for feet.
      e/w =      'e' for eastern hemisphere, 'w' for western
      exported = Geocache export date 
      found =    <a class="link" href="style_define.html#style_def_geofound" title="GEOCACHE_LAST_FOUND">Geocache last found date</a>
      fix =      3d, 2d, etc.
      gcid =     Geocache cache id
      geschw =   Geschwindigkeit (speed)
      hdop =     Horizontal dilution of precision
      head =     Heading / Course true
      heart =    Heartrate
      height =   Elevation (in meters) of the point
      hint =     <a class="link" href="style_define.html#style_def_geohint" title="GEOCACHE_HINT">Geocache cache hint</a>
      icon =     Symbol (icon) name
      lat =      Latitude
      lon =      Longitude
      name =     Waypoint name ("Shortname")
      n/s =      'n' for northern hemisphere, 's' for southern
      notes =    Notes
      pdop =     Position dilution of precision
      placer =   <a class="link" href="style_define.html#style_def_geoplacer" title="GEOCACHE_PLACER">Geocache placer</a>
      placer_id =Geocache placer id
      power =    Cycling power (in Watts)
      prox =     Proximity (in meters).  Add "ft" or "feet" for feet.
      sat =      Number of sats used for fix
      speed =    Speed, in meters per second. (See below)
      symb =     Symbol (icon) name
      tempf =    Temperature (degrees Fahrenheit)
      temp =     Temperature (degrees Celsius)
      terr =     <a class="link" href="style_define.html#style_def_geoterr" title="GEOCACHE_TERR">Geocache terrain</a>
      time =     Time (hh:mm:ss[.msec])
      type =     <a class="link" href="style_define.html#style_def_geotype" title="GEOCACHE_TYPE">Geocache cache type</a>
      url =      URL
      utc_d =    UTC date
      utc_t =    UTC time
      utm_c =    UTM zone character
      utm_e =    UTM easting
      utm =      full coordinate in UTM format (zone zone-ch easting northing)
      utm_pos =  full coordinate in UTM format (zone zone-ch easting northing)
      utm_n =    UTM northing
      utm_z =    UTM zone
      vdop =     Vertical dilution of precision
      x =        Longitude
      x_pos =    Longitude
      y =        Latitude
      y_pos =    Latitude
      z =        Altitude (elevation).  See "elevation".
   </pre><p>
   We support some enhanced Garmin attributes. They are also available in 
   <a class="link" href="fmt_gpx.html" title="GPX XML (gpx)">gpx</a>, <a class="link" href="fmt_gdb.html" title="Garmin MapSource - gdb (gdb)">gdb</a>, 
   <a class="link" href="fmt_garmin_gpi.html" title="Garmin Points of Interest (.gpi) (garmin_gpi)">garmin_gpi</a> and partly 
   <a class="link" href="fmt_garmin_txt.html" title="Garmin MapSource - txt (tab delimited) (garmin_txt)">garmin_txt</a>. These entities are currently 
   not visible in <span class="productname">MapSource</span>™ (6.12.4), but are NOT dropped  
   when working with GDB (version 3) or GPX files.
   </p><pre class="screen"></pre><p>
   Please note, that these do NOT provide a geocoding service; don't expect
	to "convert" a street address to a latitude and longitude.
   </p><pre class="screen">
      addr =     Street address
      city =     City
      country =  Country
      faci =     Facility (not available in GPX)
      phone =    Phone number
      post =     Postal code
      state =    State
   </pre><p>
   Fuller spellings (i.e. "longitude") may be used. You can also
   use keywords with a whitespace instead of an underscore.
</p><p>
   A typical file may be:
   </p><pre class="screen">
     Name, Latitude, Longitude, Description 
     GCEBB,35.972033,-87.134700,Mountain Bike Heaven by susy1313
     GC1A37,36.090683,-86.679550,The Troll by a182pilot &amp; Family
   </pre><p>
</p><p>
   On the output side unicsv writes fixed number of columns (waypoint index, latitude and longitude)
   followed by a variable column list depending on internal data.
</p><p>
   With at least ONE valid timestamp in data a unicsv output may look like that:
   </p><pre class="screen">
     No,Name,Latitude,Longitude,Description,Date,Time
     1,"GCEBB",35.972033,-87.134700,"Mountain Bike Heaven by susy1313",2003/06/29,09:00:00
     2,"GC1A37",36.090683,-86.679550,"The Troll by a182pilot &amp; Family",,
   </pre><p>
</p><p>
For speed, a units specifier can be added to override the default. Here
are some values, but check parse_speed() in parse.cc for the authoritative
list.
</p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p>m/s, mps: meters per second</p></li><li class="listitem"><p>km/h, kmh: kilometers per hour</p></li><li class="listitem"><p>kt, knots: knots</p></li><li class="listitem"><p>mph, mi/h, mih: miles per hour</p></li></ul></div><p>
</p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_unicsv_o_datum"></a><code class="option">datum</code> option</h3></div></div></div><p>
      GPS datum (def. WGS 84).
    </p><p>
   This option specifies the datum to be used on output. Valid values for this 
   option are listed in <a class="xref" href="Datums.html" title="Appendix A. Supported Datums">Appendix A, <em>Supported Datums</em></a>.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_unicsv_o_grid"></a><code class="option">grid</code> option</h3></div></div></div><p>
      Write position using this grid..
    </p><p>
   This value specifies the grid to be used on write. It is similar to
   the grid option of garmin_txt (see <a class="xref" href="fmt_garmin_txt.html#garmin_grid" title="Table 3.1. Grid values for garmin_txt">Table 3.1, “Grid values for garmin_txt”</a>). The only difference is that unicsv does not
   write a degree sign (°) into the output file.
</p><p>
   Without this option unicsv writes the coordinates as simple numbers like in the samples above.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_unicsv_o_utc"></a><code class="option">utc</code> option</h3></div></div></div><p>
      Write timestamps with offset x to UTC time.
    </p><p>
This option specifies the local time zone to use when writing times.  It
is specified as an offset from Universal Coordinated Time (UTC) in hours.  
Valid values are from -23 to +23.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_unicsv_o_format"></a><code class="option">format</code> option</h3></div></div></div><p>
      Write name(s) of format(s) from input session(s).
    </p><p>
  When this option is enabled, we generate an additional 'Format' column.
  The values of this column are filled with names of previous input formats.
</p><div class="example"><a id="unicsv_format"></a><p class="title"><strong>Example 3.39. Example for unicsv format option to write names of input formats.</strong></p><div class="example-contents"><p>
    The next example ...
    <strong class="userinput"><code>
      gpsbabel -i gpx -f file1.gpx -i gdb -f file2.gdb -o unicsv,format=y -F result.txt
    </code></strong>
    ... could produce following output:
    </p><table border="0" summary="Simple list" class="simplelist"><tr><td>No,Latitude,Longitude,Name,Description,Symbol,Date,Time,Format</td></tr><tr><td>1,51.075139,12.463689,"578","578","Waypoint",2005/04/26,16:27:23,"gdb"</td></tr><tr><td>2,51.081104,12.465277,"579","579","Waypoint",2005/04/26,16:27:23,"gdb"</td></tr><tr><td>3,50.844126,12.408757,"Gosel","Gosel","Exit",2005/02/26,10:10:47,"gpx"</td></tr><tr><td>4,50.654763,12.204957,"Greiz",,"Exit",2005/02/26,09:57:04,"gpx"</td></tr></table><p>
  </p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_unicsv_o_filename"></a><code class="option">filename</code> option</h3></div></div></div><p>
      Write filename(s) from input session(s).
    </p><p>
  When this option is enabled, we write an additional column called 'Filename'.
  The values of this column are filled with filenames of previous input formats.
</p><p>
  This can be very helpful for locating specific waypoints (i.e. using the position filter)
  in more than one file.
</p><div class="example"><a id="unicsv_filename"></a><p class="title"><strong>Example 3.40. Example for unicsv filename option to write filenames of input formats.</strong></p><div class="example-contents"><p>
    The next example ...
    <strong class="userinput"><code>
      gpsbabel -i gpx -f file1.gpx -i gdb -f file2.gdb -o unicsv,filename=1 -F result.txt
    </code></strong>
    ... could produce following output:
    </p><table border="0" summary="Simple list" class="simplelist"><tr><td>No,Latitude,Longitude,Name,Date,Time,Filename</td></tr><tr><td>1,51.075139,12.463689,"578",2005/04/26,16:27:23,"reference/gdb-sample.gdb"</td></tr><tr><td>2,51.081104,12.465277,"579",2005/04/26,16:27:23,"reference/gdb-sample.gdb"</td></tr><tr><td>3,50.844126,12.408757,"580",2005/02/26,10:10:47,"reference/gdb-sample.gpx"</td></tr><tr><td>4,50.654763,12.204957,"581",2005/02/26,09:57:04,"reference/gdb-sample.gpx"</td></tr></table><p>
  </p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_unicsv_o_fields"></a><code class="option">fields</code> option</h3></div></div></div><p>
      Name and order of input fields, separated by '+'.
    </p><p>
This option lets you specify the field names of your input file from
the command line instead of relying on the first line of your input
file describing the file. Field names are separated by a '+' character.
The list of field names is exactly that allowed in the first line of a
unicsv file without this option.
</p><div class="example"><a id="unicsv_fields"></a><p class="title"><strong>Example 3.41. Example for unicsv fields option to describe input file.</strong></p><div class="example-contents"><p>
    For example ...
    <strong class="userinput"><code>
      gpsbabel -i unicsv,fields=lat+lon+description -f file.csv -o gpx -F file.gpx
    </code></strong>
    declares that file.csv has three fields, latitude, longitude, 
    and description, in that order.
  </p></div></div><br class="example-break" /></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="fmt_tiger.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="The_Formats.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="fmt_vcard.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">U.S. Census Bureau Tiger Mapping Service (tiger) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Vcard Output (for iPod) (vcard)</td></tr></table></div>
  
      {/literal}{/block}
  