/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.common.ScriptTokenizer;

public enum ScriptToken {
    UNKNOWN,
    APPLETID,
    APPLETREADYCALLBACKFUNCTIONNAME,
    AUTOINTEGRATE("TF", "automatically integrate an NMR spectrum"),
    BACKGROUNDCOLOR("C", "set the background color"),
    CLOSE("spectrumId or fileName or ALL or VIEWS or SIMULATIONS", "close one or more views or simulations"),
    COMPOUNDMENUON,
    COORDCALLBACKFUNCTIONNAME,
    COORDINATESCOLOR("C", "set the color of the coordinates shown in the upper right-hand corner"),
    COORDINATESON("T", "turn on or off the coordinates shown in the upper right-hand corner"),
    DEBUG("TF", "turn debugging on and off"),
    DEFAULTLOADSCRIPT("\"script...\"", "set the script to be run after each file is loaded"),
    DEFAULTNMRNORMALIZATION("maxYvalue", "set the value to be given the largest peak in an HMR spectrum"),
    DISPLAYFONTNAME,
    DISPLAY1D("T", "turn on or off display of 1D spectra when 1D and 2D spectra are loaded"),
    DISPLAY2D("T", "turn on or off display of the 2D spectrum when 1D and 2D spectra are loaded"),
    ENABLEZOOM("T", "allow or disallow zooming"),
    ENDINDEX,
    FINDX("value", "move the vertical-line cursor to a specific x-axis value"),
    GETPROPERTY("[propertyName] or ALL or NAMES", "get a property value or all property values as key/value pairs, or a list of names"),
    GETSOLUTIONCOLOR(" FILL or FILLNONE or FILLALL or FILLALLNONE", "estimate the solution color for UV/VIS spectra"),
    GRIDCOLOR("C", "color of the grid"),
    GRIDON("T", "turn the grid lines on or off"),
    HELP("[command]", "get this listing or help for a specific command"),
    HIDDEN,
    HIGHLIGHTCOLOR("C", "set the highlight color"),
    HIGHLIGHT("OFF or X1 X2 [OFF] or X1 X2 r g b [a]", "turns on or off a highlight color, possibily setting its color, where r g b a are 0-255 or 0.0-1.0"),
    INTEGRALOFFSET("percent", "sets the integral offset from baseline"),
    INTEGRALRANGE("percent", "sets the height of the total integration"),
    INTEGRATE("", "see INTEGRATION"),
    INTEGRATION("ON/OFF/TOGGLE/AUTO/CLEAR/MIN value/MARK ppm1-ppm2:norm,ppm3-ppm4,...", "show/hide integration or set integrals (1D 1H NMR only)"),
    INTEGRALPLOTCOLOR("C", "color of the integration line"),
    INTEGRATIONRATIOS("'x:value,x:value,..'", "annotate the spectrum with numbers or text at specific x values"),
    INTERFACE("SINGLE or OVERLAY", "set how multiple spectra are displayed"),
    IRMODE("A or T or TOGGLE", "set the IR mode to absorption or transmission"),
    JMOL("...Jmol command...", "send a command to Jmol (if present)"),
    JSV,
    LABEL("x y [color and/or \"text\"]", "add a text label"),
    LINK("AB or ABC or NONE or ALL", "synchronize the crosshair of a 2D spectrum with 1D cursors"),
    LOAD("[APPEND] \"fileName\" [first] [last]; use \"\" for current file; $H1/name or $C13/name for simulation", "load a specturm"),
    LOADFILECALLBACKFUNCTIONNAME,
    LOADIMAGINARY("TF", "set TRUE to load imaginary NMR component"),
    MENUON,
    OBSCURE,
    OVERLAY,
    OVERLAYSTACKED("TF", "whether viewed spectra are shown separately, in a stack"),
    PEAK("[IR,CNMR,HNMR,MS] [#nnn or ID=xxx or text] [ALL], for example: PEAK HNMR #3", "highlights a peak based on its number or title text, optionally checking all loade spectra"),
    PEAKCALLBACKFUNCTIONNAME,
    PEAKLIST("[THRESHOLD=n] [INTERPOLATE=PARABOLIC or NONE]", "creates a peak list based on a threshold value and parabolic or no interpolation"),
    PEAKTABCOLOR("C", "sets the color of peak marks for a peak listing"),
    PEAKTABSON("T", "show peak tabs for simulated spectra"),
    PLOTAREACOLOR("C", "sets the color of the plot background"),
    PLOTCOLOR("C", "sets the color of the graph line"),
    PLOTCOLORS("color,color,color,...", "sets the colors of multiple plots"),
    PRINT("", "prints the current spectrum"),
    REVERSEPLOT("T", "reverses the x-axis of a spectrum"),
    SCALEBY("factor", "multiplies the y-scale of the spectrum by a factor"),
    SCALECOLOR("C", "sets the color of the x-axis and y-axis scales"),
    SCRIPT("filename.jsv", "runs a script from a file"),
    SELECT("spectrumID, spectrumID,...", "selects one or more spectra based on IDs"),
    SETPEAK("xNew, xOld xNew, ?, or NONE", "sets nearest peak to xOld ppm to a new value; NONE resets (1D NMR only)"),
    SETX("xNew, xOld xNew, ?, or NONE", "sets an old ppm position in the spectrum to a new value; NONE resets (1D NMR only)"),
    SHIFTX("dx or NONE", "shifts the x-axis of a 1D NMR spectrum by the given ppm; NONE resets (1D NMR only)"),
    SHOWERRORS("shows recent errors"),
    SHOWINTEGRATION("T", "shows an integration listing"),
    SHOWKEY("T", "shows a color key when multiple spectra are displayed"),
    SHOWMEASUREMENTS("T", "shows a listing of measurements"),
    SHOWMENU("displays the popup menu"),
    SHOWPEAKLIST("T", "shows a listing for peak picking"),
    SHOWPROPERTIES("displays the header information of a JDX file"),
    SHOWSOURCE("displays the source JDX file associated with the selected data"),
    SPECTRUM("id", "displays a specific spectrum, where id is a number 1, 2, 3... or a file.spectrum number such as 2.1"),
    SPECTRUMNUMBER("n", "displays the nth spectrum loaded"),
    STACKOFFSETY("percent", "sets the y-axis offset of stacked spectra"),
    STARTINDEX,
    SYNCCALLBACKFUNCTIONNAME,
    SYNCID,
    TEST,
    TITLEON("T", "turns the title in the bottom left corner on or off"),
    TITLEBOLDON("T", "makes the title bold"),
    TITLECOLOR("C", "sets the color of the title"),
    TITLEFONTNAME("fontName", "sets the title font"),
    UNITSCOLOR("C", "sets the color of the x-axis and y-axis units"),
    VERSION,
    VIEW("spectrumID, spectrumID, ... Example: VIEW 3.1, 3.2  or  VIEW \"acetophenone\"", "creates a view of one or more spectra"),
    XSCALEON("T", "set FALSE to turn off the x-axis scale"),
    XUNITSON("T", "set FALSE to turn off the x-axis units"),
    YSCALE("[ALL] lowValue highValue"),
    YSCALEON("T", "set FALSE to turn off the y-axis scale"),
    YUNITSON("T", "set FALSE to turn off the y-axis units"),
    WINDOW,
    WRITE("[XY,DIF,DIFDUP,PAC,FIX,SQZ,AML,CML,JPG,PDF,PNG,SVG] \"filename\"", "writes a file in the specified format"),
    ZOOM("OUT or PREVIOUS or NEXT or x1,x2 or x1,y1 x2,y2", "sets the zoom"),
    ZOOMBOXCOLOR,
    ZOOMBOXCOLOR2;

    private String tip;
    private String description;
    public static Map<String, ScriptToken> htParams;

    public String getTip() {
        return "  " + (this.tip == "T" ? "TRUE/FALSE/TOGGLE" : (this.tip == "TF" ? "TRUE or FALSE" : (this.tip == "C" ? "COLOR" : this.tip)));
    }

    private ScriptToken() {
    }

    private ScriptToken(String string2) {
        this.tip = string2;
        this.description = "";
    }

    private ScriptToken(String string2, String string3) {
        this.tip = string2;
        this.description = "-- " + string3;
    }

    public static ScriptToken getScriptToken(String string) {
        Object object;
        if (htParams == null) {
            htParams = new Hashtable<String, ScriptToken>();
            object = ScriptToken.values();
            int n = ((ScriptToken[])object).length;
            for (int i = 0; i < n; ++i) {
                ScriptToken scriptToken = object[i];
                htParams.put(scriptToken.name(), scriptToken);
            }
        }
        return (object = htParams.get(string.toUpperCase())) == null ? UNKNOWN : object;
    }

    public static Lst<ScriptToken> getScriptTokenList(String string, boolean bl) {
        if (string != null) {
            string = string.toUpperCase();
        }
        Lst<ScriptToken> lst = new Lst<ScriptToken>();
        if (bl) {
            ScriptToken scriptToken = ScriptToken.getScriptToken(string);
            if (scriptToken != null) {
                lst.addLast(scriptToken);
            }
        } else {
            for (Map.Entry<String, ScriptToken> entry : htParams.entrySet()) {
                if (string != null && !entry.getKey().startsWith(string) || entry.getValue().tip == null) continue;
                lst.addLast(entry.getValue());
            }
        }
        return lst;
    }

    public static String getValue(ScriptToken scriptToken, ScriptTokenizer scriptTokenizer, String string) {
        if (!scriptTokenizer.hasMoreTokens()) {
            return "";
        }
        switch (scriptToken) {
            default: {
                return ScriptTokenizer.nextStringToken(scriptTokenizer, true);
            }
            case CLOSE: 
            case GETPROPERTY: 
            case INTEGRATION: 
            case INTEGRATE: 
            case JMOL: 
            case LABEL: 
            case LOAD: 
            case PEAK: 
            case PLOTCOLORS: 
            case YSCALE: 
            case WRITE: {
                return ScriptToken.removeCommandName(string);
            }
            case SELECT: 
            case OVERLAY: 
            case VIEW: 
            case ZOOM: 
        }
        return ScriptToken.removeCommandName(string).replace(',', ' ').trim();
    }

    private static String removeCommandName(String string) {
        int n = string.indexOf(" ");
        if (n < 0) {
            return "";
        }
        return string.substring(n).trim();
    }

    public static String getKey(ScriptTokenizer scriptTokenizer) {
        String string = scriptTokenizer.nextToken();
        if (string.startsWith("#") || string.startsWith("//")) {
            return null;
        }
        if (string.equalsIgnoreCase("SET")) {
            string = scriptTokenizer.nextToken();
        }
        return string.toUpperCase();
    }

    public static Lst<String> getTokens(String string) {
        String string2;
        if (string.startsWith("'") && string.endsWith("'")) {
            string = "\"" + PT.trim(string, "'") + "\"";
        }
        Lst<String> lst = new Lst<String>();
        ScriptTokenizer scriptTokenizer = new ScriptTokenizer(string, false);
        while (scriptTokenizer.hasMoreTokens() && !(string2 = ScriptTokenizer.nextStringToken(scriptTokenizer, false)).startsWith("//") && !string2.startsWith("#")) {
            lst.addLast(string2);
        }
        return lst;
    }

    public static String getNameList(Lst<ScriptToken> lst) {
        if (lst.size() == 0) {
            return "";
        }
        SB sB = new SB();
        for (int i = 0; i < lst.size(); ++i) {
            sB.append(",").append(((ScriptToken)((Object)lst.get(i))).toString());
        }
        return sB.toString().substring(1);
    }

    public String getDescription() {
        return this.description;
    }
}

