/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.util.Hashtable;
import javajs.util.PT;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.webexport.JmolInstance;
import org.openscience.jmol.app.webexport.WebExport;
import org.openscience.jmol.app.webexport.WebPanel;

class PopInJmol
extends WebPanel
implements ChangeListener {
    PopInJmol(Viewer vwr, JFileChooser fc, WebPanel[] webPanels, int panelIndex) {
        super(vwr, fc, webPanels, panelIndex);
        this.panelName = "pop_in";
        this.listLabel = GT._("These names will be used as filenames used by JSmol");
    }

    @Override
    JPanel appletParamPanel() {
        SpinnerNumberModel appletSizeModelW = new SpinnerNumberModel(WebExport.getPopInWidth(), 50, 1000, 25);
        SpinnerNumberModel appletSizeModelH = new SpinnerNumberModel(WebExport.getPopInHeight(), 50, 1000, 25);
        this.appletSizeSpinnerW = new JSpinner(appletSizeModelW);
        this.appletSizeSpinnerW.addChangeListener(this);
        this.appletSizeSpinnerH = new JSpinner(appletSizeModelH);
        this.appletSizeSpinnerH.addChangeListener(this);
        JPanel appletSizeWHPanel = new JPanel();
        appletSizeWHPanel.add(new JLabel(GT._("JSmol width:")));
        appletSizeWHPanel.add(this.appletSizeSpinnerW);
        appletSizeWHPanel.add(new JLabel(GT._("height:")));
        appletSizeWHPanel.add(this.appletSizeSpinnerH);
        return appletSizeWHPanel;
    }

    @Override
    String fixHtml(String html) {
        String s = "";
        int nApplets = this.getInstanceList().getModel().getSize();
        for (int i = 0; i < nApplets; ++i) {
            String javaname = this.getInstanceList().getModel().getElementAt((int)i).javaname;
            s = s + "   var jmolInfo" + i + "=jmolInfo;\n";
            s = s + "   jmolInfo" + i + ".coverImage=\"" + javaname + ".png\";\n";
            s = s + "   jmolInfo" + i + ".coverScript=\"javascript revealPopinWidgets(" + i + ");\";\n";
            s = s + "   jmolInfo" + i + ".script=\"load " + javaname + ".spt\";\n";
            s = s + "   $(\"#Jmol" + i + "\").html(Jmol.getAppletHtml(\"jmolApplet" + i + "\",jmolInfo" + i + "));\n";
        }
        html = PT.rep(html, "@APPLETINITIALIZATION@", s);
        return html;
    }

    @Override
    String getAppletDefs(int i, String html, StringBuilder appletDefs, JmolInstance instance) {
        String divClass = i % 2 == 0 ? "floatRight" : "floatLeft";
        String name = instance.name;
        String javaname = instance.javaname;
        int JmolSizeW = instance.width;
        int JmolSizeH = instance.height;
        String widgetDefs = "";
        if (!instance.whichWidgets.isEmpty()) {
            widgetDefs = widgetDefs + "<div id=\"JmolCntl" + i + "\">";
            for (int j = 0; j < this.nWidgets; ++j) {
                if (!instance.whichWidgets.get(j)) continue;
                widgetDefs = widgetDefs + "\n<div class=\"widgetItemPopin\">" + this.theWidgets.widgetList[j].getJavaScript(i, instance) + "</div>\n";
            }
            widgetDefs = widgetDefs + "</div>";
        }
        String s = this.htmlAppletTemplate;
        s = PT.rep(s, "@CLASS@", "" + divClass);
        s = PT.rep(s, "@I@", "" + i);
        s = PT.rep(s, "@WIDTH@", "" + JmolSizeW);
        s = PT.rep(s, "@HEIGHT@", "" + JmolSizeH);
        s = PT.rep(s, "@NAME@", "&#x201C;" + GT.escapeHTML(name) + "&#x201D;");
        s = PT.rep(s, "@APPLETNAME@", GT.escapeHTML(javaname));
        s = PT.rep(s, "@LEFTWIDGETS@", "");
        s = PT.rep(s, "@RIGHTWIDGETS@", widgetDefs);
        appletDefs.append(s);
        return html;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.appletSizeSpinnerW || e.getSource() == this.appletSizeSpinnerH) {
            int width = ((SpinnerNumberModel)this.appletSizeSpinnerW.getModel()).getNumber().intValue();
            int height = ((SpinnerNumberModel)this.appletSizeSpinnerH.getModel()).getNumber().intValue();
            WebExport.setPopInDim(width, height);
            JList<JmolInstance> whichList = this.getInstanceList();
            int[] list = whichList.getSelectedIndices();
            if (list.length != 1) {
                return;
            }
            int index = whichList.getSelectedIndex();
            JmolInstance instance = whichList.getModel().getElementAt(index);
            instance.width = width;
            instance.height = height;
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            params.put("fileName", instance.pictFile);
            params.put("type", "PNG");
            params.put("quality", 2);
            params.put("width", width);
            params.put("height", height);
            this.vwr.outputToFile(params);
            return;
        }
        if (e.getSource() == this.appletSizeSpinnerP) {
            int percent = ((SpinnerNumberModel)this.appletSizeSpinnerP.getModel()).getNumber().intValue();
            WebExport.setScriptButtonPercent(percent);
            return;
        }
    }
}

