/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.Hashtable;
import javajs.util.Lst;
import javajs.util.SB;
import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class PyMOLMeshReader
extends MapFileReader {
    private Lst<Object> data;
    private Lst<Object> voxelList;
    private String surfaceName;
    private int pymolType;
    private boolean isMesh;
    static final int cMapSourceCrystallographic = 1;
    static final int cMapSourceCCP4 = 2;
    static final int cMapSourceGeneralPurpose = 3;
    static final int cMapSourceDesc = 4;
    static final int cMapSourceFLD = 5;
    static final int cMapSourceBRIX = 6;
    static final int cMapSourceGRD = 7;
    static final int cMapSourceChempyBrick = 8;
    static final int cMapSourceVMDPlugin = 9;
    static final int cMapSourceObsolete = 10;
    static final int OBJECT_MAPDATA = 2;
    static final int OBJECT_MAPMESH = 3;
    private int pt;

    PyMOLMeshReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader brNull) {
        this.init2MFR(sg, null);
        this.allowSigma = true;
        this.nSurfaces = 1;
        Hashtable map = (Hashtable)sg.getReaderData();
        this.data = (Lst)map.get(this.params.calculationType);
        if (this.data == null) {
            return;
        }
        this.pymolType = (int)this.getFloat(PyMOLMeshReader.getList(this.data, 0), 0);
        this.isMesh = this.pymolType == 3;
        this.surfaceName = (String)this.data.get(this.data.size() - 1);
        Logger.info("PyMOLMeshReader for " + this.params.calculationType + " pymolType=" + this.pymolType + "; isMesh=" + this.isMesh + " surfaceName=" + this.surfaceName);
        this.data = PyMOLMeshReader.getList(PyMOLMeshReader.getList(this.data, 2), 0);
        if (this.isMesh && this.params.thePlane == null && this.params.cutoffAutomatic) {
            this.params.cutoff = this.getFloat(this.data, 8);
            this.params.cutoffAutomatic = false;
        }
        if (this.isMesh) {
            this.data = PyMOLMeshReader.getList(PyMOLMeshReader.getList((Lst)map.get(this.surfaceName), 2), 0);
        }
        this.voxelList = PyMOLMeshReader.getList(PyMOLMeshReader.getList(PyMOLMeshReader.getList(this.data, 14), 2), 6);
        Logger.info("PyMOLMeshReader: Number of grid points = " + this.voxelList.size());
    }

    private static Lst<Object> getList(Lst<Object> list, int i) {
        return (Lst)list.get(i);
    }

    @Override
    protected void readParameters() throws Exception {
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("PyMOL surface reader\n");
        this.jvxlFileHeaderBuffer.append(this.surfaceName + " (" + this.params.calculationType + ")\n");
        Lst<Object> s = PyMOLMeshReader.getList(this.data, 1);
        Lst<Object> t = PyMOLMeshReader.getList(s, 0);
        boolean haveUnitCell = false;
        if (t != null) {
            if (t.size() < 3) {
                s = PyMOLMeshReader.getList(s, 0);
                t = PyMOLMeshReader.getList(s, 0);
            }
            this.a = this.getFloat(t, 0);
            boolean bl = haveUnitCell = this.a != 1.0f;
            if (haveUnitCell) {
                this.b = this.getFloat(t, 1);
                this.c = this.getFloat(t, 2);
                t = PyMOLMeshReader.getList(s, 1);
                this.alpha = this.getFloat(t, 0);
                this.beta = this.getFloat(t, 1);
                this.gamma = this.getFloat(t, 2);
            }
        }
        t = PyMOLMeshReader.getList(this.data, 7);
        this.origin.set(this.getFloat(t, 0), this.getFloat(t, 1), this.getFloat(t, 2));
        t = PyMOLMeshReader.getList(this.data, 10);
        this.na = (int)this.getFloat(t, 0);
        this.nb = (int)this.getFloat(t, 1);
        this.nc = (int)this.getFloat(t, 2);
        t = PyMOLMeshReader.getList(this.data, 11);
        this.nxyzStart[0] = (int)this.getFloat(t, 0);
        this.nxyzStart[1] = (int)this.getFloat(t, 1);
        this.nxyzStart[2] = (int)this.getFloat(t, 2);
        t = PyMOLMeshReader.getList(this.data, 13);
        this.nz = (int)this.getFloat(t, 0);
        this.ny = (int)this.getFloat(t, 1);
        this.nx = (int)this.getFloat(t, 2);
        if (!haveUnitCell) {
            this.na = this.nz - 1;
            this.nb = this.ny - 1;
            this.nc = this.nx - 1;
            t = PyMOLMeshReader.getList(this.data, 8);
            this.a = this.getFloat(t, 0) - this.origin.x;
            this.b = this.getFloat(t, 1) - this.origin.y;
            this.c = this.getFloat(t, 2) - this.origin.z;
            this.gamma = 90.0f;
            this.beta = 90.0f;
            this.alpha = 90.0f;
        }
        this.mapc = 3;
        this.mapr = 2;
        this.maps = 1;
        this.getVectorsAndOrigin();
        this.setCutoffAutomatic();
    }

    @Override
    protected float nextVoxel() throws Exception {
        return this.getFloat(this.voxelList, this.pt++);
    }

    private float getFloat(Lst<Object> list, int i) {
        return ((Number)list.get(i)).floatValue();
    }

    @Override
    protected void skipData(int nPoints) throws Exception {
    }

    @Override
    protected void setCutoffAutomatic() {
        if (this.params.thePlane != null) {
            return;
        }
        if (Float.isNaN(this.params.sigma)) {
            if (!this.params.cutoffAutomatic) {
                return;
            }
            float f = this.params.cutoff = this.boundingBox == null ? 3.0f : 1.6f;
            if (this.dmin != Float.MAX_VALUE && this.params.cutoff > this.dmax) {
                this.params.cutoff = this.dmax / 4.0f;
            }
        } else {
            this.params.cutoff = this.calculateCutoff();
        }
        Logger.info("MapReader: setting cutoff to default value of " + this.params.cutoff + (this.boundingBox == null ? " (no BOUNDBOX parameter)\n" : "\n"));
    }

    private float calculateCutoff() {
        int n = this.voxelList.size();
        float sum = 0.0f;
        float sum2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            float v = this.getFloat(this.voxelList, i);
            sum += v;
            sum2 += v * v;
        }
        float mean = sum / (float)n;
        float rmsd = (float)Math.sqrt(sum2 / (float)n);
        Logger.info("PyMOLMeshReader rmsd=" + rmsd + " mean=" + mean);
        return this.params.sigma * rmsd + mean;
    }
}

