/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AbstractLineDecoration;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Polygon;
import java.io.IOException;

public class ArrowTip
extends AbstractLineDecoration {
    private double fAngle;
    private double fOuterRadius;
    private double fInnerRadius;
    private static final long serialVersionUID = -3459171428373823638L;
    private int arrowTipSerializedDataVersion = 1;

    public ArrowTip() {
        this(0.4, 8.0, 8.0);
    }

    public ArrowTip(double angle, double outerRadius, double innerRadius) {
        this.setAngle(angle);
        this.setOuterRadius(outerRadius);
        this.setInnerRadius(innerRadius);
    }

    public Polygon outline(int x1, int y1, int x2, int y2) {
        double dir = 1.5707963267948966 - Math.atan2(x2 - x1, y2 - y1);
        return this.outline(x1, y1, dir);
    }

    private Polygon outline(int x, int y, double direction) {
        Polygon shape = new Polygon();
        shape.addPoint(x, y);
        this.addPointRelative(shape, x, y, this.getOuterRadius(), direction - this.getAngle());
        this.addPointRelative(shape, x, y, this.getInnerRadius(), direction);
        this.addPointRelative(shape, x, y, this.getOuterRadius(), direction + this.getAngle());
        shape.addPoint(x, y);
        return shape;
    }

    private void addPointRelative(Polygon shape, int x, int y, double radius, double angle) {
        shape.addPoint(x + (int)(radius * Math.cos(angle)), y + (int)(radius * Math.sin(angle)));
    }

    public void write(StorableOutput dw) {
        dw.writeDouble(this.getAngle());
        dw.writeDouble(this.getOuterRadius());
        dw.writeDouble(this.getInnerRadius());
        super.write(dw);
    }

    public void read(StorableInput dr) throws IOException {
        this.setAngle(dr.readDouble());
        this.setOuterRadius(dr.readDouble());
        this.setInnerRadius(dr.readDouble());
        super.read(dr);
    }

    protected void setAngle(double newAngle) {
        this.fAngle = newAngle;
    }

    protected double getAngle() {
        return this.fAngle;
    }

    protected void setInnerRadius(double newInnerRadius) {
        this.fInnerRadius = newInnerRadius;
    }

    protected double getInnerRadius() {
        return this.fInnerRadius;
    }

    protected void setOuterRadius(double newOuterRadius) {
        this.fOuterRadius = newOuterRadius;
    }

    protected double getOuterRadius() {
        return this.fOuterRadius;
    }
}

