/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.BasePanel;
import ch.softenvironment.view.CommonUserAccess;
import ch.softenvironment.view.DataSelectorPanelListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JTextField;

public class DataSelectorPanel
extends BasePanel {
    private DataSelectorPanelListener listener = null;
    private List objects = null;
    private int currentIndex = -1;
    private JButton ivjTbbFirst = null;
    private JButton ivjTbbLast = null;
    private JButton ivjTbbNext = null;
    private JButton ivjTbbPrevious = null;
    private Object fieldCurrentObject = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JButton ivjTbbDelete = null;
    private JButton ivjTbbNew = null;
    private JTextField ivjTxtSelector = null;

    public DataSelectorPanel() {
        this.initialize();
    }

    public void addObject() {
        this.saveChanges();
        if (this.listener != null) {
            this.objects.add(this.listener.createObject());
            this.currentIndex = this.objects.size() - 1;
            this.setCurrentObject(this.objects.get(this.currentIndex));
        } else {
            Tracer.getInstance().developerError("make sure to have a listener");
        }
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.getFirst();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private Object connEtoC2(ActionEvent arg1) {
        Object connEtoC2Result = null;
        try {
            connEtoC2Result = this.getPrevious();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return connEtoC2Result;
    }

    private Object connEtoC3(ActionEvent arg1) {
        Object connEtoC3Result = null;
        try {
            connEtoC3Result = this.getNext();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return connEtoC3Result;
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.getLast();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(ActionEvent arg1) {
        try {
            this.addObject();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(ActionEvent arg1) {
        try {
            this.removeObject();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public Object getCurrentObject() {
        return this.fieldCurrentObject;
    }

    public Object getFirst() {
        this.saveChanges();
        if (this.currentIndex > 0) {
            this.currentIndex = 0;
            this.setCurrentObject(this.objects.get(this.currentIndex));
        }
        return this.getCurrentObject();
    }

    public Object getLast() {
        this.saveChanges();
        if (this.objects != null && this.currentIndex + 1 < this.objects.size()) {
            this.currentIndex = this.objects.size() - 1;
            this.setCurrentObject(this.objects.get(this.currentIndex));
        }
        return this.getCurrentObject();
    }

    public Object getNext() {
        if (this.objects != null && this.objects.size() > 0 && this.currentIndex + 1 < this.objects.size()) {
            this.saveChanges();
            this.setCurrentObject(this.objects.get(++this.currentIndex));
        } else {
            this.setCurrentObject(null);
        }
        return this.getCurrentObject();
    }

    public List getObjects() {
        this.saveChanges();
        return this.objects;
    }

    public Object getPrevious() {
        this.saveChanges();
        if (this.currentIndex > 0) {
            this.setCurrentObject(this.objects.get(--this.currentIndex));
        }
        return this.getCurrentObject();
    }

    private JButton getTbbDelete() {
        if (this.ivjTbbDelete == null) {
            try {
                this.ivjTbbDelete = new JButton();
                this.ivjTbbDelete.setName("TbbDelete");
                this.ivjTbbDelete.setToolTipText("Delete");
                this.ivjTbbDelete.setText("");
                this.ivjTbbDelete.setMaximumSize(new Dimension(23, 23));
                this.ivjTbbDelete.setHorizontalTextPosition(0);
                this.ivjTbbDelete.setVerticalTextPosition(3);
                this.ivjTbbDelete.setIcon(null);
                this.ivjTbbDelete.setPreferredSize(new Dimension(23, 23));
                this.ivjTbbDelete.setMargin(new Insets(0, 0, 0, 0));
                this.ivjTbbDelete.setEnabled(false);
                this.ivjTbbDelete.setMinimumSize(new Dimension(23, 23));
                this.ivjTbbDelete.setIcon(ResourceBundle.getImageIcon(DataSelectorPanel.class, "delete.gif"));
                this.ivjTbbDelete.setToolTipText(CommonUserAccess.getMniEditRemoveText());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTbbDelete;
    }

    private JButton getTbbFirst() {
        if (this.ivjTbbFirst == null) {
            try {
                this.ivjTbbFirst = new JButton();
                this.ivjTbbFirst.setName("TbbFirst");
                this.ivjTbbFirst.setToolTipText("First");
                this.ivjTbbFirst.setText("");
                this.ivjTbbFirst.setMaximumSize(new Dimension(23, 23));
                this.ivjTbbFirst.setHorizontalTextPosition(0);
                this.ivjTbbFirst.setVerticalTextPosition(3);
                this.ivjTbbFirst.setIcon(null);
                this.ivjTbbFirst.setPreferredSize(new Dimension(23, 23));
                this.ivjTbbFirst.setMargin(new Insets(0, 0, 0, 0));
                this.ivjTbbFirst.setEnabled(false);
                this.ivjTbbFirst.setMinimumSize(new Dimension(23, 23));
                this.ivjTbbFirst.setIcon(ResourceBundle.getImageIcon(DataSelectorPanel.class, "first_arrow.gif"));
                this.ivjTbbFirst.setToolTipText(ResourceManager.getResource(DataSelectorPanel.class, "TbbFirst_toolTipText"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTbbFirst;
    }

    private JButton getTbbLast() {
        if (this.ivjTbbLast == null) {
            try {
                this.ivjTbbLast = new JButton();
                this.ivjTbbLast.setName("TbbLast");
                this.ivjTbbLast.setToolTipText("Last");
                this.ivjTbbLast.setText("");
                this.ivjTbbLast.setMaximumSize(new Dimension(23, 23));
                this.ivjTbbLast.setHorizontalTextPosition(0);
                this.ivjTbbLast.setVerticalTextPosition(3);
                this.ivjTbbLast.setIcon(null);
                this.ivjTbbLast.setPreferredSize(new Dimension(23, 23));
                this.ivjTbbLast.setMargin(new Insets(0, 0, 0, 0));
                this.ivjTbbLast.setEnabled(false);
                this.ivjTbbLast.setMinimumSize(new Dimension(23, 23));
                this.ivjTbbLast.setIcon(ResourceBundle.getImageIcon(DataSelectorPanel.class, "last_arrow.gif"));
                this.ivjTbbLast.setToolTipText(ResourceManager.getResource(DataSelectorPanel.class, "TbbLast_toolTipText"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTbbLast;
    }

    private JButton getTbbNew() {
        if (this.ivjTbbNew == null) {
            try {
                this.ivjTbbNew = new JButton();
                this.ivjTbbNew.setName("TbbNew");
                this.ivjTbbNew.setToolTipText("New");
                this.ivjTbbNew.setText("");
                this.ivjTbbNew.setMaximumSize(new Dimension(23, 23));
                this.ivjTbbNew.setHorizontalTextPosition(0);
                this.ivjTbbNew.setVerticalTextPosition(3);
                this.ivjTbbNew.setIcon(null);
                this.ivjTbbNew.setPreferredSize(new Dimension(23, 23));
                this.ivjTbbNew.setMargin(new Insets(0, 0, 0, 0));
                this.ivjTbbNew.setEnabled(true);
                this.ivjTbbNew.setMinimumSize(new Dimension(23, 23));
                this.ivjTbbNew.setIcon(ResourceBundle.getImageIcon(DataSelectorPanel.class, "new.gif"));
                this.ivjTbbNew.setToolTipText(CommonUserAccess.getMniFileNewText());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTbbNew;
    }

    private JButton getTbbNext() {
        if (this.ivjTbbNext == null) {
            try {
                this.ivjTbbNext = new JButton();
                this.ivjTbbNext.setName("TbbNext");
                this.ivjTbbNext.setToolTipText("Next");
                this.ivjTbbNext.setText("");
                this.ivjTbbNext.setMaximumSize(new Dimension(23, 23));
                this.ivjTbbNext.setHorizontalTextPosition(0);
                this.ivjTbbNext.setVerticalTextPosition(3);
                this.ivjTbbNext.setIcon(null);
                this.ivjTbbNext.setPreferredSize(new Dimension(60, 23));
                this.ivjTbbNext.setMargin(new Insets(0, 0, 0, 0));
                this.ivjTbbNext.setEnabled(false);
                this.ivjTbbNext.setMinimumSize(new Dimension(23, 23));
                this.ivjTbbNext.setIcon(ResourceBundle.getImageIcon(DataSelectorPanel.class, "right_arrow.gif"));
                this.ivjTbbNext.setToolTipText(ResourceManager.getResource(DataSelectorPanel.class, "TbbNext_toolTipText"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTbbNext;
    }

    private JButton getTbbPrevious() {
        if (this.ivjTbbPrevious == null) {
            try {
                this.ivjTbbPrevious = new JButton();
                this.ivjTbbPrevious.setName("TbbPrevious");
                this.ivjTbbPrevious.setToolTipText("Previous");
                this.ivjTbbPrevious.setText("");
                this.ivjTbbPrevious.setMaximumSize(new Dimension(23, 23));
                this.ivjTbbPrevious.setHorizontalTextPosition(0);
                this.ivjTbbPrevious.setVerticalTextPosition(3);
                this.ivjTbbPrevious.setIcon(null);
                this.ivjTbbPrevious.setPreferredSize(new Dimension(60, 23));
                this.ivjTbbPrevious.setMargin(new Insets(0, 0, 0, 0));
                this.ivjTbbPrevious.setEnabled(false);
                this.ivjTbbPrevious.setMinimumSize(new Dimension(23, 23));
                this.ivjTbbPrevious.setIcon(ResourceBundle.getImageIcon(DataSelectorPanel.class, "left_arrow.gif"));
                this.ivjTbbPrevious.setToolTipText(ResourceManager.getResource(DataSelectorPanel.class, "TbbPrevious_toolTipText"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTbbPrevious;
    }

    private JTextField getTxtSelector() {
        if (this.ivjTxtSelector == null) {
            try {
                this.ivjTxtSelector = new JTextField();
                this.ivjTxtSelector.setName("TxtSelector");
                this.ivjTxtSelector.setText(" 0/0");
                this.ivjTxtSelector.setMaximumSize(new Dimension(150, 20));
                this.ivjTxtSelector.setPreferredSize(new Dimension(50, 20));
                this.ivjTxtSelector.setAlignmentX(0.5f);
                this.ivjTxtSelector.setMinimumSize(new Dimension(50, 20));
                this.ivjTxtSelector.setEditable(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxtSelector;
    }

    @Override
    protected void handleException(Throwable exception) {
        super.handleException(exception);
    }

    private void initConnections() throws Exception {
        this.getTbbFirst().addActionListener(this.ivjEventHandler);
        this.getTbbPrevious().addActionListener(this.ivjEventHandler);
        this.getTbbNext().addActionListener(this.ivjEventHandler);
        this.getTbbLast().addActionListener(this.ivjEventHandler);
        this.getTbbNew().addActionListener(this.ivjEventHandler);
        this.getTbbDelete().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.getTbbNew().setVisible(false);
            this.getTbbDelete().setVisible(false);
            if (this.objects == null) {
                this.getTbbFirst().setEnabled(false);
                this.getTbbPrevious().setEnabled(false);
                this.getTbbNext().setEnabled(false);
                this.getTbbLast().setEnabled(false);
                this.getTxtSelector().setEnabled(false);
            }
            this.setName("DataSelectorPanel");
            this.setPreferredSize(new Dimension(300, 23));
            this.setLayout(new BoxLayout(this, 0));
            this.setSize(264, 24);
            this.setMaximumSize(new Dimension(500, 23));
            this.setMinimumSize(new Dimension(300, 23));
            this.add((Component)this.getTbbFirst(), this.getTbbFirst().getName());
            this.add((Component)this.getTbbPrevious(), this.getTbbPrevious().getName());
            this.add((Component)this.getTxtSelector(), this.getTxtSelector().getName());
            this.add((Component)this.getTbbNext(), this.getTbbNext().getName());
            this.add((Component)this.getTbbLast(), this.getTbbLast().getName());
            this.add((Component)this.getTbbNew(), this.getTbbNew().getName());
            this.add((Component)this.getTbbDelete(), this.getTbbDelete().getName());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void removeObject() {
        if (this.listener != null) {
            this.listener.removeObject(this.getCurrentObject());
            if (this.currentIndex > 0) {
                this.objects.remove(this.getCurrentObject());
                this.setCurrentObject(this.objects.get(--this.currentIndex));
            } else {
                this.objects.remove(this.currentIndex);
                if (this.objects.size() > 0) {
                    this.setCurrentObject(this.objects.get(this.currentIndex));
                } else {
                    this.setCurrentObject(null);
                }
            }
        } else {
            Tracer.getInstance().developerError("make sure to have a listener");
        }
    }

    private void saveChanges() {
        if (this.listener != null && this.getCurrentObject() != null) {
            this.objects.set(this.currentIndex, this.listener.saveChanges(this.getCurrentObject()));
        }
    }

    public void setCurrentObject(Object currentObject) {
        Object oldValue = this.fieldCurrentObject;
        this.fieldCurrentObject = currentObject;
        this.firePropertyChange("currentObject", oldValue, currentObject);
        this.treatNextPreviousButtons();
        if (this.listener != null) {
            this.listener.setCurrentObject(currentObject);
        }
    }

    public void setListener(DataSelectorPanelListener listener) {
        this.listener = listener;
        this.getTbbNew().setVisible(listener != null);
    }

    public void setObjects(List objects) {
        this.currentIndex = -1;
        this.objects = objects;
        this.getNext();
    }

    private void treatNextPreviousButtons() {
        boolean prev = this.currentIndex > 0;
        this.getTbbPrevious().setEnabled(prev);
        if (this.objects != null && this.objects.size() > 0) {
            boolean next = this.currentIndex + 1 < this.objects.size();
            this.getTbbNext().setEnabled(next);
            this.getTbbLast().setEnabled(next);
            this.getTbbDelete().setEnabled(true);
            this.getTxtSelector().setText(" " + (this.currentIndex + 1) + "/" + this.objects.size() + " ");
            this.getTbbFirst().setEnabled(this.currentIndex > 0);
            this.getTbbLast().setEnabled(this.currentIndex + 1 < this.objects.size());
        } else {
            this.getTbbNext().setEnabled(false);
            this.getTbbLast().setEnabled(false);
            this.getTbbDelete().setEnabled(false);
            this.getTxtSelector().setText(" 0/0  ");
            this.getTbbFirst().setEnabled(false);
            this.getTbbLast().setEnabled(false);
        }
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DataSelectorPanel.this.getTbbFirst()) {
                DataSelectorPanel.this.connEtoC1(e);
            }
            if (e.getSource() == DataSelectorPanel.this.getTbbPrevious()) {
                DataSelectorPanel.this.connEtoC2(e);
            }
            if (e.getSource() == DataSelectorPanel.this.getTbbNext()) {
                DataSelectorPanel.this.connEtoC3(e);
            }
            if (e.getSource() == DataSelectorPanel.this.getTbbLast()) {
                DataSelectorPanel.this.connEtoC4(e);
            }
            if (e.getSource() == DataSelectorPanel.this.getTbbNew()) {
                DataSelectorPanel.this.connEtoC5(e);
            }
            if (e.getSource() == DataSelectorPanel.this.getTbbDelete()) {
                DataSelectorPanel.this.connEtoC6(e);
            }
        }
    }
}

