/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.BadNameException;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.XMIException;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIName;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public abstract class DataImpl
implements Data {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private String xmiName;
    private Data definer;
    private Data derived;
    private Data source;
    private Data owner;
    private XMIFile file;
    private Namespace namespace;
    private Vector defined;
    private Object user;
    private Hashtable sets;

    public DataImpl() {
    }

    public DataImpl(String string) {
        this.xmiName = string;
    }

    public DataImpl(Data data) {
        this.definer = data;
    }

    public void addXMIDefined(Data data) {
        if (this.defined == null) {
            this.defined = new Vector(5);
        }
        this.defined.addElement(data);
    }

    public void deleteXMIDefined(Data data) {
        if (this.defined == null) {
            return;
        }
        this.defined.removeElement(data);
    }

    public Collection getXMIDefined() {
        if (this.defined == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.defined);
    }

    public Data getXMIDefiner() {
        return this.definer;
    }

    public Data getXMIDerived() {
        return this.derived;
    }

    public XMIFile getXMIFile() {
        return this.file;
    }

    public Namespace getXMINamespace() {
        if (this.getXMIDefiner() != null) {
            return this.getXMIDefiner().getXMINamespace();
        }
        return this.namespace;
    }

    public String getXMIName() {
        if (this.definer == null) {
            if (this.namespace == null || this.namespace.getPrefix() == null || this.namespace.getPrefix().equals("")) {
                return this.xmiName;
            }
            return this.namespace.getPrefix() + ":" + this.xmiName;
        }
        return this.definer.getXMIName();
    }

    public Object getXMIUserData() {
        return this.user;
    }

    public Data getXMIOwner() {
        return this.owner;
    }

    public Data getXMISource() {
        return this.source;
    }

    public Collection getXMISets() {
        Vector vector = new Vector();
        if (this.sets == null) {
            return vector;
        }
        Enumeration enumeration = this.sets.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public String getXMITagValue(String string, String string2) {
        if (this.sets == null) {
            return null;
        }
        Properties properties = (Properties)this.sets.get(string);
        if (properties == null) {
            return null;
        }
        return properties.getProperty(string2);
    }

    public Collection getXMITags(String string) {
        Vector vector = new Vector();
        if (this.sets == null) {
            return vector;
        }
        Properties properties = (Properties)this.sets.get(string);
        if (properties == null) {
            return vector;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public void setXMIDefiner(Data data) throws XMIException {
        this.definer = data;
    }

    public void setXMIDerived(Data data) {
        this.derived = data;
    }

    public void setXMIFile(XMIFile xMIFile) {
        this.file = xMIFile;
    }

    public void setXMINamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public void setXMIName(String string) throws XMIException {
        if (!XMIName.isLegal(string)) {
            throw new BadNameException(string);
        }
        this.xmiName = string;
    }

    public void setXMIOwner(Data data) {
        this.owner = data;
    }

    public void setXMISource(Data data) {
        this.source = data;
    }

    public void setXMIUserData(Object object) {
        this.user = object;
    }

    public void setXMITagValue(String string, String string2, String string3) {
        Properties properties;
        if (this.sets == null) {
            this.sets = new Hashtable(5);
        }
        if ((properties = (Properties)this.sets.get(string)) == null) {
            properties = new Properties();
            this.sets.put(string, properties);
        }
        if (string3 == null) {
            ((Hashtable)properties).remove(string2);
            if (((Hashtable)properties).isEmpty()) {
                this.sets.remove(string);
            }
        } else {
            ((Hashtable)properties).put(string2, string3);
        }
    }

    public String toString() {
        return this.getXMIName();
    }
}

